/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.jetty.jetty.servlet;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.openqa.jetty.http.HttpConnection;
import org.openqa.jetty.http.HttpFields;
import org.openqa.jetty.http.HttpInputStream;
import org.openqa.jetty.http.HttpRequest;
import org.openqa.jetty.jetty.servlet.ServletHandler;
import org.openqa.jetty.jetty.servlet.ServletHolder;
import org.openqa.jetty.jetty.servlet.ServletHttpResponse;
import org.openqa.jetty.jetty.servlet.ServletIn;
import org.openqa.jetty.jetty.servlet.SessionManager;
import org.openqa.jetty.log.LogFactory;
import org.openqa.jetty.util.LazyList;
import org.openqa.jetty.util.Resource;
import org.openqa.jetty.util.StringUtil;
import org.openqa.jetty.util.URI;

public class ServletHttpRequest
implements HttpServletRequest {
    private static Log log = LogFactory.getLog(ServletHttpRequest.class);
    public static final String __SESSIONID_NOT_CHECKED = "not checked";
    public static final String __SESSIONID_URL = "url";
    public static final String __SESSIONID_COOKIE = "cookie";
    public static final String __SESSIONID_NONE = "none";
    private static final Enumeration __emptyEnum = Collections.enumeration(Collections.EMPTY_LIST);
    private static final Collection __defaultLocale = Collections.singleton(Locale.getDefault());
    private ServletHandler _servletHandler;
    private HttpRequest _httpRequest;
    private ServletHttpResponse _servletHttpResponse;
    private String _contextPath = null;
    private String _servletPath = null;
    private String _pathInfo = null;
    private String _query = null;
    private String _pathTranslated = null;
    private String _requestedSessionId = null;
    private HttpSession _session = null;
    private String _sessionIdState = "not checked";
    private ServletIn _in = null;
    private BufferedReader _reader = null;
    private int _inputState = 0;
    private ServletHolder _servletHolder;
    private String _pathInContext;

    public ServletHttpRequest(ServletHandler servletHandler, String pathInContext, HttpRequest request) {
        this._servletHandler = servletHandler;
        this._pathInContext = pathInContext;
        this._contextPath = this._servletHandler.getHttpContext().getContextPath();
        if (this._contextPath.length() <= 1) {
            this._contextPath = "";
        }
        this._httpRequest = request;
    }

    void recycle(ServletHandler servletHandler, String pathInContext) {
        this._servletHandler = servletHandler;
        this._pathInContext = pathInContext;
        this._servletPath = null;
        this._pathInfo = null;
        this._query = null;
        this._pathTranslated = null;
        this._requestedSessionId = null;
        this._session = null;
        this._sessionIdState = __SESSIONID_NOT_CHECKED;
        this._in = null;
        this._reader = null;
        this._inputState = 0;
        this._servletHolder = null;
        if (servletHandler != null) {
            this._contextPath = this._servletHandler.getHttpContext().getContextPath();
        }
        if (this._contextPath != null && this._contextPath.length() <= 1) {
            this._contextPath = "";
        }
    }

    ServletHandler getServletHandler() {
        return this._servletHandler;
    }

    void setServletHandler(ServletHandler servletHandler) {
        this._servletHandler = servletHandler;
    }

    void setServletPaths(String servletPath, String pathInfo, ServletHolder holder) {
        this._servletPath = servletPath;
        this._pathInfo = pathInfo;
        this._servletHolder = holder;
    }

    ServletHolder getServletHolder() {
        return this._servletHolder;
    }

    String getPathInContext() {
        return this._pathInContext;
    }

    HttpRequest getHttpRequest() {
        return this._httpRequest;
    }

    public ServletHttpResponse getServletHttpResponse() {
        return this._servletHttpResponse;
    }

    void setServletHttpResponse(ServletHttpResponse response) {
        this._servletHttpResponse = response;
    }

    @Override
    public Locale getLocale() {
        Enumeration enm = this._httpRequest.getFieldValues("Accept-Language", ", \t");
        if (enm == null || !enm.hasMoreElements()) {
            return Locale.getDefault();
        }
        List acceptLanguage = HttpFields.qualityList(enm);
        if (acceptLanguage.size() == 0) {
            return Locale.getDefault();
        }
        int i = 0;
        int size = acceptLanguage.size();
        if (i < size) {
            String language = (String)acceptLanguage.get(i);
            language = HttpFields.valueParameters(language, null);
            String country = "";
            int dash = language.indexOf(45);
            if (dash > -1) {
                country = language.substring(dash + 1).trim();
                language = language.substring(0, dash).trim();
            }
            return new Locale(language, country);
        }
        return Locale.getDefault();
    }

    @Override
    public Enumeration getLocales() {
        Enumeration enm = this._httpRequest.getFieldValues("Accept-Language", ", \t");
        if (enm == null || !enm.hasMoreElements()) {
            return Collections.enumeration(__defaultLocale);
        }
        List acceptLanguage = HttpFields.qualityList(enm);
        if (acceptLanguage.size() == 0) {
            return Collections.enumeration(__defaultLocale);
        }
        Object langs = null;
        int size = acceptLanguage.size();
        int i = 0;
        while (i < size) {
            String language = (String)acceptLanguage.get(i);
            language = HttpFields.valueParameters(language, null);
            String country = "";
            int dash = language.indexOf(45);
            if (dash > -1) {
                country = language.substring(dash + 1).trim();
                language = language.substring(0, dash).trim();
            }
            langs = LazyList.ensureSize(langs, size);
            langs = LazyList.add(langs, new Locale(language, country));
            ++i;
        }
        if (LazyList.size(langs) == 0) {
            return Collections.enumeration(__defaultLocale);
        }
        return Collections.enumeration(LazyList.getList(langs));
    }

    @Override
    public boolean isSecure() {
        return this._httpRequest.isConfidential();
    }

    @Override
    public Cookie[] getCookies() {
        Cookie[] cookies = this._httpRequest.getCookies();
        if (cookies.length == 0) {
            return null;
        }
        return cookies;
    }

    @Override
    public long getDateHeader(String name) {
        return this._httpRequest.getDateField(name);
    }

    @Override
    public Enumeration getHeaderNames() {
        return this._httpRequest.getFieldNames();
    }

    @Override
    public String getHeader(String name) {
        return this._httpRequest.getField(name);
    }

    @Override
    public Enumeration getHeaders(String s) {
        Enumeration enm = this._httpRequest.getFieldValues(s);
        if (enm == null) {
            return __emptyEnum;
        }
        return enm;
    }

    @Override
    public int getIntHeader(String name) throws NumberFormatException {
        return this._httpRequest.getIntField(name);
    }

    @Override
    public String getMethod() {
        return this._httpRequest.getMethod();
    }

    @Override
    public String getContextPath() {
        return this._contextPath;
    }

    @Override
    public String getPathInfo() {
        if (this._servletPath == null) {
            return null;
        }
        return this._pathInfo;
    }

    @Override
    public String getPathTranslated() {
        if (this._pathInfo == null || this._pathInfo.length() == 0) {
            return null;
        }
        if (this._pathTranslated == null) {
            File file;
            block6: {
                Resource resource = this._servletHandler.getHttpContext().getBaseResource();
                if (resource == null) {
                    return null;
                }
                resource = resource.addPath(this._pathInfo);
                file = resource.getFile();
                if (file != null) break block6;
                return null;
            }
            try {
                this._pathTranslated = file.getAbsolutePath();
            }
            catch (Exception e) {
                log.debug("EXCEPTION ", e);
            }
        }
        return this._pathTranslated;
    }

    @Override
    public String getQueryString() {
        if (this._query == null) {
            this._query = this._httpRequest.getQuery();
        }
        return this._query;
    }

    @Override
    public String getAuthType() {
        String at = this._httpRequest.getAuthType();
        if (at == "BASIC") {
            return "BASIC";
        }
        if (at == "FORM") {
            return "FORM";
        }
        if (at == "DIGEST") {
            return "DIGEST";
        }
        if (at == "CLIENT_CERT") {
            return "CLIENT_CERT";
        }
        if (at == "CLIENT-CERT") {
            return "CLIENT_CERT";
        }
        return at;
    }

    @Override
    public String getRemoteUser() {
        return this._httpRequest.getAuthUser();
    }

    @Override
    public boolean isUserInRole(String role) {
        if (this._servletHolder != null) {
            role = this._servletHolder.getUserRoleLink(role);
        }
        return this._httpRequest.isUserInRole(role);
    }

    @Override
    public Principal getUserPrincipal() {
        return this._httpRequest.getUserPrincipal();
    }

    void setRequestedSessionId(String pathParams) {
        Cookie[] cookies;
        this._requestedSessionId = null;
        if (this._servletHandler.isUsingCookies() && (cookies = this._httpRequest.getCookies()) != null && cookies.length > 0) {
            int i = 0;
            while (i < cookies.length) {
                if (SessionManager.__SessionCookie.equalsIgnoreCase(cookies[i].getName())) {
                    if (this._requestedSessionId != null) {
                        SessionManager manager = this._servletHandler.getSessionManager();
                        if (manager != null && manager.getHttpSession(this._requestedSessionId) != null) break;
                        log.debug("multiple session cookies");
                    }
                    this._requestedSessionId = cookies[i].getValue();
                    this._sessionIdState = __SESSIONID_COOKIE;
                    if (log.isDebugEnabled()) {
                        log.debug("Got Session " + this._requestedSessionId + " from cookie");
                    }
                }
                ++i;
            }
        }
        if (pathParams != null && pathParams.startsWith(SessionManager.__SessionURL)) {
            String id = pathParams.substring(SessionManager.__SessionURL.length() + 1);
            if (log.isDebugEnabled()) {
                log.debug("Got Session " + id + " from URL");
            }
            if (this._requestedSessionId == null) {
                this._requestedSessionId = id;
                this._sessionIdState = __SESSIONID_URL;
            } else if (!id.equals(this._requestedSessionId)) {
                log.debug("Mismatched session IDs");
            }
        }
        if (this._requestedSessionId == null) {
            this._sessionIdState = __SESSIONID_NONE;
        }
    }

    @Override
    public String getRequestedSessionId() {
        return this._requestedSessionId;
    }

    @Override
    public String getRequestURI() {
        return this._httpRequest.getEncodedPath();
    }

    @Override
    public StringBuffer getRequestURL() {
        StringBuffer buf = this._httpRequest.getRootURL();
        buf.append(this.getRequestURI());
        return buf;
    }

    @Override
    public String getServletPath() {
        if (this._servletPath == null) {
            return this._pathInContext;
        }
        return this._servletPath;
    }

    @Override
    public HttpSession getSession(boolean create) {
        if (this._session != null && ((SessionManager.Session)this._session).isValid()) {
            return this._session;
        }
        this._session = null;
        String id = this.getRequestedSessionId();
        if (id != null) {
            this._session = this._servletHandler.getHttpSession(id);
            if (this._session == null && !create) {
                return null;
            }
        }
        if (this._session == null && create) {
            this._session = this.newSession();
        }
        return this._session;
    }

    HttpSession newSession() {
        HttpSession session = this._servletHandler.newHttpSession(this);
        Cookie cookie = this._servletHandler.getSessionManager().getSessionCookie(session, this.isSecure());
        if (cookie != null) {
            this._servletHttpResponse.getHttpResponse().addSetCookie(cookie);
        }
        return session;
    }

    @Override
    public HttpSession getSession() {
        HttpSession session = this.getSession(true);
        return session;
    }

    @Override
    public boolean isRequestedSessionIdValid() {
        return this._requestedSessionId != null && this.getSession(false) != null;
    }

    @Override
    public boolean isRequestedSessionIdFromCookie() {
        return this._sessionIdState == __SESSIONID_COOKIE;
    }

    @Override
    public boolean isRequestedSessionIdFromURL() {
        return this._sessionIdState == __SESSIONID_URL;
    }

    @Override
    @Deprecated
    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    @Override
    public Enumeration getAttributeNames() {
        return this._httpRequest.getAttributeNames();
    }

    @Override
    public Object getAttribute(String name) {
        return this._httpRequest.getAttribute(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this._httpRequest.setAttribute(name, value);
    }

    @Override
    public void removeAttribute(String name) {
        this._httpRequest.removeAttribute(name);
    }

    @Override
    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        if (this._inputState != 0) {
            throw new IllegalStateException("getReader() or getInputStream() called");
        }
        "".getBytes(encoding);
        this._httpRequest.setCharacterEncoding(encoding, false);
    }

    @Override
    public String getCharacterEncoding() {
        return this._httpRequest.getCharacterEncoding();
    }

    @Override
    public int getContentLength() {
        return this._httpRequest.getContentLength();
    }

    @Override
    public String getContentType() {
        return this._httpRequest.getContentType();
    }

    @Override
    public ServletInputStream getInputStream() {
        if (this._inputState != 0 && this._inputState != 1) {
            throw new IllegalStateException();
        }
        if (this._in == null) {
            this._in = new ServletIn((HttpInputStream)this._httpRequest.getInputStream());
        }
        this._inputState = 1;
        this._reader = null;
        return this._in;
    }

    @Override
    public Map getParameterMap() {
        return Collections.unmodifiableMap(this._httpRequest.getParameterStringArrayMap());
    }

    @Override
    public String getParameter(String name) {
        return this._httpRequest.getParameter(name);
    }

    @Override
    public Enumeration getParameterNames() {
        return Collections.enumeration(this._httpRequest.getParameterNames());
    }

    @Override
    public String[] getParameterValues(String name) {
        List v = this._httpRequest.getParameterValues(name);
        if (v == null) {
            return null;
        }
        String[] a = new String[v.size()];
        return v.toArray(a);
    }

    @Override
    public String getProtocol() {
        return this._httpRequest.getVersion();
    }

    @Override
    public String getScheme() {
        return this._httpRequest.getScheme();
    }

    @Override
    public String getServerName() {
        return this._httpRequest.getHost();
    }

    @Override
    public int getServerPort() {
        int port = this._httpRequest.getPort();
        if (port == 0) {
            if (this.getScheme().equalsIgnoreCase("https")) {
                return 443;
            }
            return 80;
        }
        return port;
    }

    @Override
    public int getRemotePort() {
        HttpConnection connection = this._httpRequest.getHttpConnection();
        if (connection != null) {
            return connection.getRemotePort();
        }
        return 0;
    }

    @Override
    public String getLocalName() {
        HttpConnection connection = this._httpRequest.getHttpConnection();
        if (connection != null) {
            return connection.getServerName();
        }
        return null;
    }

    @Override
    public String getLocalAddr() {
        HttpConnection connection = this._httpRequest.getHttpConnection();
        if (connection != null) {
            return connection.getServerAddr();
        }
        return null;
    }

    @Override
    public int getLocalPort() {
        HttpConnection connection = this._httpRequest.getHttpConnection();
        if (connection != null) {
            return connection.getServerPort();
        }
        return 0;
    }

    @Override
    public BufferedReader getReader() throws UnsupportedEncodingException {
        if (this._inputState != 0 && this._inputState != 2) {
            throw new IllegalStateException();
        }
        if (this._reader == null) {
            String encoding = this.getCharacterEncoding();
            if (encoding == null) {
                encoding = StringUtil.__ISO_8859_1;
            }
            this._reader = new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), encoding));
        }
        this._inputState = 2;
        return this._reader;
    }

    @Override
    public String getRemoteAddr() {
        return this._httpRequest.getRemoteAddr();
    }

    @Override
    public String getRemoteHost() {
        if (this._httpRequest.getHttpConnection() == null) {
            return null;
        }
        return this._httpRequest.getRemoteHost();
    }

    @Override
    @Deprecated
    public String getRealPath(String path) {
        return this._servletHandler.getServletContext().getRealPath(path);
    }

    @Override
    public RequestDispatcher getRequestDispatcher(String url) {
        if (url == null) {
            return null;
        }
        if (!url.startsWith("/")) {
            String relTo = URI.addPaths(this._servletPath, this._pathInfo);
            int slash = relTo.lastIndexOf("/");
            relTo = slash > 1 ? relTo.substring(0, slash + 1) : "/";
            url = URI.addPaths(relTo, url);
        }
        return this._servletHandler.getServletContext().getRequestDispatcher(url);
    }

    public String toString() {
        return String.valueOf(this.getContextPath()) + "+" + this.getServletPath() + "+" + this.getPathInfo() + "\n" + this._httpRequest.toString();
    }

    public static ServletHttpRequest unwrap(ServletRequest request) {
        while (!(request instanceof ServletHttpRequest)) {
            if (request instanceof ServletRequestWrapper) {
                ServletRequestWrapper wrapper = (ServletRequestWrapper)request;
                request = wrapper.getRequest();
                continue;
            }
            throw new IllegalArgumentException("Does not wrap ServletHttpRequest");
        }
        return (ServletHttpRequest)request;
    }
}

