/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.adaptor.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Comparator;
import mx4j.log.Log;
import mx4j.log.Logger;
import mx4j.tools.adaptor.http.HttpException;
import mx4j.tools.adaptor.http.HttpInputStream;
import mx4j.tools.adaptor.http.HttpOutputStream;
import mx4j.tools.adaptor.http.ProcessorMBean;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultProcessor
implements ProcessorMBean {
    private static final String ENCODING = "UTF-8";
    private boolean canonical = false;

    public String getName() {
        return "Default XML Processor";
    }

    private Logger getLogger() {
        return Log.getLogger(this.getClass().getName());
    }

    public void writeResponse(HttpOutputStream out, HttpInputStream in, Document document) throws IOException {
        out.setCode(200);
        out.setHeader("Content-Type", "text/xml");
        out.sendHeaders();
        this.print(new PrintWriter(out), document);
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        this.print(new PrintWriter(o), document);
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(10)) {
            logger.debug(new String(o.toByteArray()));
        }
    }

    public void writeError(HttpOutputStream out, HttpInputStream in, Exception e) throws IOException {
        if (e instanceof HttpException) {
            out.setCode(((HttpException)e).getCode());
            out.setHeader("Content-Type", "text/xml");
            out.sendHeaders();
            this.print(new PrintWriter(out), ((HttpException)e).getResponseDoc());
        }
    }

    public String preProcess(String path) {
        if (path.equals("/")) {
            path = "/server";
        }
        return path;
    }

    public String notFoundElement(String path, HttpOutputStream out, HttpInputStream in) throws IOException, HttpException {
        throw new HttpException(404, "Path " + path + " not found");
    }

    protected void print(PrintWriter out, Node node) {
        if (node == null) {
            return;
        }
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                if (!this.canonical) {
                    out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                }
                NodeList children = node.getChildNodes();
                for (int iChild = 0; iChild < children.getLength(); ++iChild) {
                    this.print(out, children.item(iChild));
                }
                out.flush();
                break;
            }
            case 1: {
                out.print('<');
                out.print(node.getNodeName());
                Attr[] attrs = this.sortAttributes(node.getAttributes());
                for (int i = 0; i < attrs.length; ++i) {
                    Attr attr = attrs[i];
                    out.print(' ');
                    out.print(attr.getNodeName());
                    out.print("=\"");
                    out.print(this.normalize(attr.getNodeValue()));
                    out.print('\"');
                }
                out.print('>');
                NodeList children = node.getChildNodes();
                if (children == null) break;
                int len = children.getLength();
                for (int i = 0; i < len; ++i) {
                    this.print(out, children.item(i));
                }
                break;
            }
            case 5: {
                if (this.canonical) {
                    NodeList children = node.getChildNodes();
                    if (children == null) break;
                    int len = children.getLength();
                    for (int i = 0; i < len; ++i) {
                        this.print(out, children.item(i));
                    }
                    break;
                }
                out.print('&');
                out.print(node.getNodeName());
                out.print(';');
                break;
            }
            case 4: {
                if (this.canonical) {
                    out.print(this.normalize(node.getNodeValue()));
                    break;
                }
                out.print("<![CDATA[");
                out.print(node.getNodeValue());
                out.print("]]>");
                break;
            }
            case 3: {
                out.print(this.normalize(node.getNodeValue()));
                break;
            }
            case 7: {
                out.print("<?");
                out.print(node.getNodeName());
                String data = node.getNodeValue();
                if (data != null && data.length() > 0) {
                    out.print(' ');
                    out.print(data);
                }
                out.println("?>");
                break;
            }
        }
        if (type == 1) {
            out.print("</");
            out.print(node.getNodeName());
            out.print('>');
        }
        out.flush();
    }

    protected Attr[] sortAttributes(NamedNodeMap attrs) {
        int len = attrs != null ? attrs.getLength() : 0;
        Attr[] array = new Attr[len];
        for (int i = 0; i < len; ++i) {
            array[i] = (Attr)attrs.item(i);
        }
        Arrays.sort(array, new Comparator(){

            public int compare(Object o1, Object o2) {
                Attr attr1 = (Attr)o1;
                Attr attr2 = (Attr)o2;
                return attr1.getNodeName().compareTo(attr2.getNodeName());
            }
        });
        return array;
    }

    protected String normalize(String s) {
        StringBuffer str = new StringBuffer();
        int len = s != null ? s.length() : 0;
        block8: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    continue block8;
                }
                case '>': {
                    str.append("&gt;");
                    continue block8;
                }
                case '&': {
                    str.append("&amp;");
                    continue block8;
                }
                case '\"': {
                    str.append("&quot;");
                    continue block8;
                }
                case '\'': {
                    str.append("&apos;");
                    continue block8;
                }
                case '\n': 
                case '\r': {
                    if (this.canonical) {
                        str.append("&#");
                        str.append(Integer.toString(ch));
                        str.append(';');
                        continue block8;
                    }
                    str.append(ch);
                    continue block8;
                }
                default: {
                    str.append(ch);
                }
            }
        }
        return str.toString();
    }
}

