<?php
/**
 * Constants for PHP_CompatInfo 1.1.1 or better
 *
 * PHP versions 4 and 5
 *
 * @category PHP
 * @package  PHP_CompatInfo
 * @author   Davey Shafik <davey@php.net>
 * @author   Laurent Laville <pear@laurent-laville.org>
 * @license  http://www.php.net/license/3_01.txt  PHP License 3.01
 * @version  CVS: $Id: const_array.php,v 1.11 2008/02/03 21:32:09 farell Exp $
 * @link     http://pear.php.net/package/PHP_CompatInfo
 * @global   array $GLOBALS['_PHP_COMPATINFO_CONST']
 * @ignore
 */

/**
 * @link http://www.php.net/manual/en/reserved.constants.php
 *       Core Predefined Constants
 * @link http://www.php.net/manual/en/ref.datetime.php
 *       Date Predefined Constants
 * @link http://www.php.net/features.commandline
 *       Using PHP from the command line: CLI specific Constants
 * @link http://www.php.net/features.file-upload.errors
 *       File Upload Error specific Constants
 */

$GLOBALS['_PHP_COMPATINFO_CONST'] = array (
  '__FILE__' =>
  array (
    'init' => '4.0.0',
    'name' => '__FILE__',
  ),
  '__LINE__' =>
  array (
    'init' => '4.0.0',
    'name' => '__LINE__',
  ),
  '__FUNCTION__' =>
  array (
    'init' => '4.3.0',
    'name' => '__FUNCTION__',
  ),
  '__CLASS__' =>
  array (
    'init' => '4.3.0',
    'name' => '__CLASS__',
  ),
  '__METHOD__' =>
  array (
    'name' => '__METHOD__',
    'init' => '5.0.0',
  ),
  'ABSTRACT' =>
  array (
    'init' => '5.0.0',
    'name' => 'abstract',
  ),
  'CATCH' =>
  array (
    'init' => '5.0.0',
    'name' => 'catch',
  ),
  'FINAL' =>
  array (
    'init' => '5.0.0',
    'name' => 'final',
  ),
  'INSTANCEOF' =>
  array (
    'init' => '5.0.0',
    'name' => 'instanceof',
  ),
  'PRIVATE' =>
  array (
    'init' => '5.0.0',
    'name' => 'private',
  ),
  'PROTECTED' =>
  array (
    'init' => '5.0.0',
    'name' => 'protected',
  ),
  'PUBLIC' =>
  array (
    'init' => '5.0.0',
    'name' => 'public',
  ),
  'THROW' =>
  array (
    'init' => '5.0.0',
    'name' => 'throw',
  ),
  'TRY' =>
  array (
    'init' => '5.0.0',
    'name' => 'try',
  ),
  'CLONE' =>
  array (
    'init' => '5.0.0',
    'name' => 'clone',
  ),
  'INTERFACE' =>
  array (
    'init' => '5.0.0',
    'name' => 'interface',
  ),
  'IMPLEMENTS' =>
  array (
    'init' => '5.0.0',
    'name' => 'implements',
  ),
  'DATE_ATOM' =>
  array (
    'init' => '5.1.1',
    'name' => 'DATE_ATOM',
  ),
  'DATE_COOKIE' =>
  array (
    'init' => '5.1.1',
    'name' => 'DATE_COOKIE',
  ),
  'DATE_ISO8601' =>
  array (
    'init' => '5.1.1',
    'name' => 'DATE_ISO8601',
  ),
  'DATE_RFC822' =>
  array (
    'init' => '5.1.1',
    'name' => 'DATE_RFC822',
  ),
  'DATE_RFC850' =>
  array (
    'init' => '5.1.1',
    'name' => 'DATE_RFC850',
  ),
  'DATE_RFC1036' =>
  array (
    'init' => '5.1.1',
    'name' => 'DATE_RFC1036',
  ),
  'DATE_RFC1123' =>
  array (
    'init' => '5.1.1',
    'name' => 'DATE_RFC1123',
  ),
  'DATE_RFC2822' =>
  array (
    'init' => '5.1.1',
    'name' => 'DATE_RFC2822',
  ),
  'DATE_RFC3339' =>
  array (
    'init' => '5.1.3',
    'name' => 'DATE_RFC3339',
  ),
  'DATE_RSS' =>
  array (
    'init' => '5.1.1',
    'name' => 'DATE_RSS',
  ),
  'DATE_W3C' =>
  array (
    'init' => '5.1.1',
    'name' => 'DATE_W3C',
  ),
  'PHP_EOL' =>
  array (
    'init' => '4.3.10',
    'name' => 'PHP_EOL',
  ),
  'DIRECTORY_SEPARATOR' =>
  array (
    'init' => '4.0.6',
    'name' => 'DIRECTORY_SEPARATOR',
  ),
  'E_STRICT' =>
  array (
    'init' => '5.0.0',
    'name' => 'E_STRICT',
  ),
  'PATH_SEPARATOR' =>
  array (
    'init' => '4.3.0',
    'name' => 'PATH_SEPARATOR',
  ),
  'STDIN' =>
  array (
    'init' => '4.3.0',
    'name' => 'STDIN',
  ),
  'STDOUT' =>
  array (
    'init' => '4.3.0',
    'name' => 'STDOUT',
  ),
  'STDERR' =>
  array (
    'init' => '4.3.0',
    'name' => 'STDERR',
  ),
  'UPLOAD_ERR_OK' =>
  array (
    'init' => '4.3.0',
    'name' => 'UPLOAD_ERR_OK',
  ),
  'UPLOAD_ERR_INI_SIZE' =>
  array (
    'init' => '4.3.0',
    'name' => 'UPLOAD_ERR_INI_SIZE',
  ),
  'UPLOAD_ERR_FORM_SIZE' =>
  array (
    'init' => '4.3.0',
    'name' => 'UPLOAD_ERR_FORM_SIZE',
  ),
  'UPLOAD_ERR_PARTIAL' =>
  array (
    'init' => '4.3.0',
    'name' => 'UPLOAD_ERR_PARTIAL',
  ),
  'UPLOAD_ERR_NO_FILE' =>
  array (
    'init' => '4.3.0',
    'name' => 'UPLOAD_ERR_NO_FILE',
  ),
  'UPLOAD_ERR_NO_TMP_DIR' =>
  array (
    'init' => '4.3.10',
    'name' => 'UPLOAD_ERR_NO_TMP_DIR',
  ),
  'UPLOAD_ERR_CANT_WRITE' =>
  array (
    'init' => '5.1.0',
    'name' => 'UPLOAD_ERR_CANT_WRITE',
  ),
  'UPLOAD_ERR_EXTENSION' =>
  array (
    'init' => '5.2.0',
    'name' => 'UPLOAD_ERR_EXTENSION',
  ),
);
?>