/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.servlet;

import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import org.apache.jasper.util.ExceptionUtils;

public class JspCServletContext
implements ServletContext {
    protected Hashtable<String, Object> myAttributes = new Hashtable();
    protected PrintWriter myLogWriter;
    protected URL myResourceBaseURL;
    private ClassLoader loader;

    public JspCServletContext(PrintWriter aLogWriter, URL aResourceBaseURL) {
        this.myLogWriter = aLogWriter;
        this.myResourceBaseURL = aResourceBaseURL;
    }

    public Object getAttribute(String name) {
        return this.myAttributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return this.myAttributes.keys();
    }

    public ServletContext getContext(String uripath) {
        return null;
    }

    public String getContextPath() {
        return null;
    }

    public String getInitParameter(String name) {
        return null;
    }

    public Enumeration<String> getInitParameterNames() {
        return new Vector().elements();
    }

    public int getMajorVersion() {
        return 3;
    }

    public String getMimeType(String file) {
        return null;
    }

    public int getMinorVersion() {
        return 0;
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        return null;
    }

    public String getRealPath(String path) {
        if (!this.myResourceBaseURL.getProtocol().equals("file")) {
            return null;
        }
        if (!path.startsWith("/")) {
            return null;
        }
        try {
            return this.getResource(path).getFile().replace('/', File.separatorChar);
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            return null;
        }
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getResource(String path) throws MalformedURLException {
        if (!path.startsWith("/")) {
            throw new MalformedURLException("Path '" + path + "' does not start with '/'");
        }
        URL url = new URL(this.myResourceBaseURL, path.substring(1));
        InputStream is = null;
        try {
            is = url.openStream();
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            url = null;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable t2) {
                    ExceptionUtils.handleThrowable(t2);
                }
            }
        }
        return url;
    }

    public InputStream getResourceAsStream(String path) {
        try {
            return this.getResource(path).openStream();
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            return null;
        }
    }

    public Set<String> getResourcePaths(String path) {
        String basePath;
        HashSet<String> thePaths = new HashSet<String>();
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        if ((basePath = this.getRealPath(path)) == null) {
            return thePaths;
        }
        File theBaseDir = new File(basePath);
        if (!theBaseDir.exists() || !theBaseDir.isDirectory()) {
            return thePaths;
        }
        String[] theFiles = theBaseDir.list();
        for (int i = 0; i < theFiles.length; ++i) {
            File testFile = new File(basePath + File.separator + theFiles[i]);
            if (testFile.isFile()) {
                thePaths.add(path + theFiles[i]);
                continue;
            }
            if (!testFile.isDirectory()) continue;
            thePaths.add(path + theFiles[i] + "/");
        }
        return thePaths;
    }

    public String getServerInfo() {
        return "JspCServletContext/1.0";
    }

    @Deprecated
    public Servlet getServlet(String name) throws ServletException {
        return null;
    }

    public String getServletContextName() {
        return this.getServerInfo();
    }

    @Deprecated
    public Enumeration<String> getServletNames() {
        return new Vector().elements();
    }

    @Deprecated
    public Enumeration<Servlet> getServlets() {
        return new Vector().elements();
    }

    public void log(String message) {
        this.myLogWriter.println(message);
    }

    @Deprecated
    public void log(Exception exception, String message) {
        this.log(message, exception);
    }

    public void log(String message, Throwable exception) {
        this.myLogWriter.println(message);
        exception.printStackTrace(this.myLogWriter);
    }

    public void removeAttribute(String name) {
        this.myAttributes.remove(name);
    }

    public void setAttribute(String name, Object value) {
        this.myAttributes.put(name, value);
    }

    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        return null;
    }

    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        return null;
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return EnumSet.noneOf(SessionTrackingMode.class);
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return EnumSet.noneOf(SessionTrackingMode.class);
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return null;
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        return null;
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        return null;
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        return null;
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        return null;
    }

    public <T extends Filter> T createFilter(Class<T> c) throws ServletException {
        return null;
    }

    public <T extends Servlet> T createServlet(Class<T> c) throws ServletException {
        return null;
    }

    public FilterRegistration getFilterRegistration(String filterName) {
        return null;
    }

    public ServletRegistration getServletRegistration(String servletName) {
        return null;
    }

    public boolean setInitParameter(String name, String value) {
        return false;
    }

    public void addListener(Class<? extends EventListener> listenerClass) {
    }

    public void addListener(String className) {
    }

    public <T extends EventListener> void addListener(T t) {
    }

    public <T extends EventListener> T createListener(Class<T> c) throws ServletException {
        return null;
    }

    public void declareRoles(String ... roleNames) {
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public void setClassLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public int getEffectiveMajorVersion() {
        return 3;
    }

    public int getEffectiveMinorVersion() {
        return 0;
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        return null;
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        return null;
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        return null;
    }
}

