/*
 * Decompiled with CFR 0.152.
 */
package JP.co.esm.caddies.uml.util;

import JP.co.esm.caddies.uml.Foundation.Core.UClassifier;
import JP.co.esm.caddies.uml.Foundation.DataTypes.UMultiplicity;
import JP.co.esm.caddies.uml.Foundation.DataTypes.UMultiplicityRange;
import JP.co.esm.caddies.uml.java.JUPrimitive;
import java.util.Iterator;
import java.util.List;

public class TypeExpression {
    private UClassifier classifier;
    private UMultiplicity multiplicity;

    public TypeExpression(UClassifier uClassifier, UMultiplicity uMultiplicity) {
        this.classifier = uClassifier;
        if (uClassifier == JUPrimitive.VOID && uMultiplicity != null) {
            uMultiplicity.removeAllMultiplicityRanges();
        }
        this.multiplicity = uMultiplicity;
    }

    public TypeExpression(UClassifier uClassifier, int n2) {
        if (uClassifier == JUPrimitive.VOID) {
            n2 = 0;
        }
        UMultiplicity uMultiplicity = new UMultiplicity();
        for (int i2 = 0; i2 < n2; ++i2) {
            uMultiplicity.addMultiplicityRange(new UMultiplicityRange(-1, -1));
        }
        this.classifier = uClassifier;
        this.multiplicity = uMultiplicity;
    }

    public String toString() {
        return TypeExpression.getExpression(this.classifier, this.multiplicity);
    }

    public static String getExpression(UClassifier uClassifier, UMultiplicity uMultiplicity) {
        StringBuffer stringBuffer = new StringBuffer(uClassifier.getNameString());
        if (uClassifier == JUPrimitive.VOID && uMultiplicity != null) {
            uMultiplicity.removeAllMultiplicityRanges();
        }
        stringBuffer.append(TypeExpression.getDimention(uMultiplicity));
        return stringBuffer.toString();
    }

    public UClassifier getClassifier() {
        return this.classifier;
    }

    public UMultiplicity getMultiplicity() {
        return this.multiplicity;
    }

    public static int getArrayDimension(String string) {
        int n2 = 0;
        while (string.endsWith("[]") && string.length() > 2) {
            string = string.substring(0, string.length() - 2);
            ++n2;
        }
        return n2;
    }

    public static String getTypeName(String string) {
        String string2 = string;
        while (string2.endsWith("[]") && string2.length() > 2) {
            string2 = string2.substring(0, string2.length() - 2);
        }
        return string2;
    }

    public static String getDimention(UMultiplicity uMultiplicity) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (uMultiplicity == null) {
            return stringBuffer.toString();
        }
        List list = uMultiplicity.getMultiplicityRanges();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            UMultiplicityRange uMultiplicityRange = (UMultiplicityRange)iterator.next();
            if (uMultiplicityRange.getLower() != -1 || uMultiplicityRange.getUpper() != -1) continue;
            stringBuffer.append("[]");
        }
        return stringBuffer.toString();
    }
}

