/*
 * Decompiled with CFR 0.152.
 */
package JP.co.esm.caddies.uml.Foundation.DataTypes;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.StringTokenizer;

public final class UMultiplicityRange
implements Serializable {
    public static final long serialVersionUID = -7034479319225695075L;
    private String uid = null;
    private int lower = -100;
    private int upper = -100;
    public static final int UNDEFINED = -100;
    public static final int UNLIMITED = -1;

    public UMultiplicityRange() {
    }

    public void setUid(String string) {
        this.uid = string;
    }

    public String getUid() {
        return this.uid;
    }

    public UMultiplicityRange(int n2, int n3) {
        this.setRange(n2, n3);
    }

    public void setRange(int n2, int n3) {
        if (n2 == -100 || n3 == -100) {
            this.setUnknown();
            return;
        }
        if (n2 == -1) {
            this.lower = -1;
            this.upper = -1;
            return;
        }
        this.setUpAndLow(n2, n3);
    }

    public void setUpAndLow(int n2, int n3) {
        if (n3 == -1) {
            this.lower = n2;
            this.upper = n3;
        }
        if (n2 <= n3 && n3 >= 0) {
            this.lower = n2;
            this.upper = n3;
        }
    }

    public int getLower() {
        return this.lower;
    }

    public int getUpper() {
        return this.upper;
    }

    public void setUnknown() {
        this.lower = -100;
        this.upper = -100;
    }

    public boolean isUnknown() {
        return this.lower == -100 && this.upper == -100;
    }

    public static boolean checkMultiplicityRange(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        boolean bl2 = true;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int[] nArray = UMultiplicityRange.toMultiplicityRange(string2);
            if (UMultiplicityRange.checkMultiplicityRange(nArray)) continue;
            bl2 = false;
            break;
        }
        return bl2;
    }

    public static boolean checkMultiplicityRange(int[] nArray) {
        if (nArray == null) {
            return false;
        }
        if (nArray.length == 1) {
            if (nArray[0] < 0) {
                return nArray[0] == -100 || nArray[0] == -1;
            }
            return true;
        }
        if (nArray.length == 2) {
            if (nArray[0] < 0) {
                return false;
            }
            if (nArray[1] == -1) {
                return true;
            }
            if (nArray[1] < 0) {
                return false;
            }
            return nArray[0] <= nArray[1];
        }
        return false;
    }

    public static int[][] toMultiplicityRanges(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            arrayList.add(string2);
        }
        int n2 = arrayList.size();
        int[][] nArray = new int[n2][2];
        for (int i2 = 0; i2 < n2; ++i2) {
            String string3 = (String)arrayList.get(i2);
            int[] nArray2 = UMultiplicityRange.toMultiplicityRange(string3);
            nArray[i2][0] = nArray2[0];
            if (nArray2.length == 1) {
                nArray[i2][1] = nArray2[0];
                continue;
            }
            if (nArray2.length != 2) continue;
            nArray[i2][1] = nArray2[1];
        }
        return nArray;
    }

    public static int[] toMultiplicityRange(String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        if (n2 == 0) {
            int[] nArray = new int[]{-100};
            return nArray;
        }
        int n3 = string.indexOf(46);
        if (n3 == -1) {
            int[] nArray = new int[1];
            if (string.equals("*")) {
                nArray[0] = -1;
                return nArray;
            }
            try {
                nArray[0] = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            return nArray;
        }
        int n4 = string.lastIndexOf(46);
        if (n4 != n3 + 1) {
            return null;
        }
        String string2 = string.substring(0, n3);
        String string3 = string.substring(n4 + 1, n2);
        int[] nArray = new int[2];
        try {
            nArray[0] = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        try {
            nArray[1] = string3.equals("*") ? -1 : Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return nArray;
    }

    public static String toRangeString(UMultiplicityRange[] uMultiplicityRangeArray) {
        String string = "";
        for (int i2 = 0; i2 < uMultiplicityRangeArray.length; ++i2) {
            string = string + UMultiplicityRange.toRangeString(uMultiplicityRangeArray[i2]);
            if (i2 >= uMultiplicityRangeArray.length - 1) continue;
            string = string + " , ";
        }
        return string;
    }

    public static String toRangeString(UMultiplicityRange uMultiplicityRange) {
        int n2;
        if (uMultiplicityRange == null || uMultiplicityRange.isUnknown()) {
            return "";
        }
        int n3 = uMultiplicityRange.getLower();
        if (n3 == (n2 = uMultiplicityRange.getUpper())) {
            return UMultiplicityRange.toRangeEndString(n3);
        }
        String string = UMultiplicityRange.toRangeEndString(n3);
        String string2 = UMultiplicityRange.toRangeEndString(n2);
        return string + ".." + string2;
    }

    public static String toRangeEndString(int n2) {
        if (n2 == -1) {
            return "*";
        }
        return Integer.toString(n2);
    }

    public void setLowerString(String string) {
        if (string == null) {
            this.lower = -100;
        } else if (string.equals("*")) {
            this.lower = -1;
        } else if (string.equals("")) {
            this.lower = -100;
        } else {
            Integer n2 = Integer.valueOf(string);
            this.lower = n2;
        }
    }

    public void setUpperString(String string) {
        if (string == null) {
            this.upper = -100;
        } else if (string.equals("*")) {
            this.upper = -1;
        } else if (string.equals("")) {
            this.upper = -100;
        } else {
            Integer n2 = Integer.valueOf(string);
            this.upper = n2;
        }
    }

    public boolean equals(Object object) {
        if (dF.a(this).equals(dF.a(object))) {
            UMultiplicityRange uMultiplicityRange = (UMultiplicityRange)object;
            return this.lower == uMultiplicityRange.getLower() && this.upper == uMultiplicityRange.getUpper();
        }
        return false;
    }
}

