/*
 * Decompiled with CFR 0.152.
 */
package JP.co.esm.caddies.jomt.jmodel;

import JP.co.esm.caddies.jomt.jmodel.ITextPresentation;
import JP.co.esm.caddies.jomt.jmodel.LabelPresentation;
import JP.co.esm.caddies.uml.Foundation.Core.UDiagram;
import JP.co.esm.caddies.uml.Foundation.Core.UModelElement;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Observable;

public class TextPresentation
extends LabelPresentation
implements ITextPresentation {
    public static final long serialVersionUID = -8871990796453639829L;
    public static final double TOP_MARGIN = 4.0;
    public static final double BOTTOM_MARGIN = 4.0;
    public static final double LINE_SPACE = 8.0;

    public boolean isValidModel(UModelElement uModelElement) {
        return true;
    }

    public void setText(String string) {
        this.setLabel(string);
    }

    public String getText() {
        return this.getLabel();
    }

    public void setLabel(String string) {
        super.setLabel(string);
        this.resize();
    }

    public double getMinWidth() {
        double d2 = eG.b(this.getFont(), "m");
        if (d2 * 3.0 > 30.0) {
            return d2 * 3.0;
        }
        return 30.0;
    }

    public double getMinHeight() {
        double d2 = eG.a(this.getFont(), "m");
        if (d2 > 15.0) {
            return d2;
        }
        return 15.0;
    }

    public double getDefaultWidth() {
        String[] stringArray = TextPresentation.analyzeString(this.getText());
        double d2 = 0.0;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            double d3 = eG.b(this.getFont(), stringArray[i2]);
            d2 = Math.max(d2, d3);
        }
        return Math.max(10.0 + d2 + 10.0, this.getMinWidth());
    }

    public double getDefaultHeight() {
        double d2 = eG.a(this.getFont(), "m");
        String[] stringArray = TextPresentation.analyzeString(this.getText());
        double d3 = 4.0 + (d2 + 8.0) * (double)stringArray.length - 8.0 + 4.0;
        return Math.max(d3, this.getMinHeight());
    }

    public static String[] analyzeString(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = "\n";
        int n2 = 0;
        int n3 = 0;
        while (true) {
            if ((n3 = string.indexOf(string2, n2)) == -1) break;
            arrayList.add(string.substring(n2, n3));
            n2 = n3 + 1;
        }
        arrayList.add(string.substring(n2));
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void update(Observable observable, Object object) {
        if (this.isValid()) {
            super.update(observable, null);
            this.resize();
            this.notifyObservers(object);
        }
    }

    public void storeState(Hashtable hashtable) {
        super.storeState(hashtable);
    }

    public void restoreState(Hashtable hashtable) {
        this.setChanged();
        super.restoreState(hashtable);
    }

    public Object clone() {
        return super.clone();
    }

    public boolean isSearchable() {
        return true;
    }

    public String getParentName() {
        UDiagram uDiagram = this.getDiagram();
        if (uDiagram != null) {
            String string = uDiagram.getNameString();
            String string2 = uDiagram.getParentName();
            if (string2 != null && !string2.equals("")) {
                string = string2 + "::" + string;
            }
            return string;
        }
        return null;
    }

    public String getSearchableTypeString() {
        return "Text";
    }

    public Font getFont() {
        String string = "TextPresentation";
        Font font = this.getUsedFont(string);
        return font;
    }
}

