/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util.gui;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.lobobrowser.util.Objects;

public class FontFactory {
    private static final Logger logger = null;
    private static final boolean loggableInfo = false;
    private static final FontFactory instance = new FontFactory();
    private final Set fontFamilies = new HashSet();
    private final Map fontMap = new HashMap();
    private final Map registeredFonts = new HashMap(0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FontFactory() {
        boolean liflag = loggableInfo;
        String[] ffns = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        Set fontFamilies = this.fontFamilies;
        FontFactory fontFactory = this;
        synchronized (fontFactory) {
            for (int i2 = 0; i2 < ffns.length; ++i2) {
                if (liflag) {
                    // empty if block
                }
                fontFamilies.add(ffns[i2].toLowerCase());
            }
        }
    }

    public static final FontFactory getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFont(String fontName, int fontFormat, InputStream fontStream) throws FontFormatException, IOException {
        Font f2 = Font.createFont(fontFormat, fontStream);
        FontFactory fontFactory = this;
        synchronized (fontFactory) {
            this.registeredFonts.put(fontName.toLowerCase(), f2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFont(String fontName) {
        FontFactory fontFactory = this;
        synchronized (fontFactory) {
            this.registeredFonts.remove(fontName.toLowerCase());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Font getFont(String fontFamily, String fontStyle, String fontVariant, String fontWeight, float fontSize) {
        FontKey key = new FontKey(fontFamily, fontStyle, fontVariant, fontWeight, fontSize);
        FontFactory fontFactory = this;
        synchronized (fontFactory) {
            Font font = (Font)this.fontMap.get(key);
            if (font == null) {
                font = this.createFont(key);
                this.fontMap.put(key, font);
            }
            return font;
        }
    }

    private final Font createFont(FontKey key) {
        String fontNames = key.fontFamily;
        String fontFam = null;
        Set fontFamilies = this.fontFamilies;
        Map registeredFonts = this.registeredFonts;
        Font baseFont = null;
        if (fontNames != null) {
            StringTokenizer tok = new StringTokenizer(fontNames, ",");
            while (tok.hasMoreTokens()) {
                fontFam = tok.nextToken().trim();
                String fontFamTL = fontFam.toLowerCase();
                if (registeredFonts.containsKey(fontFamTL)) {
                    baseFont = (Font)registeredFonts.get(fontFamTL);
                    break;
                }
                if (!fontFamilies.contains(fontFamTL)) continue;
                break;
            }
        }
        int fontStyle = 0;
        if ("italic".equalsIgnoreCase(key.fontStyle)) {
            fontStyle |= 2;
        }
        if ("bold".equalsIgnoreCase(key.fontWeight) || "bolder".equalsIgnoreCase(key.fontWeight)) {
            fontStyle |= 1;
        }
        if (baseFont != null) {
            return baseFont.deriveFont(fontStyle, key.fontSize);
        }
        return new Font(fontFam, fontStyle, Math.round(key.fontSize));
    }

    private static class FontKey {
        public final String fontFamily;
        public final String fontStyle;
        public final String fontVariant;
        public final String fontWeight;
        public final float fontSize;

        public FontKey(String fontFamily, String fontStyle, String fontVariant, String fontWeight, float fontSize) {
            this.fontFamily = fontFamily;
            this.fontStyle = fontStyle;
            this.fontVariant = fontVariant;
            this.fontWeight = fontWeight;
            this.fontSize = fontSize;
        }

        public boolean equals(Object other) {
            if (!(other instanceof FontKey)) {
                return false;
            }
            FontKey ors = (FontKey)other;
            return this.fontSize == ors.fontSize && Objects.equals(this.fontFamily, ors.fontFamily) && Objects.equals(this.fontStyle, ors.fontStyle) && Objects.equals(this.fontWeight, ors.fontWeight) && Objects.equals(this.fontVariant, ors.fontVariant);
        }

        public int hashCode() {
            String fs;
            String fw;
            String ff = this.fontFamily;
            if (ff == null) {
                ff = "";
            }
            if ((fw = this.fontWeight) == null) {
                fw = "";
            }
            if ((fs = this.fontStyle) == null) {
                fs = "";
            }
            return ff.hashCode() ^ fw.hashCode() ^ fs.hashCode() ^ (int)this.fontSize;
        }

        public String toString() {
            return "FontKey[family=" + this.fontFamily + ",size=" + this.fontSize + ",style=" + this.fontStyle + ",weight=" + this.fontWeight + ",variant=" + this.fontVariant + "]";
        }
    }
}

