/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util;

import java.util.Collection;
import org.lobobrowser.util.BaseClassLoader;

public abstract class MultiplexClassLoader
extends BaseClassLoader {
    private static final BaseClassLoader[] EMPTY_CLASS_LOADERS = new BaseClassLoader[0];
    private final BaseClassLoader[] parentLoaders;

    public MultiplexClassLoader(Collection classLoaders) {
        super(null);
        this.parentLoaders = classLoaders.toArray(EMPTY_CLASS_LOADERS);
    }

    public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class c2 = this.findLoadedClass(name);
        if (c2 == null) {
            block9: {
                try {
                    int len = this.parentLoaders.length;
                    if (len == 0) {
                        c2 = this.findSystemClass(name);
                        break block9;
                    }
                    for (int i2 = 0; i2 < len; ++i2) {
                        BaseClassLoader parent = this.parentLoaders[i2];
                        try {
                            c2 = parent.loadClass(name, false);
                            if (c2 == null) continue;
                            return c2;
                        }
                        catch (ClassNotFoundException cnfe) {
                            // empty catch block
                        }
                    }
                }
                catch (ClassNotFoundException e2) {
                    c2 = this.findClass(name);
                }
            }
            if (c2 == null) {
                c2 = this.findClass(name);
            }
        }
        if (resolve) {
            this.resolveClass(c2);
        }
        return c2;
    }
}

