/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.lobobrowser.html.HttpRequest;
import org.lobobrowser.html.ReadyStateChangeListener;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.renderer.BaseRCollection;
import org.lobobrowser.html.renderer.DelayedPair;
import org.lobobrowser.html.renderer.RCollection;
import org.lobobrowser.html.renderer.RElement;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.style.BackgroundInfo;
import org.lobobrowser.html.style.CSS2PropertiesImpl;
import org.lobobrowser.html.style.HtmlValues;
import org.lobobrowser.html.style.RenderState;
import org.lobobrowser.util.gui.ColorFactory;

abstract class BaseElementRenderable
extends BaseRCollection
implements RElement,
RenderableContainer,
ImageObserver {
    public static final int OVERFLOW_NONE = 0;
    public static final int OVERFLOW_SCROLL = 1;
    public static final int OVERFLOW_AUTO = 2;
    public static final int OVERFLOW_HIDDEN = 3;
    public static final int OVERFLOW_VISIBLE = 4;
    public static final int OVERFLOW_VERTICAL = 5;
    private Collection guiComponents = null;
    protected Collection delayedPairs = null;
    protected Color backgroundColor;
    protected volatile Image backgroundImage;
    protected int zIndex;
    protected Color borderTopColor;
    protected Color borderLeftColor;
    protected Color borderBottomColor;
    protected Color borderRightColor;
    protected Insets borderInsets;
    protected String lastBackgroundImageUri;
    protected Insets defaultMarginInsets;
    private int cachedOverflow = -1;
    protected final UserAgentContext userAgentContext;
    protected boolean layoutDeepCanBeInvalidated = false;
    protected static final int SCROLL_BAR_THICKNESS = 16;

    public BaseElementRenderable(RenderableContainer container, ModelNode modelNode, UserAgentContext ucontext) {
        super(container, modelNode);
        this.userAgentContext = ucontext;
    }

    public float getAlignmentX() {
        return 0.0f;
    }

    public float getAlignmentY() {
        return 0.0f;
    }

    public final void invalidateLayoutDeep() {
        if (this.layoutDeepCanBeInvalidated) {
            this.layoutDeepCanBeInvalidated = false;
            this.invalidateLayoutLocal();
            Iterator i2 = this.getRenderables();
            if (i2 != null) {
                while (i2.hasNext()) {
                    Object r2 = i2.next();
                    if (!(r2 instanceof RCollection)) continue;
                    ((RCollection)r2).invalidateLayoutDeep();
                }
            }
        }
    }

    protected void invalidateLayoutLocal() {
        this.cachedOverflow = -1;
    }

    protected int getDeclaredWidth(RenderState renderState, int availWidth) {
        ModelNode rootNode = this.modelNode;
        if (rootNode instanceof HTMLElementImpl) {
            HTMLElementImpl element = (HTMLElementImpl)rootNode;
            CSS2PropertiesImpl props = element.getCurrentStyle();
            if (props == null) {
                return -1;
            }
            String widthText = props.getWidth();
            if (widthText == null || "".equals(widthText)) {
                return -1;
            }
            return HtmlValues.getPixelSize(widthText, renderState, -1, availWidth);
        }
        return -1;
    }

    protected int getDeclaredHeight(RenderState renderState, int availHeight) {
        ModelNode rootNode = this.modelNode;
        if (rootNode instanceof HTMLElementImpl) {
            HTMLElementImpl element = (HTMLElementImpl)rootNode;
            CSS2PropertiesImpl props = element.getCurrentStyle();
            if (props == null) {
                return -1;
            }
            String heightText = props.getHeight();
            if (heightText == null || "".equals(heightText)) {
                return -1;
            }
            return HtmlValues.getPixelSize(heightText, renderState, -1, availHeight);
        }
        return -1;
    }

    protected int getOverflow() {
        String overflowTextTL;
        String overflowText;
        HTMLElementImpl element;
        CSS2PropertiesImpl props;
        int co = this.cachedOverflow;
        if (co != -1) {
            return co;
        }
        ModelNode rootNode = this.modelNode;
        co = rootNode instanceof HTMLElementImpl ? ((props = (element = (HTMLElementImpl)rootNode).getCurrentStyle()) == null ? 0 : ((overflowText = props.getOverflow()) == null ? 0 : ("scroll".equals(overflowTextTL = overflowText.toLowerCase()) ? 1 : ("auto".equals(overflowTextTL) ? 2 : ("vertical".equals(overflowTextTL) ? 5 : ("hidden".equals(overflowTextTL) ? 3 : ("visible".equals(overflowTextTL) ? 4 : 0))))))) : 0;
        this.cachedOverflow = co;
        return co;
    }

    public void paint(Graphics g2) {
    }

    public final void layout(int availWidth, int availHeight) {
        this.layout(availWidth, availHeight, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void layout(int availWidth, int availHeight, boolean expandWidth, boolean expandHeight) {
        try {
            this.doLayout(availWidth, availHeight, expandWidth, expandHeight);
        }
        finally {
            this.layoutUpTreeCanBeInvalidated = true;
            this.layoutDeepCanBeInvalidated = true;
        }
    }

    protected abstract void doLayout(int var1, int var2, boolean var3, boolean var4);

    protected final void sendGUIComponentsToParent() {
        Collection gc2 = this.guiComponents;
        int count = 0;
        if (gc2 != null) {
            RenderableContainer rc2 = this.container;
            Iterator i2 = gc2.iterator();
            while (i2.hasNext()) {
                ++count;
                rc2.add((Component)i2.next());
            }
        }
    }

    protected final void clearGUIComponents() {
        Collection gc2 = this.guiComponents;
        if (gc2 != null) {
            gc2.clear();
        }
    }

    public Component add(Component component) {
        HashSet<Component> gc2 = this.guiComponents;
        if (gc2 == null) {
            this.guiComponents = gc2 = new HashSet<Component>(1);
        }
        gc2.add(component);
        return component;
    }

    public void updateAllWidgetBounds() {
        this.container.updateAllWidgetBounds();
    }

    public void updateWidgetBounds() {
        Point guiPoint = this.getGUIPoint(0, 0);
        this.updateWidgetBounds(guiPoint.x, guiPoint.y);
    }

    protected void applyStyle() {
        String backgroundImageUri;
        HTMLElementImpl rootElement;
        ModelNode rootNode = this.modelNode;
        if (rootNode instanceof HTMLDocumentImpl) {
            HTMLDocumentImpl doc = (HTMLDocumentImpl)rootNode;
            rootElement = (HTMLElementImpl)doc.getBody();
        } else {
            rootElement = (HTMLElementImpl)rootNode;
        }
        if (rootElement == null) {
            this.clearStyle();
            this.backgroundColor = null;
            this.backgroundImage = null;
            this.lastBackgroundImageUri = null;
            return;
        }
        RenderState rs = rootElement.getRenderState();
        if (rs == null) {
            throw new IllegalStateException("Element without render state: " + rootElement + "; parent=" + rootElement.getParentNode());
        }
        BackgroundInfo binfo = rs.getBackgroundInfo();
        this.backgroundColor = binfo == null ? null : binfo.backgroundColor;
        String string = backgroundImageUri = binfo == null ? null : binfo.backgroundImage;
        if (backgroundImageUri == null) {
            this.backgroundImage = null;
            this.lastBackgroundImageUri = null;
        } else if (!backgroundImageUri.equals(this.lastBackgroundImageUri)) {
            this.lastBackgroundImageUri = backgroundImageUri;
            this.loadBackgroundImage(backgroundImageUri);
        }
        CSS2PropertiesImpl props = rootElement.getCurrentStyle();
        if (props == null) {
            this.clearStyle();
        } else {
            String zIndex;
            String borderRightColorText;
            String borderBottomColorText;
            String borderLeftColorText;
            String borderTopColorText;
            this.borderInsets = null;
            this.borderTopColor = null;
            this.borderLeftColor = null;
            this.borderBottomColor = null;
            this.borderRightColor = null;
            String border = props.getBorder();
            if (border != null) {
                this.applyBorder(rs, border);
            }
            this.borderInsets = HtmlValues.getBorderInsets(this.borderInsets, props, rs);
            String borderColorText = props.getBorderColor();
            if (borderColorText != null) {
                Color[] colorsArray = HtmlValues.getColors(borderColorText);
                this.borderTopColor = colorsArray[0];
                this.borderLeftColor = colorsArray[1];
                this.borderBottomColor = colorsArray[2];
                this.borderRightColor = colorsArray[3];
            }
            if ((borderTopColorText = props.getBorderTopColor()) != null) {
                this.borderTopColor = ColorFactory.getInstance().getColor(borderTopColorText);
            }
            if ((borderLeftColorText = props.getBorderLeftColor()) != null) {
                this.borderLeftColor = ColorFactory.getInstance().getColor(borderLeftColorText);
            }
            if ((borderBottomColorText = props.getBorderBottomColor()) != null) {
                this.borderBottomColor = ColorFactory.getInstance().getColor(borderBottomColorText);
            }
            if ((borderRightColorText = props.getBorderRightColor()) != null) {
                this.borderRightColor = ColorFactory.getInstance().getColor(borderRightColorText);
            }
            if ((zIndex = props.getZIndex()) != null) {
                try {
                    this.zIndex = Integer.parseInt(zIndex);
                }
                catch (NumberFormatException err) {
                    this.zIndex = 0;
                }
            } else {
                this.zIndex = 0;
            }
        }
    }

    protected void loadBackgroundImage(String uri) {
        ModelNode rc2 = this.modelNode;
        UserAgentContext ctx = this.userAgentContext;
        if (ctx != null) {
            final HttpRequest request = ctx.createHttpRequest();
            request.addReadyStateChangeListener(new ReadyStateChangeListener(){

                public void readyStateChanged() {
                    int status;
                    int readyState = request.getReadyState();
                    if (readyState == 4 && ((status = request.getStatus()) == 200 || status == 0)) {
                        Image img;
                        BaseElementRenderable.this.backgroundImage = img = request.getResponseImage();
                        int w2 = img.getWidth(BaseElementRenderable.this);
                        int h2 = img.getHeight(BaseElementRenderable.this);
                        if (w2 != -1 && h2 != -1) {
                            BaseElementRenderable.this.repaint();
                        }
                    }
                }
            });
            try {
                final URL fullUrl = rc2.getFullURL(uri);
                SecurityManager sm = System.getSecurityManager();
                if (sm == null) {
                    request.open("GET", fullUrl);
                } else {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            request.open("GET", fullUrl);
                            return null;
                        }
                    });
                }
            }
            catch (MalformedURLException mfu) {
                rc2.warn("Bad image URI: [" + uri + "]", mfu);
            }
        }
    }

    public int getZIndex() {
        return this.zIndex;
    }

    void applyBorder(RenderState renderState, String border) {
        String[] tokens = HtmlValues.splitCssValue(border);
        for (int i2 = 0; i2 < tokens.length; ++i2) {
            Insets bi;
            String token = tokens[i2];
            if (HtmlValues.isLength(token)) {
                Insets bi2;
                int pixelSize = HtmlValues.getPixelSize(token, renderState, 0);
                this.borderInsets = bi2 = new Insets(pixelSize, pixelSize, pixelSize, pixelSize);
                continue;
            }
            if (ColorFactory.getInstance().isColor(token)) {
                Color color;
                this.borderLeftColor = color = ColorFactory.getInstance().getColor(token);
                this.borderRightColor = color;
                this.borderTopColor = color;
                this.borderBottomColor = color;
                continue;
            }
            if (!HtmlValues.isBorderStyle(token) || !"solid".equalsIgnoreCase(token) && !"dashed".equalsIgnoreCase(token) || (bi = this.borderInsets) != null) continue;
            this.borderInsets = bi = new Insets(4, 4, 4, 4);
        }
    }

    private Color getBorderTopColor() {
        Color c2 = this.borderTopColor;
        return c2 == null ? Color.black : c2;
    }

    private Color getBorderLeftColor() {
        Color c2 = this.borderLeftColor;
        return c2 == null ? Color.black : c2;
    }

    private Color getBorderBottomColor() {
        Color c2 = this.borderBottomColor;
        return c2 == null ? Color.black : c2;
    }

    private Color getBorderRightColor() {
        Color c2 = this.borderRightColor;
        return c2 == null ? Color.black : c2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void prePaint(Graphics g2) {
        Insets borderInsets;
        int startWidth = this.width;
        int startHeight = this.height;
        int totalWidth = startWidth;
        int totalHeight = startHeight;
        int startX = 0;
        int startY = 0;
        ModelNode node = this.modelNode;
        RenderState rs = node.getRenderState();
        Insets marginInsets = this.getMarginInsets(rs);
        if (marginInsets != null) {
            totalWidth -= marginInsets.left + marginInsets.right;
            totalHeight -= marginInsets.top + marginInsets.bottom;
            startX += marginInsets.left;
            startY += marginInsets.top;
        }
        if ((borderInsets = this.borderInsets) != null) {
            int bleft = borderInsets.left;
            int newStartX = startX + bleft;
            int btop = borderInsets.top;
            int newStartY = startY + btop;
            int bright = borderInsets.right;
            int newTotalWidth = totalWidth - (bleft + bright);
            int bbottom = borderInsets.bottom;
            int newTotalHeight = totalHeight - (btop + bbottom);
            Rectangle clientRegion = new Rectangle(newStartX, newStartY, newTotalWidth, newTotalHeight);
            Rectangle clipBounds = g2.getClipBounds();
            if (!clientRegion.contains(clipBounds)) {
                int i2;
                int i3;
                if (btop > 0) {
                    g2.setColor(this.getBorderTopColor());
                    for (i3 = 0; i3 < btop; ++i3) {
                        int leftOffset = i3 * bleft / btop;
                        int rightOffset = i3 * bright / btop;
                        g2.drawLine(startX + leftOffset, startY + i3, startX + totalWidth - rightOffset - 1, startY + i3);
                    }
                }
                if (bright > 0) {
                    g2.setColor(this.getBorderRightColor());
                    int lastX = startX + totalWidth - 1;
                    for (i2 = 0; i2 < bright; ++i2) {
                        int topOffset = i2 * btop / bright;
                        int bottomOffset = i2 * bbottom / bright;
                        g2.drawLine(lastX - i2, startY + topOffset, lastX - i2, startY + totalHeight - bottomOffset - 1);
                    }
                }
                if (bleft > 0) {
                    g2.setColor(this.getBorderLeftColor());
                    for (i3 = 0; i3 < bleft; ++i3) {
                        int topOffset = i3 * btop / bleft;
                        int bottomOffset = i3 * bbottom / bleft;
                        g2.drawLine(startX + i3, startY + topOffset, startX + i3, startY + totalHeight - bottomOffset - 1);
                    }
                }
                if (bbottom > 0) {
                    g2.setColor(this.getBorderBottomColor());
                    int lastY = startY + totalHeight - 1;
                    for (i2 = 0; i2 < bbottom; ++i2) {
                        int leftOffset = i2 * bleft / bbottom;
                        int rightOffset = i2 * bright / bbottom;
                        g2.drawLine(startX + leftOffset, lastY - i2, startX + totalWidth - rightOffset - 1, lastY - i2);
                    }
                }
            }
            totalWidth = newTotalWidth;
            totalHeight = newTotalHeight;
            startX = newStartX;
            startY = newStartY;
        }
        Graphics clientG = g2.create(startX, startY, totalWidth, totalHeight);
        try {
            Rectangle bkgBounds = null;
            if (node == null) return;
            Color bkg = this.backgroundColor;
            if (bkg != null && bkg.getAlpha() > 0) {
                clientG.setColor(bkg);
                bkgBounds = clientG.getClipBounds();
                clientG.fillRect(bkgBounds.x, bkgBounds.y, bkgBounds.width, bkgBounds.height);
            }
            BackgroundInfo binfo = rs == null ? null : rs.getBackgroundInfo();
            Image image = this.backgroundImage;
            if (image == null) return;
            if (bkgBounds == null) {
                bkgBounds = clientG.getClipBounds();
            }
            int w2 = image.getWidth(this);
            int h2 = image.getHeight(this);
            if (w2 == -1 || h2 == -1) return;
            switch (binfo == null ? 0 : binfo.backgroundRepeat) {
                case 1: {
                    int imageX = binfo.backgroundXPositionAbsolute ? binfo.backgroundXPosition : binfo.backgroundXPosition * (totalWidth - w2) / 100;
                    int imageY = binfo.backgroundYPositionAbsolute ? binfo.backgroundYPosition : binfo.backgroundYPosition * (totalHeight - h2) / 100;
                    clientG.drawImage(image, imageX, imageY, w2, h2, this);
                    return;
                }
                case 2: {
                    int imageY = binfo.backgroundYPositionAbsolute ? binfo.backgroundYPosition : binfo.backgroundYPosition * (totalHeight - h2) / 100;
                    int topX = bkgBounds.x + bkgBounds.width;
                    for (int x2 = bkgBounds.x / w2 * w2; x2 < topX; x2 += w2) {
                        clientG.drawImage(image, x2, imageY, w2, h2, this);
                    }
                    return;
                }
                case 3: {
                    int imageX = binfo.backgroundXPositionAbsolute ? binfo.backgroundXPosition : binfo.backgroundXPosition * (totalWidth - w2) / 100;
                    int topY = bkgBounds.y + bkgBounds.height;
                    for (int y2 = bkgBounds.y / h2 * h2; y2 < topY; y2 += h2) {
                        clientG.drawImage(image, imageX, y2, w2, h2, this);
                    }
                    return;
                }
                default: {
                    int baseX = bkgBounds.x / w2 * w2;
                    int baseY = bkgBounds.y / h2 * h2;
                    int topX = bkgBounds.x + bkgBounds.width;
                    int topY = bkgBounds.y + bkgBounds.height;
                    for (int x3 = baseX; x3 < topX; x3 += w2) {
                        for (int y3 = baseY; y3 < topY; y3 += h2) {
                            clientG.drawImage(image, x3, y3, w2, h2, this);
                        }
                    }
                    return;
                }
            }
        }
        finally {
            clientG.dispose();
        }
    }

    void clearStyle() {
        this.borderInsets = null;
        this.borderTopColor = null;
        this.borderLeftColor = null;
        this.borderBottomColor = null;
        this.borderRightColor = null;
        this.zIndex = 0;
    }

    protected final Insets getMarginInsets(RenderState rs) {
        Insets mi = rs.getMarginInsets();
        if (mi == null) {
            return this.defaultMarginInsets;
        }
        return mi;
    }

    public boolean imageUpdate(Image img, int infoflags, int x2, int y2, int w2, int h2) {
        if ((infoflags & 0x20) != 0 || (infoflags & 0x10) != 0) {
            this.repaint();
        }
        return true;
    }

    public Insets getInsets(boolean hscroll, boolean vscroll) {
        RenderState rs = this.modelNode.getRenderState();
        Insets mi = this.getMarginInsets(rs);
        Insets bi = this.borderInsets;
        int top = 0;
        int bottom = 0;
        int left = 0;
        int right = 0;
        if (mi != null) {
            top += mi.top;
            left += mi.left;
            bottom += mi.bottom;
            right += mi.right;
        }
        if (bi != null) {
            top += bi.top;
            left += bi.left;
            bottom += bi.bottom;
            right += bi.right;
        }
        if (hscroll) {
            bottom += 16;
        }
        if (vscroll) {
            right += 16;
        }
        return new Insets(top, left, bottom, right);
    }

    protected final void sendDelayedPairsToParent() {
        Collection gc2 = this.delayedPairs;
        if (gc2 != null) {
            RenderableContainer rc2 = this.container;
            Iterator i2 = gc2.iterator();
            while (i2.hasNext()) {
                DelayedPair pair = (DelayedPair)i2.next();
                if (pair.targetParent == this) continue;
                rc2.addDelayedPair(pair);
            }
        }
    }

    public final void clearDelayedPairs() {
        Collection gc2 = this.delayedPairs;
        if (gc2 != null) {
            gc2.clear();
        }
    }

    public final Collection getDelayedPairs() {
        return this.delayedPairs;
    }

    public void addDelayedPair(DelayedPair pair) {
        LinkedList<DelayedPair> gc2 = this.delayedPairs;
        if (gc2 == null) {
            this.delayedPairs = gc2 = new LinkedList<DelayedPair>();
        }
        gc2.add(pair);
    }

    public RenderableContainer getParentContainer() {
        return this.container;
    }
}

