/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import java.awt.Color;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.domimpl.HTMLAbstractUIElement;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.style.CSSUtilities;
import org.lobobrowser.html.style.ColorRenderState;
import org.lobobrowser.html.style.RenderState;
import org.lobobrowser.html.style.TextDecorationRenderState;
import org.lobobrowser.util.gui.ColorFactory;
import org.w3c.dom.UserDataHandler;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.html2.HTMLBodyElement;
import org.w3c.dom.html2.HTMLDocument;
import org.w3c.dom.html2.HTMLLinkElement;

public class HTMLLinkElementImpl
extends HTMLAbstractUIElement
implements HTMLLinkElement {
    private static final Logger logger = null;
    private static final boolean loggableInfo = false;
    private boolean disabled;

    public HTMLLinkElementImpl(String name) {
        super(name);
    }

    public boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public String getHref() {
        return this.getAttribute("href");
    }

    public void setHref(String href) {
        this.setAttribute("href", href);
    }

    public String getHreflang() {
        return this.getAttribute("hreflang");
    }

    public void setHreflang(String hreflang) {
        this.setAttribute("hreflang", hreflang);
    }

    public String getMedia() {
        return this.getAttribute("media");
    }

    public void setMedia(String media) {
        this.setAttribute("media", media);
    }

    public String getRel() {
        return this.getAttribute("rel");
    }

    public void setRel(String rel) {
        this.setAttribute("rel", rel);
    }

    public String getRev() {
        return this.getAttribute("rev");
    }

    public void setRev(String rev) {
        this.setAttribute("rev", rev);
    }

    public String getTarget() {
        String target = this.getAttribute("target");
        if (target != null) {
            return target;
        }
        HTMLDocumentImpl doc = (HTMLDocumentImpl)this.document;
        return doc == null ? null : doc.getDefaultTarget();
    }

    public void setTarget(String target) {
        this.setAttribute("target", target);
    }

    public String getType() {
        return this.getAttribute("type");
    }

    public void setType(String type) {
        this.setAttribute("type", type);
    }

    public Object setUserData(String key, Object data, UserDataHandler handler) {
        if ("cobra.suspend".equals(key) && data != Boolean.TRUE) {
            this.processLink();
        }
        return super.setUserData(key, data, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processLink() {
        String media;
        String rel = this.getAttribute("rel");
        if (rel != null && rel.toLowerCase().indexOf("stylesheet") != -1 && CSSUtilities.matchesMedia(media = this.getMedia(), this.getHtmlRendererContext())) {
            HTMLDocumentImpl doc = (HTMLDocumentImpl)this.getOwnerDocument();
            try {
                boolean liflag = loggableInfo;
                long time1 = liflag ? System.currentTimeMillis() : 0L;
                try {
                    CSSStyleSheet sheet = CSSUtilities.parse(this.getHref(), doc, doc.getBaseURI(), false);
                    if (sheet != null) {
                        doc.addStyleSheet(sheet);
                    }
                }
                finally {
                    if (liflag) {
                        long time2 = System.currentTimeMillis();
                    }
                }
            }
            catch (MalformedURLException mfe) {
                this.warn("Will not parse CSS. URI=[" + this.getHref() + "] with BaseURI=[" + doc.getBaseURI() + "] does not appear to be a valid URI.");
            }
            catch (Throwable err) {
                this.warn("Unable to parse CSS. URI=[" + this.getHref() + "].", err);
            }
        }
    }

    public void navigate() {
        String href;
        if (this.disabled) {
            return;
        }
        HtmlRendererContext rcontext = this.getHtmlRendererContext();
        if (rcontext != null && (href = this.getHref()) != null && !"".equals(href)) {
            String target = this.getTarget();
            try {
                URL url = this.getFullURL(href);
                if (url == null) {
                    this.warn("Unable to resolve URI: [" + href + "].");
                } else {
                    rcontext.navigate(url, target);
                }
            }
            catch (MalformedURLException mfu) {
                this.warn("Malformed URI: [" + href + "].", mfu);
            }
        }
    }

    private Color getLinkColor() {
        HTMLBodyElement body;
        HTMLDocument doc = (HTMLDocument)this.document;
        if (doc != null && (body = (HTMLBodyElement)doc.getBody()) != null) {
            HtmlRendererContext rcontext;
            String vlink = body.getVLink();
            String link = body.getLink();
            if ((vlink != null || link != null) && (rcontext = this.getHtmlRendererContext()) != null) {
                String colorText;
                boolean visited = rcontext.isVisitedLink(this);
                String string = colorText = visited ? vlink : link;
                if (colorText != null) {
                    return ColorFactory.getInstance().getColor(colorText);
                }
            }
        }
        return Color.BLUE;
    }

    protected RenderState createRenderState(RenderState prevRenderState) {
        prevRenderState = new TextDecorationRenderState(prevRenderState, 1);
        prevRenderState = new ColorRenderState(prevRenderState, this.getLinkColor());
        return super.createRenderState(prevRenderState);
    }
}

