/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import java.awt.Image;
import java.util.ArrayList;
import org.lobobrowser.html.domimpl.HTMLAbstractUIElement;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.domimpl.ImageEvent;
import org.lobobrowser.html.domimpl.ImageListener;
import org.lobobrowser.html.domimpl.UINode;
import org.w3c.dom.html2.HTMLImageElement;

public class HTMLImageElementImpl
extends HTMLAbstractUIElement
implements HTMLImageElement {
    private Image image = null;
    private String imageSrc;
    private final ArrayList listeners = new ArrayList(1);

    public HTMLImageElementImpl() {
        super("IMG");
    }

    public HTMLImageElementImpl(String name) {
        super(name);
    }

    public String getName() {
        return this.getAttribute("name");
    }

    public void setName(String name) {
        this.setAttribute("name", name);
    }

    public String getAlign() {
        return this.getAttribute("align");
    }

    public void setAlign(String align) {
        this.setAttribute("align", align);
    }

    public String getAlt() {
        return this.getAttribute("alt");
    }

    public void setAlt(String alt) {
        this.setAttribute("alt", alt);
    }

    public String getBorder() {
        return this.getAttribute("border");
    }

    public void setBorder(String border) {
        this.setAttribute("border", border);
    }

    public int getHeight() {
        UINode r2 = this.uiNode;
        return r2 == null ? 0 : r2.getBounds().height;
    }

    public void setHeight(int height) {
        this.setAttribute("height", String.valueOf(height));
    }

    public int getHspace() {
        return this.getAttributeAsInt("hspace", 0);
    }

    public void setHspace(int hspace) {
        this.setAttribute("hspace", String.valueOf("hspace"));
    }

    public boolean getIsMap() {
        return this.getAttributeAsBoolean("isMap");
    }

    public void setIsMap(boolean isMap) {
        this.setAttribute("isMap", isMap ? "isMap" : null);
    }

    public String getLongDesc() {
        return this.getAttribute("longDesc");
    }

    public void setLongDesc(String longDesc) {
        this.setAttribute("longDesc", longDesc);
    }

    public String getSrc() {
        return this.getAttribute("src");
    }

    public void setSrc(String src) {
        this.setAttribute("src", src);
    }

    public String getUseMap() {
        return this.getAttribute("useMap");
    }

    public void setUseMap(String useMap) {
        this.setAttribute("useMap", useMap);
    }

    public int getVspace() {
        return this.getAttributeAsInt("vspace", 0);
    }

    public void setVspace(int vspace) {
        this.setAttribute("vspace", String.valueOf(vspace));
    }

    public int getWidth() {
        UINode r2 = this.uiNode;
        return r2 == null ? 0 : r2.getBounds().width;
    }

    public void setWidth(int width) {
        this.setAttribute("width", String.valueOf(width));
    }

    protected void assignAttributeField(String normalName, String value) {
        super.assignAttributeField(normalName, value);
        if ("src".equals(normalName)) {
            this.loadImage(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadImage(String src) {
        HTMLDocumentImpl document = (HTMLDocumentImpl)this.document;
        if (document != null) {
            ArrayList arrayList = this.listeners;
            synchronized (arrayList) {
                this.imageSrc = src;
                this.image = null;
            }
            if (src != null) {
                document.loadImage(src, new LocalImageListener(src));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Image getImage() {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            return this.image;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImageListener(ImageListener listener) {
        Image currentImage;
        ArrayList l2;
        ArrayList arrayList = l2 = this.listeners;
        synchronized (arrayList) {
            currentImage = this.image;
            l2.add(listener);
        }
        if (currentImage != null) {
            listener.imageLoaded(new ImageEvent(this, currentImage));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeImageListener(ImageListener listener) {
        ArrayList l2;
        ArrayList arrayList = l2 = this.listeners;
        synchronized (arrayList) {
            l2.remove(l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchEvent(String expectedImgSrc, ImageEvent event) {
        ImageListener[] listenerArray;
        ArrayList l2;
        ArrayList arrayList = l2 = this.listeners;
        synchronized (arrayList) {
            if (!expectedImgSrc.equals(this.imageSrc)) {
                return;
            }
            this.image = event.image;
            listenerArray = l2.toArray(ImageListener.EMPTY_ARRAY);
        }
        int llength = listenerArray.length;
        for (int i2 = 0; i2 < llength; ++i2) {
            listenerArray[i2].imageLoaded(event);
        }
    }

    private class LocalImageListener
    implements ImageListener {
        private final String expectedImgSrc;

        public LocalImageListener(String imgSrc) {
            this.expectedImgSrc = imgSrc;
        }

        public void imageLoaded(ImageEvent event) {
            HTMLImageElementImpl.this.dispatchEvent(this.expectedImgSrc, event);
        }
    }
}

