/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.util;

import flex.messaging.client.UserAgentSettings;
import flex.messaging.config.ConfigMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserAgentManager {
    public static final String USER_AGENT_HEADER_NAME = "User-Agent";
    private static final String KICKSTART_BYTES = "kickstart-bytes";
    private static final String MATCH_ON = "match-on";
    public static final String MAX_STREAMING_CONNECTIONS_PER_SESSION = "max-streaming-connections-per-session";
    private static final String USER_AGENT = "user-agent";
    private static final String USER_AGENT_SETTINGS = "user-agent-settings";
    private Map<String, UserAgentSettings> userAgentSettingsMap = new HashMap<String, UserAgentSettings>();
    private UserAgentSettings defaultSettings;

    public UserAgentSettings getUserAgentSettings(String matchOn) {
        return this.userAgentSettingsMap.get(matchOn);
    }

    public Collection<UserAgentSettings> getUserAgentSettings() {
        return this.userAgentSettingsMap.values();
    }

    public void putUserAgentSettings(UserAgentSettings userAgent) {
        this.userAgentSettingsMap.put(userAgent.getMatchOn(), userAgent);
    }

    public void removeUserAgentSettings(UserAgentSettings userAgent) {
        if (userAgent != null) {
            this.userAgentSettingsMap.remove(userAgent.getMatchOn());
        }
    }

    public void setDefaultUserAgentSettings(UserAgentSettings settings) {
        this.defaultSettings = settings;
    }

    public UserAgentSettings match(String userAgent) {
        if (userAgent != null && this.userAgentSettingsMap.size() > 0) {
            int bestMatchLength = 0;
            String matchedAgent = null;
            for (String key : this.userAgentSettingsMap.keySet()) {
                int matchLength;
                if (userAgent.indexOf(key) == -1 || (matchLength = key.length()) <= bestMatchLength) continue;
                bestMatchLength = matchLength;
                matchedAgent = key;
            }
            if (matchedAgent != null) {
                return this.userAgentSettingsMap.get(matchedAgent);
            }
        }
        return this.defaultSettings != null ? this.defaultSettings : null;
    }

    public static void setupUserAgentManager(ConfigMap properties, UserAgentManager manager) {
        List userAgent;
        manager.putUserAgentSettings(UserAgentSettings.getAgent("MSIE"));
        manager.putUserAgentSettings(UserAgentSettings.getAgent("Firefox"));
        ConfigMap userAgents = properties.getPropertyAsMap(USER_AGENT_SETTINGS, null);
        if (userAgents != null && (userAgent = userAgents.getPropertyAsList(USER_AGENT, null)) != null) {
            for (Object anUserAgent : userAgent) {
                ConfigMap agent = (ConfigMap)anUserAgent;
                String matchOn = agent.getPropertyAsString(MATCH_ON, null);
                int kickstartBytes = agent.getPropertyAsInt(KICKSTART_BYTES, 0);
                int connectionsPerSession = agent.getPropertyAsInt(MAX_STREAMING_CONNECTIONS_PER_SESSION, 1);
                if (matchOn == null) continue;
                UserAgentSettings ua2 = UserAgentSettings.getAgent(matchOn);
                ua2.setKickstartBytes(kickstartBytes);
                ua2.setMaxStreamingConnectionsPerSession(connectionsPerSession);
                if (matchOn.equals("*")) {
                    manager.setDefaultUserAgentSettings(ua2);
                    continue;
                }
                manager.putUserAgentSettings(ua2);
            }
        }
    }
}

