/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.services.messaging.selector;

import flex.messaging.MessageException;
import flex.messaging.messages.Message;
import flex.messaging.services.messaging.selector.JMSSelectorException;
import flex.messaging.services.messaging.selector.ParseException;
import flex.messaging.services.messaging.selector.SQLParser;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class JMSSelector {
    public static final String LOG_CATEGORY = "Message.Selector";
    private static final int PARSE_FAILURE = 10600;
    private static final int BAD_TYPE_COMPARISON = 10601;
    private static final int PARSER_ERROR = 10602;
    static final boolean debug = false;
    SQLParser parser;
    String pattern;
    Message msg;

    public JMSSelector(String pattern) {
        if (pattern == null) {
            pattern = "";
        }
        this.msg = null;
        this.pattern = pattern;
        ByteArrayInputStream stream = new ByteArrayInputStream(pattern.getBytes());
        this.parser = new SQLParser(this, stream);
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String p2) {
        this.pattern = p2;
        ByteArrayInputStream stream = new ByteArrayInputStream(this.pattern.getBytes());
        this.parser.ReInit(stream);
        try {
            this.match(this.msg);
        }
        catch (MessageException me) {
            throw me;
        }
        catch (Throwable t2) {
            throw new MessageException(t2);
        }
    }

    public boolean match(Message msg) {
        boolean matched = false;
        if (this.pattern.equals("")) {
            matched = true;
        } else {
            try {
                try {
                    matched = this.parser.match(msg);
                }
                catch (ParseException pex) {
                    JMSSelectorException jmse = new JMSSelectorException();
                    jmse.setMessage(10600, new Object[]{this.pattern, pex.getMessage()});
                    throw jmse;
                }
                catch (ClassCastException cce) {
                    JMSSelectorException jmse = new JMSSelectorException();
                    jmse.setMessage(10601, new Object[]{this.pattern});
                    throw jmse;
                }
                catch (Error err) {
                    JMSSelectorException jmse = new JMSSelectorException();
                    jmse.setMessage(10602, new Object[]{this.pattern, err.getMessage()});
                    throw jmse;
                }
                Object var6_3 = null;
                ByteArrayInputStream stream = new ByteArrayInputStream(this.pattern.getBytes());
                this.parser.ReInit(stream);
            }
            catch (Throwable throwable) {
                Object var6_4 = null;
                ByteArrayInputStream stream = new ByteArrayInputStream(this.pattern.getBytes());
                this.parser.ReInit(stream);
                throw throwable;
            }
        }
        return matched;
    }

    boolean matchPattern(String patternStr, String str, char escapeChar) {
        boolean matched = false;
        String escapeCharStr = String.valueOf(escapeChar);
        String wildCards = "_%";
        String delims = wildCards + escapeCharStr;
        boolean escaped = false;
        int index = 0;
        String tok = null;
        try {
            if (str != null) {
                StringTokenizer st = new StringTokenizer(patternStr, delims, true);
                ArrayList<String> tokens = new ArrayList<String>();
                boolean k2 = true;
                while (st.hasMoreTokens()) {
                    tok = st.nextToken();
                    tokens.add(tok);
                }
                matched = true;
                int numTokens = tokens.size();
                block5: for (int i2 = 0; i2 < numTokens; ++i2) {
                    tok = (String)tokens.get(i2);
                    if (tok.equals(escapeCharStr) && !escaped) {
                        escaped = true;
                        continue;
                    }
                    if (tok.equals("%") && !escaped) {
                        if (i2 == numTokens - 1) {
                            index = str.length();
                            continue;
                        }
                        if (i2 == numTokens - 1) continue;
                        int _cnt = 0;
                        ++i2;
                        while (i2 < numTokens) {
                            tok = (String)tokens.get(i2);
                            if (tok.equals(escapeCharStr) && !escaped) {
                                escaped = true;
                            } else if (!tok.equals("%") || escaped) {
                                if (tok.equals("_") && !escaped) {
                                    ++_cnt;
                                } else {
                                    int oldIndex = index;
                                    if (i2 == numTokens - 1) {
                                        if (str.endsWith(tok)) {
                                            index = str.length() - tok.length();
                                        } else {
                                            matched = false;
                                        }
                                    } else {
                                        index = str.indexOf(tok, index);
                                    }
                                    if (index < 0) {
                                        matched = false;
                                    } else if (index - oldIndex >= _cnt) {
                                        index += tok.length();
                                    } else {
                                        matched = false;
                                    }
                                    escaped = false;
                                    continue block5;
                                }
                            }
                            ++i2;
                        }
                        continue;
                    }
                    if (tok.equals("_") && !escaped) {
                        ++index;
                        continue;
                    }
                    int tokLen = tok.length();
                    if (index + tokLen <= str.length()) {
                        String subStr = null;
                        try {
                            subStr = str.substring(index, index + tokLen);
                        }
                        catch (StringIndexOutOfBoundsException e2) {
                            matched = false;
                            break;
                        }
                        if (!subStr.equalsIgnoreCase(tok)) {
                            matched = false;
                            break;
                        }
                        index += tok.length();
                    } else {
                        matched = false;
                        break;
                    }
                    escaped = false;
                }
            }
            if (matched && index != str.length()) {
                matched = false;
            }
        }
        catch (StringIndexOutOfBoundsException e3) {
            matched = false;
        }
        return matched;
    }

    String processStringLiteral(String strLiteral) {
        int index = (strLiteral = strLiteral.substring(1, strLiteral.length() - 1)).indexOf("''");
        if (index > -1) {
            StringBuffer sb2 = new StringBuffer(strLiteral);
            while (index != -1) {
                sb2.deleteCharAt(index);
                index = sb2.toString().indexOf("''");
            }
            strLiteral = sb2.toString();
        }
        return strLiteral;
    }
}

