/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.services.messaging;

import flex.messaging.services.ServiceException;
import java.util.StringTokenizer;

public class Subtopic {
    public static final String SUBTOPIC_WILDCARD = "*";
    private String subtopic;
    private String separator;
    private boolean hierarchical;
    private boolean hasSubtopicWildcard;

    public Subtopic(String subtopic, String separator) {
        this.subtopic = subtopic;
        this.separator = separator;
        if (subtopic.length() == 0) {
            ServiceException se = new ServiceException();
            se.setMessage(10554, new Object[]{subtopic});
            throw se;
        }
        if (separator != null && subtopic.indexOf(separator) != -1) {
            this.hierarchical = true;
            if (subtopic.startsWith(separator) || subtopic.endsWith(separator) || subtopic.indexOf(separator + separator) != -1) {
                ServiceException se = new ServiceException();
                se.setMessage(10554, new Object[]{subtopic});
                throw se;
            }
            StringTokenizer tokenizer = new StringTokenizer(subtopic, separator);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token.indexOf(SUBTOPIC_WILDCARD) == -1) continue;
                if (!token.equals(SUBTOPIC_WILDCARD)) {
                    ServiceException se = new ServiceException();
                    se.setMessage(10554, new Object[]{subtopic});
                    throw se;
                }
                this.hasSubtopicWildcard = true;
            }
        } else if (subtopic.indexOf(SUBTOPIC_WILDCARD) != -1) {
            if (!subtopic.equals(SUBTOPIC_WILDCARD)) {
                ServiceException se = new ServiceException();
                se.setMessage(10554, new Object[]{subtopic});
                throw se;
            }
            this.hasSubtopicWildcard = true;
        }
    }

    public boolean containsSubtopicWildcard() {
        return this.hasSubtopicWildcard;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Subtopic) || other == null) {
            return false;
        }
        Subtopic otherSubtopic = (Subtopic)other;
        return this.subtopic.equals(otherSubtopic.subtopic) && (this.separator.equals(otherSubtopic.separator) || this.separator == null && otherSubtopic.separator == null);
    }

    public String getSeparator() {
        return this.separator;
    }

    public String getValue() {
        return this.subtopic;
    }

    public int hashCode() {
        return this.subtopic.hashCode();
    }

    public boolean isHierarchical() {
        return this.hierarchical;
    }

    public boolean matches(Subtopic other) {
        if (!this.hasSubtopicWildcard && !other.hasSubtopicWildcard) {
            return this.subtopic.equals(other.subtopic);
        }
        if (this.hierarchical && other.hierarchical && !this.separator.equals(other.separator)) {
            return false;
        }
        StringTokenizer t1 = new StringTokenizer(this.subtopic, this.separator);
        StringTokenizer t2 = new StringTokenizer(other.subtopic, other.separator);
        int n2 = t1.countTokens();
        int difference = n2 - t2.countTokens();
        String tok1 = null;
        String tok2 = null;
        while (n2-- > 0) {
            tok1 = t1.nextToken();
            boolean matchToken = !tok1.equals(SUBTOPIC_WILDCARD);
            if (!t2.hasMoreTokens()) break;
            tok2 = t2.nextToken();
            if (tok2.equals(SUBTOPIC_WILDCARD) || !matchToken || tok1.equals(tok2)) continue;
            return false;
        }
        if (difference == 0) {
            return true;
        }
        if (difference < 0 && tok1.equals(SUBTOPIC_WILDCARD)) {
            return true;
        }
        return difference > 0 && tok2.equals(SUBTOPIC_WILDCARD);
    }

    public String toString() {
        return this.subtopic;
    }
}

