/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.services;

import edu.emory.mathcs.backport.java.util.concurrent.locks.ReadWriteLock;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantReadWriteLock;
import flex.management.runtime.messaging.MessageDestinationControl;
import flex.management.runtime.messaging.services.MessageServiceControl;
import flex.messaging.Destination;
import flex.messaging.FlexContext;
import flex.messaging.MessageBroker;
import flex.messaging.MessageClient;
import flex.messaging.MessageDestination;
import flex.messaging.MessageException;
import flex.messaging.MessageRoutedNotifier;
import flex.messaging.client.FlushResult;
import flex.messaging.cluster.Cluster;
import flex.messaging.cluster.ClusterManager;
import flex.messaging.config.ServerSettings;
import flex.messaging.log.Log;
import flex.messaging.messages.AcknowledgeMessage;
import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.Message;
import flex.messaging.messages.MessagePerformanceUtils;
import flex.messaging.services.AbstractService;
import flex.messaging.services.ServiceAdapter;
import flex.messaging.services.ServiceException;
import flex.messaging.services.messaging.MessagingConstants;
import flex.messaging.services.messaging.RemoteSubscriptionManager;
import flex.messaging.services.messaging.SubscriptionManager;
import flex.messaging.services.messaging.Subtopic;
import flex.messaging.services.messaging.ThrottleManager;
import flex.messaging.services.messaging.adapters.MessagingAdapter;
import flex.messaging.services.messaging.selector.JMSSelector;
import flex.messaging.util.StringUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class MessageService
extends AbstractService
implements MessagingConstants {
    public static final String LOG_CATEGORY = "Service.Message";
    public static final String TIMING_LOG_CATEGORY = "Message.Timing";
    public static final String NOT_SUBSCRIBED_CODE = "Server.Processing.NotSubscribed";
    private static final int BAD_SELECTOR = 10550;
    private static final int NOT_SUBSCRIBED = 10551;
    private static final int UNKNOWN_COMMAND = 10552;
    private MessageServiceControl controller;
    private ReadWriteLock subscribeLock = new ReentrantReadWriteLock();

    public MessageService() {
        super(false);
    }

    public MessageService(boolean enableManagement) {
        super(enableManagement);
    }

    public void start() {
        MessageDestination dest;
        String serviceType = this.getClass().getName();
        ClusterManager clm = this.getMessageBroker().getClusterManager();
        super.start();
        for (String destName : this.destinations.keySet()) {
            dest = (MessageDestination)this.getDestination(destName);
            if (dest.getServerSettings().isBroadcastRoutingMode() || !dest.isClustered()) continue;
            this.initRemoteSubscriptions(destName);
        }
        for (String destName : this.destinations.keySet()) {
            dest = (MessageDestination)this.getDestination(destName);
            if (dest.getServerSettings().isBroadcastRoutingMode() || !dest.isClustered()) continue;
            List members = clm.getClusterMemberAddresses(serviceType, destName);
            for (int i2 = 0; i2 < members.size(); ++i2) {
                Object addr = members.get(i2);
                if (clm.getLocalAddress(serviceType, destName).equals(addr)) continue;
                RemoteSubscriptionManager subMgr = dest.getRemoteSubscriptionManager();
                subMgr.waitForSubscriptions(addr);
            }
        }
    }

    public Destination createDestination(String id2) {
        MessageDestination destination = new MessageDestination();
        destination.setId(id2);
        destination.setManaged(this.isManaged());
        destination.setService(this);
        return destination;
    }

    public void addDestination(Destination destination) {
        MessageDestination messageDestination = (MessageDestination)destination;
        super.addDestination(messageDestination);
    }

    public Object serviceMessage(Message message) {
        return this.serviceMessage(message, true);
    }

    public Object serviceMessage(Message message, boolean throttle) {
        Object result = null;
        this.incrementMessageCount(false, message);
        MessageDestination dest = (MessageDestination)this.getDestination(message);
        ThrottleManager.ThrottleResult throttleResult = throttle ? dest.getThrottleManager().throttleIncomingMessage(message) : new ThrottleManager.ThrottleResult(0);
        int throttleResultCode = throttleResult.getResultCode();
        MessageException me = throttleResult.getException();
        if (throttleResultCode == 3) {
            throw me;
        }
        if (throttleResultCode == 1) {
            if (Log.isDebug()) {
                Log.getLogger(LOG_CATEGORY).debug(me.getMessage(), me);
            }
        } else {
            ServiceAdapter adapter;
            List<Object> subtopicObj = message.getHeader("DSSubtopic");
            if (subtopicObj instanceof Object[]) {
                subtopicObj = Arrays.asList((Object[])subtopicObj);
            }
            if (subtopicObj instanceof String) {
                String subtopicString = (String)((Object)subtopicObj);
                this.testProducerSubtopic(dest, subtopicString);
            } else if (subtopicObj instanceof List) {
                List<Object> subtopicList = subtopicObj;
                for (int i2 = 0; i2 < subtopicList.size(); ++i2) {
                    this.testProducerSubtopic(dest, (String)subtopicList.get(i2));
                }
            }
            ServerSettings destServerSettings = dest.getServerSettings();
            if (destServerSettings.getMessageTTL() >= 0L) {
                message.setTimeToLive(destServerSettings.getMessageTTL());
            }
            long start = 0L;
            if (Log.isDebug()) {
                start = System.currentTimeMillis();
            }
            if ((adapter = dest.getAdapter()) instanceof MessagingAdapter) {
                ((MessagingAdapter)adapter).getSecurityConstraintManager().assertSendAuthorization();
            }
            MessagePerformanceUtils.markServerPreAdapterTime(message);
            result = adapter.invoke(message);
            MessagePerformanceUtils.markServerPostAdapterTime(message);
            if (Log.isDebug()) {
                long end = System.currentTimeMillis();
                Log.getLogger(TIMING_LOG_CATEGORY).debug("After invoke service: " + this.getId() + "; execution time = " + (end - start) + "ms");
            }
        }
        return result;
    }

    public Object serviceCommand(CommandMessage message) {
        this.incrementMessageCount(true, message);
        Object commandResult = super.serviceCommonCommands(message);
        if (commandResult == null) {
            commandResult = this.manageSubscriptions(message);
        }
        return commandResult;
    }

    public void serviceMessageFromAdapter(Message message, boolean sendToAllSubscribers) {
        MessageDestinationControl destinationControl;
        MessageDestination destination;
        if (this.isManaged() && (destination = (MessageDestination)this.getDestination(message.getDestination())) != null && destination.isManaged() && (destinationControl = (MessageDestinationControl)destination.getControl()) != null) {
            destinationControl.incrementServiceMessageFromAdapterCount();
        }
        if (sendToAllSubscribers) {
            this.pushMessageToClients(message, false);
            this.sendPushMessageFromPeer(message, false);
        } else {
            TreeSet<Object> subscriberIds = new TreeSet<Object>();
            subscriberIds.add(message.getClientId());
            this.pushMessageToClients(subscriberIds, message, false);
        }
    }

    public void sendPushMessageFromPeer(Message message, boolean evalSelector) {
        MessageDestination destination = (MessageDestination)this.getDestination(message);
        if (destination.isClustered()) {
            ClusterManager clm = this.getMessageBroker().getClusterManager();
            if (destination.getServerSettings().isBroadcastRoutingMode()) {
                if (Log.isDebug()) {
                    Log.getLogger(LOG_CATEGORY).debug("Broadcasting message to peer servers: " + message + " evalSelector: " + evalSelector);
                }
                clm.invokeServiceOperation(this.getClass().getName(), message.getDestination(), "pushMessageFromPeer", new Object[]{message, evalSelector});
            } else {
                RemoteSubscriptionManager mgr = destination.getRemoteSubscriptionManager();
                Set serverAddresses = mgr.getSubscriberIds(message, evalSelector);
                if (Log.isDebug()) {
                    Log.getLogger(LOG_CATEGORY).debug("Sending message to peer servers: " + serverAddresses + StringUtils.NEWLINE + " message: " + message + StringUtils.NEWLINE + " evalSelector: " + evalSelector);
                }
                for (Object remoteAddress : serverAddresses) {
                    clm.invokePeerToPeerOperation(this.getClass().getName(), message.getDestination(), "pushMessageFromPeerToPeer", new Object[]{message, evalSelector}, remoteAddress);
                }
            }
        }
    }

    public void pushMessageFromPeerToPeer(AsyncMessage message, Boolean evalSelector, Object address) {
        this.pushMessageFromPeer(message, evalSelector);
    }

    public void pushMessageFromPeer(AsyncMessage message, Boolean evalSelector) {
        if (!this.isStarted()) {
            Log.getLogger(LOG_CATEGORY).debug("Received message from peer server before server is started - ignoring: " + message + " evalSelector: " + evalSelector);
            return;
        }
        if (Log.isDebug()) {
            Log.getLogger(LOG_CATEGORY).debug("Received message from peer server: " + message + " evalSelector: " + evalSelector);
        }
        FlexContext.setMessageFromPeer(true);
        this.pushMessageToClients(message, evalSelector);
        FlexContext.setMessageFromPeer(false);
    }

    public void pushMessageToClients(Message message, boolean evalSelector) {
        MessageDestination destination = (MessageDestination)this.getDestination(message);
        SubscriptionManager subscriptionManager = destination.getSubscriptionManager();
        Set subscriberIds = subscriptionManager.getSubscriberIds(message, evalSelector);
        if (Log.isDebug()) {
            Log.getLogger(LOG_CATEGORY).debug("Sending message: " + message + StringUtils.NEWLINE + "    to subscribed clientIds: " + subscriberIds);
        }
        if (subscriberIds != null && !subscriberIds.isEmpty()) {
            this.pushMessageToClients(destination, subscriberIds, message, false);
        }
    }

    public Set getSubscriberIds(Message message, boolean evalSelector) {
        MessageDestination destination = (MessageDestination)this.getDestination(message);
        SubscriptionManager subscriptionManager = destination.getSubscriptionManager();
        return subscriptionManager.getSubscriberIds(message, evalSelector);
    }

    public Set getSubscriberIds(String destinationId, String subtopicPattern, Map messageHeaders) {
        MessageDestination destination = (MessageDestination)this.getDestination(destinationId);
        SubscriptionManager subscriptionManager = destination.getSubscriptionManager();
        return subscriptionManager.getSubscriberIds(subtopicPattern, messageHeaders);
    }

    public void pushMessageToClients(Set subscriberIds, Message message, boolean evalSelector) {
        MessageDestination destination = (MessageDestination)this.getDestination(message);
        this.pushMessageToClients(destination, subscriberIds, message, evalSelector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushMessageToClients(MessageDestination destination, Set subscriberIds, Message message, boolean evalSelector) {
        if (subscriberIds != null) {
            try {
                MessageRoutedNotifier routingNotifier = new MessageRoutedNotifier(message);
                FlexContext.setMessageRoutedNotifier(routingNotifier);
                ThrottleManager.ThrottleResult throttleResult = destination.getThrottleManager().throttleOutgoingMessage(message, null);
                int throttleResultCode = throttleResult.getResultCode();
                MessageException me = throttleResult.getException();
                if (throttleResultCode == 3) {
                    throw me;
                }
                if (throttleResultCode == 1) {
                    if (Log.isDebug()) {
                        Log.getLogger(LOG_CATEGORY).debug(me.getMessage(), me);
                    }
                } else {
                    SubscriptionManager subscriptionManager = destination.getSubscriptionManager();
                    for (Object clientId : subscriberIds) {
                        MessageClient client = subscriptionManager.getSubscriber(clientId);
                        if (client == null || !client.isValid()) {
                            if (!Log.isDebug()) continue;
                            Log.getLogger(LOG_CATEGORY).debug("Warning: could not find MessageClient for clientId in pushMessageToClients: " + clientId + " for destination: " + destination.getId());
                            continue;
                        }
                        this.pushMessageToClient(client, destination, message, evalSelector, throttleResult);
                    }
                }
                routingNotifier.notifyMessageRouted();
                Object var14_13 = null;
            }
            catch (Throwable throwable) {
                Object var14_14 = null;
                FlexContext.setMessageRoutedNotifier(null);
                throw throwable;
            }
            FlexContext.setMessageRoutedNotifier(null);
            {
            }
        }
    }

    void pushMessageToClient(MessageClient client, MessageDestination destination, Message message, boolean evalSelector, ThrottleManager.ThrottleResult throttleResult) {
        if (evalSelector && !client.testMessage(message, destination)) {
            return;
        }
        if (throttleResult.getResultCode() == 0) {
            throttleResult = destination.getThrottleManager().throttleOutgoingMessage(message, client.getClientId());
            int throttleResultCode = throttleResult.getResultCode();
            MessageException me = throttleResult.getException();
            if (throttleResultCode == 3) {
                Log.getLogger(LOG_CATEGORY).error(me.getMessage(), me);
            } else if (throttleResultCode == 1) {
                if (Log.isDebug()) {
                    Log.getLogger(LOG_CATEGORY).debug(me.getMessage(), me);
                }
            } else {
                try {
                    if (!(message instanceof CommandMessage)) {
                        client.updateLastUse();
                    }
                    Map messageHeaders = message.getHeaders();
                    messageHeaders.remove("DSId");
                    messageHeaders.remove("DSEndpoint");
                    Message messageForClient = (Message)message.clone();
                    MessagePerformanceUtils.markServerPrePushTime(message);
                    MessagePerformanceUtils.markServerPostAdapterTime(message);
                    MessagePerformanceUtils.markServerPostAdapterExternalTime(message);
                    messageForClient.setClientId(client.getClientId());
                    if (Log.isDebug()) {
                        Log.getLogger(LOG_CATEGORY).debug("Routing message to FlexClient id:" + client.getFlexClient().getId() + "', MessageClient id: " + client.getClientId());
                    }
                    this.getMessageBroker().routeMessageToMessageClient(messageForClient, client);
                }
                catch (MessageException ignore) {
                    // empty catch block
                }
            }
        }
    }

    public void initRemoteSubscriptions(String destinationId) {
        ClusterManager clm = this.getMessageBroker().getClusterManager();
        String serviceType = this.getClass().getName();
        MessageDestination dest = (MessageDestination)this.getDestination(destinationId);
        Cluster cluster = clm.getCluster(serviceType, destinationId);
        if (cluster != null) {
            cluster.addRemoveNodeListener(dest.getRemoteSubscriptionManager());
        }
        List members = clm.getClusterMemberAddresses(serviceType, destinationId);
        for (int i2 = 0; i2 < members.size(); ++i2) {
            Object addr = members.get(i2);
            if (clm.getLocalAddress(serviceType, destinationId).equals(addr)) continue;
            this.requestSubscriptions(destinationId, addr);
        }
    }

    public void requestSubscriptions(String destinationId, Object remoteAddress) {
        ClusterManager clm = this.getMessageBroker().getClusterManager();
        clm.invokePeerToPeerOperation(this.getClass().getName(), destinationId, "sendSubscriptions", new Object[]{destinationId}, remoteAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendSubscriptions(String destinationId, Object remoteAddress) {
        MessageDestination destination = (MessageDestination)this.getDestination(destinationId);
        if (destination == null) {
            if (Log.isError()) {
                Log.getLogger(LOG_CATEGORY).error("Destination: " + destinationId + " does not exist on this server but we received a request for the subscription info from a peer server where the destination exists as clustered.  Check the cluster configuration for this destination and make sure it matches on all servers.");
            }
            return;
        }
        if (!destination.isClustered()) {
            if (Log.isError()) {
                Log.getLogger(LOG_CATEGORY).error("Destination: " + destinationId + " is not clustered on this server but we received a request for the subscription info from a peer server which is clustered.  Check the cluster configuration for this destination and make sure it matches on all servers.");
            }
            return;
        }
        RemoteSubscriptionManager subMgr = destination.getRemoteSubscriptionManager();
        subMgr.setSubscriptionState(Collections.EMPTY_LIST, remoteAddress);
        try {
            this.subscribeLock.writeLock().lock();
            Object subscriptions = destination instanceof MessageDestination ? destination.getSubscriptionManager().getSubscriptionState() : null;
            ClusterManager clm = this.getMessageBroker().getClusterManager();
            clm.invokePeerToPeerOperation(this.getClass().getName(), destinationId, "receiveSubscriptions", new Object[]{destinationId, subscriptions}, remoteAddress);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.subscribeLock.writeLock().unlock();
            throw throwable;
        }
        this.subscribeLock.writeLock().unlock();
    }

    public void receiveSubscriptions(String destinationId, Object subscriptions, Object senderAddress) {
        Destination destination = this.getDestination(destinationId);
        if (destination instanceof MessageDestination) {
            ((MessageDestination)destination).getRemoteSubscriptionManager().setSubscriptionState(subscriptions, senderAddress);
        } else if (subscriptions != null && Log.isError()) {
            Log.getLogger(LOG_CATEGORY).error("receiveSubscriptions called with non-null value but destination: " + destinationId + " is not a MessageDestination");
        }
    }

    public void sendSubscribeFromPeer(String destinationId, Boolean subscribe, String selector, String subtopic) {
        ClusterManager clm = this.getMessageBroker().getClusterManager();
        String serviceType = this.getClass().getName();
        clm.invokeServiceOperation(serviceType, destinationId, "subscribeFromPeer", new Object[]{destinationId, subscribe, selector, subtopic, clm.getLocalAddress(serviceType, destinationId)});
    }

    public void subscribeFromPeer(String destinationId, Boolean subscribe, String selector, String subtopic, Object remoteAddress) {
        Destination destination = this.getDestination(destinationId);
        RemoteSubscriptionManager subMgr = ((MessageDestination)destination).getRemoteSubscriptionManager();
        if (destination instanceof MessageDestination) {
            if (Log.isDebug()) {
                Log.getLogger(LOG_CATEGORY).debug("Received subscription from peer: " + remoteAddress + " subscribe? " + subscribe + " selector: " + selector + " subtopic: " + subtopic);
            }
            if (subscribe.booleanValue()) {
                subMgr.addSubscriber(remoteAddress, selector, subtopic, null);
            } else {
                subMgr.removeSubscriber(remoteAddress, selector, subtopic, null);
            }
        } else if (Log.isError()) {
            Log.getLogger(LOG_CATEGORY).error("subscribeFromPeer called with destination: " + destinationId + " that is not a MessageDestination");
        }
    }

    protected void incrementMessageCount(boolean commandMessage, Message message) {
        MessageDestinationControl destinationControl;
        MessageDestination destination;
        if (this.isManaged() && (destination = (MessageDestination)this.getDestination(message.getDestination())) != null && destination.isManaged() && (destinationControl = (MessageDestinationControl)destination.getControl()) != null) {
            if (commandMessage) {
                destinationControl.incrementServiceCommandCount();
            } else {
                destinationControl.incrementServiceMessageCount();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message manageSubscriptions(CommandMessage command) {
        Message replyMessage = null;
        MessageDestination destination = (MessageDestination)this.getDestination(command);
        SubscriptionManager subscriptionManager = destination.getSubscriptionManager();
        Object clientId = command.getClientId();
        String endpointId = (String)command.getHeader("DSEndpoint");
        String subtopicString = (String)command.getHeader("DSSubtopic");
        ServiceAdapter adapter = destination.getAdapter();
        if (command.getOperation() == 0) {
            String selectorExpr = (String)command.getHeader("DSSelector");
            this.getMessageBroker().inspectChannel(command, destination);
            if (adapter instanceof MessagingAdapter) {
                ((MessagingAdapter)adapter).getSecurityConstraintManager().assertSubscribeAuthorization();
            }
            try {
                this.subscribeLock.readLock().lock();
                if (adapter.handlesSubscriptions()) {
                    replyMessage = (Message)adapter.manage(command);
                } else {
                    this.testSelector(selectorExpr, command);
                }
                subscriptionManager.addSubscriber(clientId, selectorExpr, subtopicString, endpointId);
                Object var11_14 = null;
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                this.subscribeLock.readLock().unlock();
                throw throwable;
            }
            this.subscribeLock.readLock().unlock();
            if (replyMessage == null) {
                replyMessage = new AcknowledgeMessage();
            }
        } else if (command.getOperation() == 1) {
            if (adapter instanceof MessagingAdapter && command.getHeader("DSSubscriptionInvalidated") == null) {
                ((MessagingAdapter)adapter).getSecurityConstraintManager().assertSubscribeAuthorization();
            }
            String selectorExpr = (String)command.getHeader("DSSelector");
            try {
                this.subscribeLock.readLock().lock();
                if (adapter.handlesSubscriptions()) {
                    replyMessage = (Message)adapter.manage(command);
                }
                subscriptionManager.removeSubscriber(clientId, selectorExpr, subtopicString, endpointId);
                Object var13_22 = null;
            }
            catch (Throwable throwable) {
                Object var13_23 = null;
                this.subscribeLock.readLock().unlock();
                throw throwable;
            }
            this.subscribeLock.readLock().unlock();
            if (replyMessage == null) {
                replyMessage = new AcknowledgeMessage();
            }
        } else if (command.getOperation() == 11) {
            this.getMessageBroker().inspectChannel(command, destination);
            if (adapter instanceof MessagingAdapter) {
                ((MessagingAdapter)adapter).getSecurityConstraintManager().assertSubscribeAuthorization();
            }
            try {
                String selector;
                String subtopic;
                int ix;
                String ss;
                int i2;
                this.subscribeLock.readLock().lock();
                if (adapter.handlesSubscriptions()) {
                    replyMessage = (Message)adapter.manage(command);
                }
                Object[] adds = this.getObjectArrayFromHeader(command.getHeader("DSAddSub"));
                Object[] rems = this.getObjectArrayFromHeader(command.getHeader("DSRemSub"));
                if (adds != null) {
                    for (i2 = 0; i2 < adds.length; ++i2) {
                        ss = (String)adds[i2];
                        ix = ss.indexOf("_;_");
                        if (ix == -1) continue;
                        subtopic = ix == 0 ? null : ss.substring(0, ix);
                        selector = ss.substring(ix + "_;_".length());
                        if (selector.length() == 0) {
                            selector = null;
                        }
                        subscriptionManager.addSubscriber(clientId, selector, subtopic, endpointId);
                    }
                }
                if (rems != null) {
                    for (i2 = 0; i2 < rems.length; ++i2) {
                        ss = (String)rems[i2];
                        ix = ss.indexOf("_;_");
                        if (ix == -1) continue;
                        subtopic = ix == 0 ? null : ss.substring(0, ix);
                        selector = ss.substring(ix + "_;_".length());
                        if (selector.length() == 0) {
                            selector = null;
                        }
                        subscriptionManager.removeSubscriber(clientId, selector, subtopic, endpointId);
                    }
                }
                Object var17_30 = null;
            }
            catch (Throwable throwable) {
                Object var17_31 = null;
                this.subscribeLock.readLock().unlock();
                throw throwable;
            }
            this.subscribeLock.readLock().unlock();
            if (replyMessage == null) {
                replyMessage = new AcknowledgeMessage();
            }
        } else if (command.getOperation() == 2) {
            MessageClient client = null;
            try {
                client = subscriptionManager.getMessageClient(clientId, endpointId);
                if (client != null) {
                    FlushResult flushResult;
                    List messagesToReturn;
                    List missedMessages;
                    if (adapter.handlesSubscriptions() && (missedMessages = (List)adapter.manage(command)) != null && !missedMessages.isEmpty()) {
                        MessageBroker broker = this.getMessageBroker();
                        Iterator iter = missedMessages.iterator();
                        while (iter.hasNext()) {
                            broker.routeMessageToMessageClient((Message)iter.next(), client);
                        }
                    }
                    List list = messagesToReturn = (flushResult = client.getFlexClient().poll(client)) != null ? flushResult.getMessages() : null;
                    if (messagesToReturn != null && !messagesToReturn.isEmpty()) {
                        replyMessage = new CommandMessage(4);
                        replyMessage.setBody(messagesToReturn.toArray());
                    } else {
                        replyMessage = new AcknowledgeMessage();
                    }
                } else {
                    ServiceException se = new ServiceException();
                    se.setCode(NOT_SUBSCRIBED_CODE);
                    se.setMessage(10551, new Object[]{destination.getId()});
                    throw se;
                }
                Object var19_33 = null;
                subscriptionManager.releaseMessageClient(client);
            }
            catch (Throwable throwable) {
                Object var19_34 = null;
                subscriptionManager.releaseMessageClient(client);
                throw throwable;
            }
        } else {
            ServiceException se = new ServiceException();
            se.setMessage(10552, new Object[]{new Integer(command.getOperation())});
            throw se;
        }
        return replyMessage;
    }

    protected String getLogCategory() {
        return LOG_CATEGORY;
    }

    protected void setupServiceControl(MessageBroker broker) {
        this.controller = new MessageServiceControl(this, broker.getControl());
        this.controller.register();
        this.setControl(this.controller);
    }

    private void testSelector(String selectorExpression, Message msg) {
        try {
            JMSSelector selector = new JMSSelector(selectorExpression);
            selector.match(msg);
        }
        catch (Exception e2) {
            ServiceException se = new ServiceException();
            se.setMessage(10550, new Object[]{selectorExpression});
            se.setRootCause(e2);
            throw se;
        }
    }

    private void testProducerSubtopic(MessageDestination dest, String subtopicString) {
        Subtopic subtopic;
        if (subtopicString != null && subtopicString.length() > 0 && (subtopic = new Subtopic(subtopicString, dest.getServerSettings().getSubtopicSeparator())).containsSubtopicWildcard()) {
            ServiceException se = new ServiceException();
            se.setMessage(10556, new Object[]{subtopicString});
            throw se;
        }
    }

    private Object[] getObjectArrayFromHeader(Object header) {
        if (header instanceof Object[]) {
            return (Object[])header;
        }
        if (header instanceof List) {
            return ((List)header).toArray();
        }
        if (header == null) {
            return null;
        }
        ServiceException se = new ServiceException();
        se.setMessage("Invalid header: " + header + " in message.  expected array or list and found: " + header.getClass().getName());
        throw se;
    }
}

