/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.log;

import flex.messaging.LocalizedException;
import flex.messaging.config.ConfigMap;
import flex.messaging.log.Logger;
import flex.messaging.log.Target;
import flex.messaging.util.PrettyPrinter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Log {
    public static final String INVALID_CHARS = "[]~$^&\\/(){}<>+=`!#%?,:;'\"@";
    private static final int INVALID_TARGET = 10013;
    private static final int INVALID_CATEGORY = 10014;
    private static final int INVALID_CATEGORY_CHARS = 10015;
    private static Log log;
    private static PrettyPrinter prettyPrinter;
    private static String prettyPrinterClass;
    private static final HashSet excludedProperties;
    public static final String VALUE_SUPRESSED = "** [Value Suppressed] **";
    private volatile short targetLevel = (short)2000;
    private final Map loggers = new HashMap();
    private final List targets = new ArrayList();
    private final Map targetMap = new LinkedHashMap();
    private static final Object staticLock;

    private Log() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Log createLog() {
        Object object = staticLock;
        synchronized (object) {
            if (log == null) {
                log = new Log();
            }
            return log;
        }
    }

    public static synchronized void initialize(String id2, ConfigMap properties) {
        ConfigMap excludeMap;
        String value = properties.getPropertyAsString("pretty-printer", null);
        if (value != null) {
            prettyPrinterClass = value;
        }
        if ((excludeMap = properties.getPropertyAsMap("exclude-properties", null)) != null && excludeMap.getPropertyAsList("property", null) != null) {
            excludedProperties.addAll(excludeMap.getPropertyAsList("property", null));
        }
    }

    public static boolean isFatal() {
        return log == null ? false : Log.log.targetLevel <= 1000;
    }

    public static boolean isError() {
        return log == null ? false : Log.log.targetLevel <= 8;
    }

    public static boolean isWarn() {
        return log == null ? false : Log.log.targetLevel <= 6;
    }

    public static boolean isInfo() {
        return log == null ? false : Log.log.targetLevel <= 4;
    }

    public static boolean isDebug() {
        return log == null ? false : Log.log.targetLevel <= 2;
    }

    public static boolean isExcludedProperty(String property) {
        return !excludedProperties.isEmpty() && excludedProperties.contains(property);
    }

    public static Logger getLogger(String category) {
        if (log != null) {
            return Log.getLogger(log, category);
        }
        return new Logger(category);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getLogger(Log log, String category) {
        Log.checkCategory(category);
        Object object = staticLock;
        synchronized (object) {
            Logger result = (Logger)log.loggers.get(category);
            if (result == null) {
                result = new Logger(category);
                Iterator iter = log.targets.iterator();
                while (iter.hasNext()) {
                    Target target = (Target)iter.next();
                    if (!Log.categoryMatchInFilterList(category, target.getFilters())) continue;
                    target.addLogger(result);
                }
                log.loggers.put(category, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getTargets() {
        if (log != null) {
            List currentTargets;
            Object object = staticLock;
            synchronized (object) {
                currentTargets = Collections.unmodifiableList(new ArrayList(Log.log.targets));
            }
            return currentTargets;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getTargetMap() {
        if (log != null) {
            LinkedHashMap currentTargets;
            Object object = staticLock;
            synchronized (object) {
                currentTargets = new LinkedHashMap(Log.log.targetMap);
            }
            return currentTargets;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Target getTarget(String searchId) {
        if (log != null) {
            Object object = staticLock;
            synchronized (object) {
                return (Target)Log.log.targetMap.get(searchId);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getLoggers() {
        String[] currentCategories;
        if (log != null) {
            Object object = staticLock;
            synchronized (object) {
                Object[] currentCategoryObjects = this.loggers.keySet().toArray();
                currentCategories = new String[currentCategoryObjects.length];
                for (int i2 = 0; i2 < currentCategoryObjects.length; ++i2) {
                    currentCategories[i2] = (String)currentCategoryObjects[i2];
                }
            }
        } else {
            currentCategories = new String[]{};
        }
        return currentCategories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTarget(Target target) {
        if (log != null) {
            if (target != null) {
                Object object = staticLock;
                synchronized (object) {
                    List filters = target.getFilters();
                    Iterator it = Log.log.loggers.keySet().iterator();
                    while (it.hasNext()) {
                        String key = (String)it.next();
                        if (!Log.categoryMatchInFilterList(key, filters)) continue;
                        target.addLogger((Logger)Log.log.loggers.get(key));
                    }
                    if (!Log.log.targets.contains(target)) {
                        Log.log.targets.add(target);
                    }
                    if (!Log.log.targetMap.containsValue(target)) {
                        String name = target.getClass().getName();
                        if (name.indexOf(".") > -1) {
                            String[] classes = name.split("\\.");
                            name = classes[classes.length - 1];
                        }
                        Log.log.targetMap.put(new String(name + Log.log.targetMap.size()), target);
                    }
                    short targetLevel = target.getLevel();
                    if (Log.log.targetLevel == 2000) {
                        Log.log.targetLevel = targetLevel;
                    } else if (targetLevel < Log.log.targetLevel) {
                        Log.log.targetLevel = targetLevel;
                    }
                }
            } else {
                LocalizedException ex = new LocalizedException();
                ex.setMessage(10013);
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeTarget(Target target) {
        if (log != null) {
            if (target != null) {
                Object object = staticLock;
                synchronized (object) {
                    List filters = target.getFilters();
                    Iterator it = Log.log.loggers.keySet().iterator();
                    while (it.hasNext()) {
                        String key = (String)it.next();
                        if (!Log.categoryMatchInFilterList(key, filters)) continue;
                        target.removeLogger((Logger)Log.log.loggers.get(key));
                    }
                    Log.log.targets.remove(target);
                    Log.resetTargetLevel();
                }
            } else {
                LocalizedException ex = new LocalizedException();
                ex.setMessage(10013);
                throw ex;
            }
        }
    }

    public static synchronized void reset() {
        Log.flush();
    }

    public static void flush() {
        if (log != null) {
            Log.log.loggers.clear();
            Log.log.targets.clear();
            Log.log.targetLevel = (short)2000;
        }
    }

    public static short readLevel(String l2) {
        int lvl = 8;
        if (l2 != null && l2.length() > 0) {
            l2 = l2.trim().toLowerCase();
            char c2 = l2.charAt(0);
            switch (c2) {
                case 'n': {
                    lvl = 2000;
                    break;
                }
                case 'e': {
                    lvl = 8;
                    break;
                }
                case 'w': {
                    lvl = 6;
                    break;
                }
                case 'i': {
                    lvl = 4;
                    break;
                }
                case 'd': {
                    lvl = 2;
                    break;
                }
                case 'a': {
                    lvl = 0;
                    break;
                }
                default: {
                    lvl = 8;
                }
            }
        }
        return (short)lvl;
    }

    public static boolean hasIllegalCharacters(String value) {
        char[] chars = value.toCharArray();
        for (int i2 = 0; i2 < chars.length; ++i2) {
            char c2 = chars[i2];
            if (INVALID_CHARS.indexOf(c2) == -1) continue;
            return true;
        }
        return false;
    }

    public static PrettyPrinter getPrettyPrinter() {
        if (prettyPrinter == null || !prettyPrinter.getClass().getName().equals(prettyPrinterClass)) {
            try {
                Class<?> c2 = Class.forName(prettyPrinterClass);
                prettyPrinter = (PrettyPrinter)c2.newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return (PrettyPrinter)prettyPrinter.copy();
    }

    public static short getTargetLevel() {
        return log == null ? (short)2000 : (short)Log.log.targetLevel;
    }

    public static void setPrettyPrinterClass(String value) {
        prettyPrinterClass = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void resetTargetLevel() {
        if (log != null) {
            Object object = staticLock;
            synchronized (object) {
                short maxTargetLevel = 2000;
                Iterator iter = Log.log.targets.iterator();
                while (iter.hasNext()) {
                    short targetLevel = ((Target)iter.next()).getLevel();
                    if (maxTargetLevel != 2000 && targetLevel >= maxTargetLevel) continue;
                    maxTargetLevel = targetLevel;
                }
                Log.log.targetLevel = maxTargetLevel;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void processTargetFilterAdd(Target target, String filter) {
        if (log != null) {
            Object object = staticLock;
            synchronized (object) {
                ArrayList<String> filters = new ArrayList<String>();
                filters.add(filter);
                Iterator it = Log.log.loggers.keySet().iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    if (!Log.categoryMatchInFilterList(key, filters)) continue;
                    target.addLogger((Logger)Log.log.loggers.get(key));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void processTargetFilterRemove(Target target, String filter) {
        if (log != null) {
            Object object = staticLock;
            synchronized (object) {
                ArrayList<String> filters = new ArrayList<String>();
                filters.add(filter);
                Iterator it = Log.log.loggers.keySet().iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    if (!Log.categoryMatchInFilterList(key, filters)) continue;
                    target.removeLogger((Logger)Log.log.loggers.get(key));
                }
            }
        }
    }

    private static boolean categoryMatchInFilterList(String category, List filters) {
        if (filters == null) {
            return false;
        }
        for (int i2 = 0; i2 < filters.size(); ++i2) {
            String filter = (String)filters.get(i2);
            if (!Log.checkFilterToCategory(filter, category)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkFilterToCategory(String filter, String category) {
        int index = -1;
        index = filter.indexOf("*");
        if (index == 0) {
            return true;
        }
        return index < 0 ? category.equals(filter) : category.length() >= index && category.substring(0, index).equals(filter.substring(0, index));
    }

    private static void checkCategory(String category) {
        if (category == null || category.length() == 0) {
            LocalizedException ex = new LocalizedException();
            ex.setMessage(10014);
            throw ex;
        }
        if (Log.hasIllegalCharacters(category) || category.indexOf("*") != -1) {
            LocalizedException ex = new LocalizedException();
            ex.setMessage(10015, new Object[]{INVALID_CHARS});
            throw ex;
        }
    }

    public static void clear() {
        log = null;
        prettyPrinter = null;
    }

    static {
        prettyPrinterClass = "BasicPrettyPrinter";
        excludedProperties = new HashSet();
        staticLock = new Object();
    }
}

