/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io.amfx;

import flex.messaging.MessageException;
import flex.messaging.io.ArrayCollection;
import flex.messaging.io.PagedRowSet;
import flex.messaging.io.PropertyProxy;
import flex.messaging.io.PropertyProxyRegistry;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.SerializationDescriptor;
import flex.messaging.io.StatusInfoProxy;
import flex.messaging.io.amf.ASObject;
import flex.messaging.io.amf.AbstractAmfOutput;
import flex.messaging.io.amf.Amf3Output;
import flex.messaging.io.amf.TraitsInfo;
import flex.messaging.io.amfx.AmfxTypes;
import flex.messaging.util.Hex;
import flex.messaging.util.Trace;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.RowSet;
import org.w3c.dom.Document;

public class AmfxOutput
extends AbstractAmfOutput
implements AmfxTypes {
    protected IdentityHashMap objectTable = new IdentityHashMap(64);
    protected HashMap traitsTable = new HashMap(10);
    protected HashMap stringTable = new HashMap(64);

    public AmfxOutput(SerializationContext context) {
        super(context);
    }

    public void reset() {
        super.reset();
        this.objectTable.clear();
        this.traitsTable.clear();
        this.stringTable.clear();
    }

    protected Amf3Output createAMF3Output() {
        return new Amf3Output(this.context);
    }

    public void writeObject(Object o2) throws IOException {
        if (o2 == null) {
            this.writeAMFNull();
            return;
        }
        if (!this.context.legacyExternalizable && o2 instanceof Externalizable) {
            this.writeCustomObject(o2);
        } else if (o2 instanceof String || o2 instanceof Character) {
            String s2 = o2.toString();
            this.writeString(s2);
        } else if (o2 instanceof Number) {
            if (o2 instanceof Integer || o2 instanceof Short || o2 instanceof Byte) {
                int i2 = ((Number)o2).intValue();
                this.writeAMFInt(i2);
            } else if (!this.context.legacyBigNumbers && (o2 instanceof BigInteger || o2 instanceof BigDecimal)) {
                this.writeString(((Number)o2).toString());
            } else {
                double d2 = ((Number)o2).doubleValue();
                this.writeAMFDouble(d2);
            }
        } else if (o2 instanceof Boolean) {
            this.writeAMFBoolean((Boolean)o2);
        } else if (o2 instanceof Date) {
            this.writeDate((Date)o2);
        } else if (o2 instanceof Calendar) {
            this.writeDate(((Calendar)o2).getTime());
        } else if (o2 instanceof Document) {
            String xml = this.documentToString(o2);
            int len = xml.length() + 15;
            StringBuffer sb2 = new StringBuffer(len);
            sb2.append("<xml>");
            this.writeEscapedString(sb2, xml);
            sb2.append("</xml>");
            this.writeUTF(sb2);
            if (this.isDebug) {
                this.trace.writeString(xml);
            }
        } else {
            Class<?> cls = o2.getClass();
            if (o2 instanceof Map && this.context.legacyMap && !(o2 instanceof ASObject)) {
                this.writeMapAsECMAArray((Map)o2);
            } else if (o2 instanceof Collection) {
                if (this.context.legacyCollection) {
                    this.writeCollection((Collection)o2, null);
                } else {
                    this.writeArrayCollection((Collection)o2, null);
                }
            } else if (cls.isArray()) {
                this.writeAMFArray(o2, cls.getComponentType());
            } else {
                if (o2 instanceof RowSet) {
                    o2 = new PagedRowSet((RowSet)o2, Integer.MAX_VALUE, false);
                } else if (o2 instanceof Throwable && this.context.legacyThrowable) {
                    o2 = new StatusInfoProxy((Throwable)o2);
                }
                this.writeCustomObject(o2);
            }
        }
    }

    public void writeObjectTraits(TraitsInfo ti) throws IOException {
        String className = ti.getClassName();
        if (className == null || className.length() == 0) {
            this.writeUTF("<object>");
        } else {
            int len = 127;
            StringBuffer sb2 = new StringBuffer(len);
            sb2.append("<").append("object").append(" type=\"");
            sb2.append(className);
            sb2.append("\">");
            this.writeUTF(sb2);
        }
        if (this.isDebug) {
            this.trace.startAMFObject(className, this.objectTable.size() - 1);
        }
        if (ti.length() == 0 && className == null) {
            this.writeUTF("<traits/>");
        } else if (!this.byReference(ti)) {
            if (ti.isExternalizable()) {
                this.writeUTF("<traits externalizable=\"true\" />");
            } else {
                int count = ti.getProperties().size();
                if (count <= 0) {
                    this.writeUTF("<traits/>");
                } else {
                    this.writeUTF("<traits>");
                    for (int i2 = 0; i2 < count; ++i2) {
                        String propName = ti.getProperty(i2);
                        this.writeString(propName, true);
                    }
                    this.writeUTF("</traits>");
                }
            }
        }
    }

    public void writeObjectProperty(String name, Object value) throws IOException {
        if (this.isDebug) {
            this.trace.namedElement(name);
        }
        this.writeObject(value);
    }

    public void writeObjectEnd() throws IOException {
        this.writeUTF("</object>");
        if (this.isDebug) {
            this.trace.endAMFObject();
        }
    }

    public void writeUTF(String s2) throws IOException {
        byte[] bytes = s2.getBytes("UTF-8");
        this.out.write(bytes);
    }

    protected void writeAMFBoolean(boolean b2) throws IOException {
        if (b2) {
            this.writeUTF("<true/>");
        } else {
            this.writeUTF("<false/>");
        }
        if (this.isDebug) {
            this.trace.write(b2);
        }
    }

    protected void writeAMFDouble(double d2) throws IOException {
        int buflen = 40;
        StringBuffer sb2 = new StringBuffer(buflen);
        sb2.append("<double>");
        sb2.append(d2);
        sb2.append("</double>");
        this.writeUTF(sb2);
        if (this.isDebug) {
            this.trace.write(d2);
        }
    }

    protected void writeAMFInt(int i2) throws IOException {
        int buflen = 25;
        StringBuffer sb2 = new StringBuffer(buflen);
        sb2.append("<int>");
        sb2.append(i2);
        sb2.append("</int>");
        this.writeUTF(sb2);
        if (this.isDebug) {
            this.trace.write(i2);
        }
    }

    protected void writeByteArray(byte[] ba2) throws IOException {
        int length = ba2.length * 2;
        int len = 23 + length;
        StringBuffer sb2 = new StringBuffer(len);
        sb2.append("<bytearray>");
        this.writeUTF(sb2);
        Hex.Encoder encoder = new Hex.Encoder(ba2.length * 2);
        encoder.encode(ba2);
        String encoded = encoder.drain();
        this.writeUTF(encoded);
        this.writeUTF("</bytearray>");
        if (this.isDebug) {
            this.trace.startByteArray(this.objectTable.size() - 1, ba2.length);
        }
    }

    protected void writeByteArray(Byte[] ba2) throws IOException {
        int length = ba2.length;
        byte[] bytes = new byte[length];
        for (int i2 = 0; i2 < length; ++i2) {
            Byte b2 = ba2[i2];
            bytes[i2] = b2 == null ? (byte)0 : ba2[i2];
        }
        this.writeByteArray(bytes);
    }

    public void writeUTF(StringBuffer sb2) throws IOException {
        byte[] bytes = sb2.toString().getBytes("UTF-8");
        this.out.write(bytes);
    }

    protected void writeDate(Date d2) throws IOException {
        if (!this.byReference(d2)) {
            int buflen = 30;
            long time = d2.getTime();
            StringBuffer sb2 = new StringBuffer(buflen);
            sb2.append("<date>");
            sb2.append(time);
            sb2.append("</date>");
            this.writeUTF(sb2);
            if (this.isDebug) {
                this.trace.write(d2);
            }
        }
    }

    protected void writeMapAsECMAArray(Map map) throws IOException {
        int len = 20;
        StringBuffer sb2 = new StringBuffer(len);
        sb2.append("<").append("array").append(" ecma=\"true\">");
        this.writeUTF(sb2);
        if (this.isDebug) {
            this.trace.startAMFArray(this.objectTable.size() - 1);
        }
        for (Object key : map.keySet()) {
            if (key == null) continue;
            String propName = key.toString();
            sb2 = new StringBuffer();
            sb2.append("<").append("item").append(" name=\"").append(propName).append("\">");
            this.writeUTF(sb2);
            if (this.isDebug) {
                this.trace.namedElement(propName);
            }
            this.writeObject(map.get(key));
            this.writeUTF("</item>");
        }
        this.writeUTF("</array>");
        if (this.isDebug) {
            this.trace.endAMFArray();
        }
    }

    protected void writeAMFNull() throws IOException {
        this.writeUTF("<null/>");
        if (this.isDebug) {
            this.trace.writeNull();
        }
    }

    protected void writeString(String s2) throws IOException {
        this.writeString(s2, false);
        if (this.isDebug) {
            this.trace.writeString(s2);
        }
    }

    protected void writeAMFArray(Object o2, Class componentType) throws IOException {
        if (componentType.isPrimitive()) {
            this.writePrimitiveArray(o2);
        } else if (componentType.equals(Byte.class)) {
            this.writeByteArray((Byte[])o2);
        } else if (componentType.equals(Character.class)) {
            this.writeCharArrayAsString((Character[])o2);
        } else {
            this.writeObjectArray((Object[])o2, null);
        }
    }

    protected void writeArrayCollection(Collection col, SerializationDescriptor desc) throws IOException {
        if (!this.byReference(col)) {
            ArrayCollection ac2;
            if (col instanceof ArrayCollection) {
                ac2 = (ArrayCollection)col;
            } else {
                ac2 = new ArrayCollection(col);
                if (desc != null) {
                    ac2.setDescriptor(desc);
                }
            }
            PropertyProxy proxy = PropertyProxyRegistry.getProxy(ac2);
            this.writePropertyProxy(proxy, ac2);
        }
    }

    protected void writeCustomObject(Object o2) throws IOException {
        PropertyProxy proxy = null;
        if (o2 instanceof PropertyProxy) {
            proxy = (PropertyProxy)o2;
            if ((o2 = proxy.getDefaultInstance()) == null) {
                this.writeAMFNull();
                return;
            }
            if (o2 instanceof Collection) {
                if (this.context.legacyCollection) {
                    this.writeCollection((Collection)o2, proxy.getDescriptor());
                } else {
                    this.writeArrayCollection((Collection)o2, proxy.getDescriptor());
                }
                return;
            }
            if (o2.getClass().isArray()) {
                this.writeObjectArray((Object[])o2, proxy.getDescriptor());
                return;
            }
            if (this.context.legacyMap && o2 instanceof Map && !(o2 instanceof ASObject)) {
                this.writeMapAsECMAArray((Map)o2);
                return;
            }
        }
        if (!this.byReference(o2)) {
            if (proxy == null) {
                proxy = PropertyProxyRegistry.getProxyAndRegister(o2);
            }
            this.writePropertyProxy(proxy, o2);
        }
    }

    protected void writePropertyProxy(PropertyProxy pp, Object instance) throws IOException {
        Object newInst = pp.getInstanceToSerialize(instance);
        if (newInst != instance) {
            if (newInst == null) {
                throw new MessageException("PropertyProxy.getInstanceToSerialize class: " + pp.getClass() + " returned null for instance class: " + instance.getClass().getName());
            }
            pp = PropertyProxyRegistry.getProxyAndRegister(newInst);
            instance = newInst;
        }
        List propertyNames = null;
        boolean externalizable = pp.isExternalizable(instance);
        if (!externalizable) {
            propertyNames = pp.getPropertyNames(instance);
        }
        TraitsInfo ti = new TraitsInfo(pp.getAlias(instance), pp.isDynamic(), externalizable, propertyNames);
        this.writeObjectTraits(ti);
        if (externalizable) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            Amf3Output objOut = this.createAMF3Output();
            objOut.setOutputStream(bout);
            ((Externalizable)instance).writeExternal(objOut);
            this.writeByteArray(bout.toByteArray());
        } else if (propertyNames != null) {
            for (String propName : propertyNames) {
                Object value = pp.getValue(instance, propName);
                this.writeObjectProperty(propName, value);
            }
        }
        this.writeObjectEnd();
    }

    protected void writeString(String s2, boolean isTrait) throws IOException {
        if (s2.length() == 0) {
            this.writeUTF("<string/>");
        } else if (!this.byReference(s2)) {
            int len = s2.length() + 35;
            StringBuffer sb2 = new StringBuffer(len);
            sb2.append("<string>");
            if (!isTrait) {
                this.writeEscapedString(sb2, s2);
            } else {
                sb2.append(s2);
            }
            sb2.append("</string>");
            this.writeUTF(sb2);
        }
    }

    protected void writeEscapedString(StringBuffer sb2, String s2) {
        StringBuffer temp = new StringBuffer(s2.length());
        char[] chars = s2.toCharArray();
        for (int i2 = 0; i2 < chars.length; ++i2) {
            char c2 = chars[i2];
            if (c2 >= ' ') {
                if (c2 == '&') {
                    temp.append("&amp;");
                    continue;
                }
                if (c2 == '<') {
                    temp.append("&lt;");
                    continue;
                }
                if (c2 > '\ud7ff' && (c2 < '\ue000' || c2 > '\ufffd')) {
                    temp.append("&#x").append(Integer.toHexString(c2)).append(";");
                    continue;
                }
                temp.append(c2);
                continue;
            }
            if (c2 == '\t' || c2 == '\n' || c2 == '\r') {
                temp.append(c2);
                continue;
            }
            temp.append("&#x").append(Integer.toHexString(c2)).append(";");
        }
        sb2.append(temp);
    }

    protected void writeCharArrayAsString(Character[] ca2) throws IOException {
        int length = ca2.length;
        char[] chars = new char[length];
        for (int i2 = 0; i2 < length; ++i2) {
            Character c2 = ca2[i2];
            chars[i2] = c2 == null ? (char)'\u0000' : ca2[i2].charValue();
        }
        this.writeCharArrayAsString(chars);
    }

    protected void writeCharArrayAsString(char[] ca2) throws IOException {
        String str = new String(ca2);
        this.writeString(str);
    }

    protected void writeCollection(Collection c2, SerializationDescriptor descriptor) throws IOException {
        if (!this.byReference(c2)) {
            this.writeObjectArrayDirectly(c2.toArray(), descriptor);
        }
    }

    protected void writeObjectArray(Object[] values, SerializationDescriptor descriptor) throws IOException {
        if (!this.byReference(values)) {
            this.writeObjectArrayDirectly(values, descriptor);
        }
    }

    protected void writeObjectArrayDirectly(Object[] values, SerializationDescriptor descriptor) throws IOException {
        int len = 25;
        StringBuffer sb2 = new StringBuffer(len);
        sb2.append("<").append("array").append(" length=\"");
        sb2.append(values.length);
        sb2.append("\">");
        this.writeUTF(sb2);
        if (this.isDebug) {
            this.trace.startAMFArray(this.objectTable.size() - 1);
        }
        for (int i2 = 0; i2 < values.length; ++i2) {
            if (this.isDebug) {
                this.trace.arrayElement(i2);
            }
            this.writeObject(values[i2]);
        }
        this.writeUTF("</array>");
        if (this.isDebug) {
            this.trace.endAMFArray();
        }
    }

    protected void writePrimitiveArray(Object obj) throws IOException {
        Class<?> aType = obj.getClass().getComponentType();
        if (aType.equals(Character.TYPE)) {
            char[] c2 = (char[])obj;
            this.writeCharArrayAsString(c2);
        } else if (aType.equals(Byte.TYPE)) {
            this.writeByteArray((byte[])obj);
        } else if (!this.byReference(obj)) {
            int length = Array.getLength(obj);
            int buflen = 25;
            StringBuffer sb2 = new StringBuffer(buflen);
            sb2.append("<").append("array").append(" length=\"");
            sb2.append(length);
            sb2.append("\">");
            this.writeUTF(sb2);
            if (this.isDebug) {
                this.trace.startAMFArray(this.objectTable.size() - 1);
            }
            if (aType.equals(Boolean.TYPE)) {
                boolean[] b2 = (boolean[])obj;
                for (int i2 = 0; i2 < b2.length; ++i2) {
                    if (this.isDebug) {
                        this.trace.arrayElement(i2);
                    }
                    this.writeAMFBoolean(b2[i2]);
                }
            } else if (aType.equals(Integer.TYPE) || aType.equals(Short.TYPE)) {
                for (int i3 = 0; i3 < length; ++i3) {
                    if (this.isDebug) {
                        this.trace.arrayElement(i3);
                    }
                    int v2 = Array.getInt(obj, i3);
                    this.writeAMFInt(v2);
                }
            } else {
                for (int i4 = 0; i4 < length; ++i4) {
                    if (this.isDebug) {
                        this.trace.arrayElement(i4);
                    }
                    double v3 = Array.getDouble(obj, i4);
                    this.writeAMFDouble(v3);
                }
            }
            this.writeUTF("</array>");
            if (this.isDebug) {
                this.trace.endAMFArray();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected boolean byReference(Object o) throws IOException {
        ref = this.objectTable.get(o);
        if (ref != null) {
            try {
                refNum = (Integer)ref;
                len = 20;
                sb = new StringBuffer(len);
                sb.append("<").append("ref").append(" id=\"");
                sb.append(refNum);
                sb.append("\"/>");
                this.writeUTF(sb);
                if (!this.isDebug) ** GOTO lbl21
                this.trace.writeRef(refNum);
            }
            catch (ClassCastException e) {
                throw new IOException("Object reference is not an Integer");
            }
        } else {
            this.objectTable.put(o, new Integer(this.objectTable.size()));
        }
lbl21:
        // 3 sources

        return ref != null;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean byReference(String s) throws IOException {
        ref = this.stringTable.get(s);
        if (ref != null) {
            try {
                refNum = (Integer)ref;
                len = 20;
                sb = new StringBuffer(len);
                sb.append("<").append("string").append(" id=\"");
                sb.append(refNum);
                sb.append("\"/>");
                this.writeUTF(sb);
                if (!Trace.amf || !this.isDebug) ** GOTO lbl21
                this.trace.writeStringRef(refNum);
            }
            catch (ClassCastException e) {
                throw new IOException("String reference is not an Integer");
            }
        } else {
            this.stringTable.put(s, new Integer(this.stringTable.size()));
        }
lbl21:
        // 3 sources

        return ref != null;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean byReference(TraitsInfo ti) throws IOException {
        if (ti.length() == 0 && ti.getClassName() == null) {
            return false;
        }
        ref = this.traitsTable.get(ti);
        if (ref != null) {
            try {
                refNum = (Integer)ref;
                len = 20;
                sb = new StringBuffer(len);
                sb.append("<").append("traits").append(" id=\"");
                sb.append(refNum);
                sb.append("\"/>");
                this.writeUTF(sb);
                if (!Trace.amf || !this.isDebug) ** GOTO lbl23
                this.trace.writeTraitsInfoRef(refNum);
            }
            catch (ClassCastException e) {
                throw new IOException("Traits reference is not an Integer");
            }
        } else {
            this.traitsTable.put(ti, new Integer(this.traitsTable.size()));
        }
lbl23:
        // 3 sources

        return ref != null;
    }
}

