/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io.amf;

import flex.messaging.MessageException;
import flex.messaging.io.ArrayCollection;
import flex.messaging.io.PagedRowSet;
import flex.messaging.io.PropertyProxy;
import flex.messaging.io.PropertyProxyRegistry;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.SerializationDescriptor;
import flex.messaging.io.StatusInfoProxy;
import flex.messaging.io.amf.ASObject;
import flex.messaging.io.amf.AbstractAmfOutput;
import flex.messaging.io.amf.Amf3Types;
import flex.messaging.io.amf.TraitsInfo;
import flex.messaging.util.Trace;
import java.io.Externalizable;
import java.io.IOException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sql.RowSet;
import org.w3c.dom.Document;

public class Amf3Output
extends AbstractAmfOutput
implements Amf3Types {
    protected IdentityHashMap objectTable = new IdentityHashMap(64);
    protected HashMap traitsTable = new HashMap(10);
    protected HashMap stringTable = new HashMap(64);

    public Amf3Output(SerializationContext context) {
        super(context);
        context.supportDatesByReference = true;
    }

    public void reset() {
        super.reset();
        this.objectTable.clear();
        this.traitsTable.clear();
        this.stringTable.clear();
    }

    public void writeObject(Object o2) throws IOException {
        if (o2 == null) {
            this.writeAMFNull();
            return;
        }
        if (!this.context.legacyExternalizable && o2 instanceof Externalizable) {
            this.writeCustomObject(o2);
        } else if (o2 instanceof String || o2 instanceof Character) {
            String s2 = o2.toString();
            this.writeAMFString(s2);
        } else if (o2 instanceof Number) {
            if (o2 instanceof Integer || o2 instanceof Short || o2 instanceof Byte) {
                int i2 = ((Number)o2).intValue();
                this.writeAMFInt(i2);
            } else if (!this.context.legacyBigNumbers && (o2 instanceof BigInteger || o2 instanceof BigDecimal)) {
                this.writeAMFString(((Number)o2).toString());
            } else {
                double d2 = ((Number)o2).doubleValue();
                this.writeAMFDouble(d2);
            }
        } else if (o2 instanceof Boolean) {
            this.writeAMFBoolean((Boolean)o2);
        } else if (o2 instanceof Date) {
            this.writeAMFDate((Date)o2);
        } else if (o2 instanceof Calendar) {
            this.writeAMFDate(((Calendar)o2).getTime());
        } else if (o2 instanceof Document) {
            if (this.context.legacyXMLDocument) {
                this.out.write(7);
            } else {
                this.out.write(11);
            }
            if (!this.byReference(o2)) {
                String xml = this.documentToString(o2);
                if (this.isDebug) {
                    this.trace.write(xml);
                }
                this.writeAMFUTF(xml);
            }
        } else {
            Class<?> cls = o2.getClass();
            if (this.context.legacyMap && o2 instanceof Map && !(o2 instanceof ASObject)) {
                this.writeMapAsECMAArray((Map)o2);
            } else if (o2 instanceof Collection) {
                if (this.context.legacyCollection) {
                    this.writeCollection((Collection)o2, null);
                } else {
                    this.writeArrayCollection((Collection)o2, null);
                }
            } else if (cls.isArray()) {
                this.writeAMFArray(o2, cls.getComponentType());
            } else {
                if (o2 instanceof RowSet) {
                    o2 = new PagedRowSet((RowSet)o2, Integer.MAX_VALUE, false);
                } else if (this.context.legacyThrowable && o2 instanceof Throwable) {
                    o2 = new StatusInfoProxy((Throwable)o2);
                }
                this.writeCustomObject(o2);
            }
        }
    }

    public void writeObjectTraits(TraitsInfo ti) throws IOException {
        String className = ti.getClassName();
        if (this.isDebug) {
            if (ti.isExternalizable()) {
                this.trace.startExternalizableObject(className, this.objectTable.size() - 1);
            } else {
                this.trace.startAMFObject(className, this.objectTable.size() - 1);
            }
        }
        if (!this.byReference(ti)) {
            int count = 0;
            List propertyNames = null;
            boolean externalizable = ti.isExternalizable();
            if (!externalizable && (propertyNames = ti.getProperties()) != null) {
                count = propertyNames.size();
            }
            boolean dynamic = ti.isDynamic();
            this.writeUInt29(3 | (externalizable ? 4 : 0) | (dynamic ? 8 : 0) | count << 4);
            this.writeStringWithoutType(className);
            if (!externalizable && propertyNames != null) {
                for (int i2 = 0; i2 < count; ++i2) {
                    String propName = ti.getProperty(i2);
                    this.writeStringWithoutType(propName);
                }
            }
        }
    }

    public void writeObjectProperty(String name, Object value) throws IOException {
        if (this.isDebug) {
            this.trace.namedElement(name);
        }
        this.writeObject(value);
    }

    public void writeObjectEnd() throws IOException {
        if (this.isDebug) {
            this.trace.endAMFObject();
        }
    }

    protected void writeAMFBoolean(boolean b2) throws IOException {
        if (this.isDebug) {
            this.trace.write(b2);
        }
        if (b2) {
            this.out.write(3);
        } else {
            this.out.write(2);
        }
    }

    protected void writeAMFDate(Date d2) throws IOException {
        this.out.write(8);
        if (!this.byReference(d2)) {
            if (this.isDebug) {
                this.trace.write(d2);
            }
            this.writeUInt29(1);
            this.out.writeDouble(d2.getTime());
        }
    }

    protected void writeAMFDouble(double d2) throws IOException {
        if (this.isDebug) {
            this.trace.write(d2);
        }
        this.out.write(5);
        this.out.writeDouble(d2);
    }

    protected void writeAMFInt(int i2) throws IOException {
        if (i2 >= -268435456 && i2 <= 0xFFFFFFF) {
            if (this.isDebug) {
                this.trace.write(i2);
            }
            this.out.write(4);
            this.writeUInt29(i2 &= 0x1FFFFFFF);
        } else {
            this.writeAMFDouble(i2);
        }
    }

    protected void writeMapAsECMAArray(Map map) throws IOException {
        this.out.write(9);
        if (!this.byReference(map)) {
            if (this.isDebug) {
                this.trace.startECMAArray(this.objectTable.size() - 1);
            }
            this.writeUInt29(1);
            for (Object key : map.keySet()) {
                if (key == null) continue;
                String propName = key.toString();
                this.writeStringWithoutType(propName);
                if (this.isDebug) {
                    this.trace.namedElement(propName);
                }
                this.writeObject(map.get(key));
            }
            this.writeStringWithoutType("");
            if (this.isDebug) {
                this.trace.endAMFArray();
            }
        }
    }

    protected void writeAMFNull() throws IOException {
        if (this.isDebug) {
            this.trace.writeNull();
        }
        this.out.write(1);
    }

    protected void writeAMFString(String s2) throws IOException {
        this.out.write(6);
        this.writeStringWithoutType(s2);
        if (this.isDebug) {
            this.trace.writeString(s2);
        }
    }

    protected void writeStringWithoutType(String s2) throws IOException {
        if (s2.length() == 0) {
            this.writeUInt29(1);
            return;
        }
        if (!this.byReference(s2)) {
            this.writeAMFUTF(s2);
            return;
        }
    }

    protected void writeAMFArray(Object o2, Class componentType) throws IOException {
        if (componentType.isPrimitive()) {
            this.writePrimitiveArray(o2);
        } else if (componentType.equals(Byte.class)) {
            this.writeAMFByteArray((Byte[])o2);
        } else if (componentType.equals(Character.class)) {
            this.writeCharArrayAsString((Character[])o2);
        } else {
            this.writeObjectArray((Object[])o2, null);
        }
    }

    protected void writeArrayCollection(Collection col, SerializationDescriptor desc) throws IOException {
        this.out.write(10);
        if (!this.byReference(col)) {
            ArrayCollection ac2;
            if (col instanceof ArrayCollection) {
                ac2 = (ArrayCollection)col;
            } else {
                ac2 = new ArrayCollection(col);
                if (desc != null) {
                    ac2.setDescriptor(desc);
                }
            }
            PropertyProxy proxy = PropertyProxyRegistry.getProxy(ac2);
            this.writePropertyProxy(proxy, ac2);
        }
    }

    protected void writeCustomObject(Object o2) throws IOException {
        PropertyProxy proxy = null;
        if (o2 instanceof PropertyProxy) {
            proxy = (PropertyProxy)o2;
            if ((o2 = proxy.getDefaultInstance()) == null) {
                this.writeAMFNull();
                return;
            }
            if (o2 instanceof Collection) {
                if (this.context.legacyCollection) {
                    this.writeCollection((Collection)o2, proxy.getDescriptor());
                } else {
                    this.writeArrayCollection((Collection)o2, proxy.getDescriptor());
                }
                return;
            }
            if (o2.getClass().isArray()) {
                this.writeObjectArray((Object[])o2, proxy.getDescriptor());
                return;
            }
            if (this.context.legacyMap && o2 instanceof Map && !(o2 instanceof ASObject)) {
                this.writeMapAsECMAArray((Map)o2);
                return;
            }
        }
        this.out.write(10);
        if (!this.byReference(o2)) {
            if (proxy == null) {
                proxy = PropertyProxyRegistry.getProxyAndRegister(o2);
            }
            this.writePropertyProxy(proxy, o2);
        }
    }

    protected void writePropertyProxy(PropertyProxy proxy, Object instance) throws IOException {
        Object newInst = proxy.getInstanceToSerialize(instance);
        if (newInst != instance) {
            if (newInst == null) {
                throw new MessageException("PropertyProxy.getInstanceToSerialize class: " + proxy.getClass() + " returned null for instance class: " + instance.getClass().getName());
            }
            proxy = PropertyProxyRegistry.getProxyAndRegister(newInst);
            instance = newInst;
        }
        List propertyNames = null;
        boolean externalizable = proxy.isExternalizable(instance);
        if (!externalizable) {
            propertyNames = proxy.getPropertyNames(instance);
        }
        TraitsInfo ti = new TraitsInfo(proxy.getAlias(instance), proxy.isDynamic(), externalizable, propertyNames);
        this.writeObjectTraits(ti);
        if (externalizable) {
            ((Externalizable)instance).writeExternal(this);
        } else if (propertyNames != null) {
            for (String propName : propertyNames) {
                Object value = null;
                value = proxy.getValue(instance, propName);
                this.writeObjectProperty(propName, value);
            }
        }
        this.writeObjectEnd();
    }

    protected void writePrimitiveArray(Object obj) throws IOException {
        block17: {
            Class<?> aType;
            block18: {
                block16: {
                    aType = obj.getClass().getComponentType();
                    if (!aType.equals(Character.TYPE)) break block16;
                    char[] c2 = (char[])obj;
                    this.writeCharArrayAsString(c2);
                    break block17;
                }
                if (!aType.equals(Byte.TYPE)) break block18;
                this.writeAMFByteArray((byte[])obj);
                break block17;
            }
            this.out.write(9);
            if (this.byReference(obj)) break block17;
            if (aType.equals(Boolean.TYPE)) {
                boolean[] b2 = (boolean[])obj;
                this.writeUInt29(b2.length << 1 | 1);
                this.writeStringWithoutType("");
                if (this.isDebug) {
                    this.trace.startAMFArray(this.objectTable.size() - 1);
                    for (int i2 = 0; i2 < b2.length; ++i2) {
                        this.trace.arrayElement(i2);
                        this.writeAMFBoolean(b2[i2]);
                    }
                    this.trace.endAMFArray();
                } else {
                    for (int i3 = 0; i3 < b2.length; ++i3) {
                        this.writeAMFBoolean(b2[i3]);
                    }
                }
            } else if (aType.equals(Integer.TYPE) || aType.equals(Short.TYPE)) {
                int length = Array.getLength(obj);
                this.writeUInt29(length << 1 | 1);
                this.writeStringWithoutType("");
                if (this.isDebug) {
                    this.trace.startAMFArray(this.objectTable.size() - 1);
                    for (int i4 = 0; i4 < length; ++i4) {
                        this.trace.arrayElement(i4);
                        int v2 = Array.getInt(obj, i4);
                        this.writeAMFInt(v2);
                    }
                    this.trace.endAMFArray();
                } else {
                    for (int i5 = 0; i5 < length; ++i5) {
                        int v3 = Array.getInt(obj, i5);
                        this.writeAMFInt(v3);
                    }
                }
            } else {
                int length = Array.getLength(obj);
                this.writeUInt29(length << 1 | 1);
                this.writeStringWithoutType("");
                if (this.isDebug) {
                    this.trace.startAMFArray(this.objectTable.size() - 1);
                    for (int i6 = 0; i6 < length; ++i6) {
                        this.trace.arrayElement(i6);
                        double v4 = Array.getDouble(obj, i6);
                        this.writeAMFDouble(v4);
                    }
                    this.trace.endAMFArray();
                } else {
                    for (int i7 = 0; i7 < length; ++i7) {
                        double v5 = Array.getDouble(obj, i7);
                        this.writeAMFDouble(v5);
                    }
                }
            }
        }
    }

    protected void writeAMFByteArray(byte[] ba2) throws IOException {
        this.out.write(12);
        if (!this.byReference(ba2)) {
            int length = ba2.length;
            this.writeUInt29(length << 1 | 1);
            if (this.isDebug) {
                this.trace.startByteArray(this.objectTable.size() - 1, length);
            }
            this.out.write(ba2, 0, length);
        }
    }

    protected void writeAMFByteArray(Byte[] ba2) throws IOException {
        this.out.write(12);
        if (!this.byReference(ba2)) {
            int length = ba2.length;
            this.writeUInt29(length << 1 | 1);
            if (this.isDebug) {
                this.trace.startByteArray(this.objectTable.size() - 1, length);
            }
            for (int i2 = 0; i2 < ba2.length; ++i2) {
                Byte b2 = ba2[i2];
                if (b2 == null) {
                    this.out.write(0);
                    continue;
                }
                this.out.write(b2.byteValue());
            }
        }
    }

    protected void writeCharArrayAsString(Character[] ca2) throws IOException {
        int length = ca2.length;
        char[] chars = new char[length];
        for (int i2 = 0; i2 < length; ++i2) {
            Character c2 = ca2[i2];
            chars[i2] = c2 == null ? (char)'\u0000' : ca2[i2].charValue();
        }
        this.writeCharArrayAsString(chars);
    }

    protected void writeCharArrayAsString(char[] ca2) throws IOException {
        String str = new String(ca2);
        this.writeAMFString(str);
    }

    protected void writeObjectArray(Object[] values, SerializationDescriptor descriptor) throws IOException {
        this.out.write(9);
        if (!this.byReference(values)) {
            if (this.isDebug) {
                this.trace.startAMFArray(this.objectTable.size() - 1);
            }
            this.writeUInt29(values.length << 1 | 1);
            this.writeStringWithoutType("");
            for (int i2 = 0; i2 < values.length; ++i2) {
                Object item;
                if (this.isDebug) {
                    this.trace.arrayElement(i2);
                }
                if (!((item = values[i2]) == null || descriptor == null || item instanceof String || item instanceof Number || item instanceof Boolean || item instanceof Character)) {
                    PropertyProxy proxy = PropertyProxyRegistry.getProxy(item);
                    proxy = (PropertyProxy)proxy.clone();
                    proxy.setDescriptor(descriptor);
                    proxy.setDefaultInstance(item);
                    item = proxy;
                }
                this.writeObject(item);
            }
            if (this.isDebug) {
                this.trace.endAMFArray();
            }
        }
    }

    protected void writeCollection(Collection c2, SerializationDescriptor descriptor) throws IOException {
        this.out.write(9);
        if (!this.byReference(c2)) {
            if (this.isDebug) {
                this.trace.startAMFArray(this.objectTable.size() - 1);
            }
            this.writeUInt29(c2.size() << 1 | 1);
            this.writeStringWithoutType("");
            Iterator it = c2.iterator();
            int i2 = 0;
            while (it.hasNext()) {
                Object item;
                if (this.isDebug) {
                    this.trace.arrayElement(i2);
                }
                if (!((item = it.next()) == null || descriptor == null || item instanceof String || item instanceof Number || item instanceof Boolean || item instanceof Character)) {
                    PropertyProxy proxy = PropertyProxyRegistry.getProxy(item);
                    proxy = (PropertyProxy)proxy.clone();
                    proxy.setDescriptor(descriptor);
                    proxy.setDefaultInstance(item);
                    item = proxy;
                }
                this.writeObject(item);
                ++i2;
            }
            if (this.isDebug) {
                this.trace.endAMFArray();
            }
        }
    }

    protected void writeUInt29(int ref) throws IOException {
        if (ref < 128) {
            this.out.writeByte(ref);
        } else if (ref < 16384) {
            this.out.writeByte(ref >> 7 & 0x7F | 0x80);
            this.out.writeByte(ref & 0x7F);
        } else if (ref < 0x200000) {
            this.out.writeByte(ref >> 14 & 0x7F | 0x80);
            this.out.writeByte(ref >> 7 & 0x7F | 0x80);
            this.out.writeByte(ref & 0x7F);
        } else if (ref < 0x40000000) {
            this.out.writeByte(ref >> 22 & 0x7F | 0x80);
            this.out.writeByte(ref >> 15 & 0x7F | 0x80);
            this.out.writeByte(ref >> 8 & 0x7F | 0x80);
            this.out.writeByte(ref & 0xFF);
        } else {
            throw new MessageException("Integer out of range: " + ref);
        }
    }

    public void writeAMFUTF(String s2) throws IOException {
        char c2;
        int strlen = s2.length();
        int utflen = 0;
        int count = 0;
        char[] charr = this.getTempCharArray(strlen);
        s2.getChars(0, strlen, charr, 0);
        for (int i2 = 0; i2 < strlen; ++i2) {
            c2 = charr[i2];
            if (c2 <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c2 > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        this.writeUInt29(utflen << 1 | 1);
        byte[] bytearr = this.getTempByteArray(utflen);
        for (int i3 = 0; i3 < strlen; ++i3) {
            c2 = charr[i3];
            if (c2 <= '\u007f') {
                bytearr[count++] = (byte)c2;
                continue;
            }
            if (c2 > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c2 >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c2 >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c2 >> 0 & 0x3F);
                continue;
            }
            bytearr[count++] = (byte)(0xC0 | c2 >> 6 & 0x1F);
            bytearr[count++] = (byte)(0x80 | c2 >> 0 & 0x3F);
        }
        this.out.write(bytearr, 0, utflen);
    }

    protected boolean byReference(Object o2) throws IOException {
        Object ref = this.objectTable.get(o2);
        if (ref != null) {
            try {
                int refNum = (Integer)ref;
                if (this.isDebug) {
                    this.trace.writeRef(refNum);
                }
                this.writeUInt29(refNum << 1);
            }
            catch (ClassCastException e2) {
                throw new IOException("Object reference is not an Integer");
            }
        } else {
            this.objectTable.put(o2, new Integer(this.objectTable.size()));
        }
        return ref != null;
    }

    public void addObjectReference(Object o2) throws IOException {
        this.byReference(o2);
    }

    /*
     * Unable to fully structure code
     */
    protected boolean byReference(String s) throws IOException {
        ref = this.stringTable.get(s);
        if (ref != null) {
            try {
                refNum = (Integer)ref;
                this.writeUInt29(refNum << 1);
                if (!Trace.amf || !this.isDebug) ** GOTO lbl13
                this.trace.writeStringRef(refNum);
            }
            catch (ClassCastException e) {
                throw new IOException("String reference is not an Integer");
            }
        } else {
            this.stringTable.put(s, new Integer(this.stringTable.size()));
        }
lbl13:
        // 3 sources

        return ref != null;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean byReference(TraitsInfo ti) throws IOException {
        ref = this.traitsTable.get(ti);
        if (ref != null) {
            try {
                refNum = (Integer)ref;
                this.writeUInt29(refNum << 2 | 1);
                if (!Trace.amf || !this.isDebug) ** GOTO lbl13
                this.trace.writeTraitsInfoRef(refNum);
            }
            catch (ClassCastException e) {
                throw new IOException("TraitsInfo reference is not an Integer");
            }
        } else {
            this.traitsTable.put(ti, new Integer(this.traitsTable.size()));
        }
lbl13:
        // 3 sources

        return ref != null;
    }
}

