/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.endpoints.amf;

import flex.messaging.FlexContext;
import flex.messaging.endpoints.amf.AMFFilter;
import flex.messaging.io.amf.ActionContext;
import flex.messaging.io.amf.MessageHeader;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SessionFilter
extends AMFFilter {
    public void invoke(ActionContext context) throws IOException {
        this.next.invoke(context);
        try {
            HttpServletRequest request = FlexContext.getHttpRequest();
            HttpServletResponse response = FlexContext.getHttpResponse();
            StringBuffer reqURL = request.getRequestURL();
            if (reqURL != null) {
                if (request.getQueryString() != null) {
                    reqURL.append("?").append(request.getQueryString());
                }
                String oldFullURL = reqURL.toString().trim();
                String encFullURL = response.encodeURL(oldFullURL).trim();
                String sessionSuffix = null;
                int pos = encFullURL.toLowerCase().indexOf(";jsessionid");
                if (pos > 0) {
                    StringBuffer sb2 = new StringBuffer();
                    sb2.append(encFullURL.substring(pos));
                    sessionSuffix = sb2.toString();
                }
                if (sessionSuffix != null && oldFullURL.indexOf(sessionSuffix) < 0) {
                    context.getResponseMessage().addHeader(new MessageHeader("AppendToGatewayUrl", true, sessionSuffix));
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

