/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.endpoints.amf;

import flex.messaging.FlexContext;
import flex.messaging.MessageException;
import flex.messaging.endpoints.amf.AMFFilter;
import flex.messaging.io.MessageSerializer;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.SerializationException;
import flex.messaging.io.amf.ASObject;
import flex.messaging.io.amf.ActionContext;
import flex.messaging.io.amf.ActionMessage;
import flex.messaging.io.amf.AmfTrace;
import flex.messaging.io.amf.MessageBody;
import flex.messaging.log.Log;
import flex.messaging.log.Logger;
import flex.messaging.messages.ErrorMessage;
import flex.messaging.messages.Message;
import flex.messaging.messages.MessagePerformanceInfo;
import flex.messaging.util.ExceptionUtil;
import flex.messaging.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.List;

public class SerializationFilter
extends AMFFilter {
    private static final int UNHANDLED_ERROR = 10306;
    private static final int REQUEST_ERROR = 10307;
    private static final int RESPONSE_ERROR = 10308;
    private boolean isDebug = Log.isDebug();
    private Logger logger;

    public SerializationFilter(String logCategory) {
        if (logCategory == null) {
            logCategory = "Endpoint.General";
        }
        this.logger = Log.getLogger(logCategory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void invoke(ActionContext context) throws IOException {
        block48: {
            block44: {
                success = false;
                debugTrace = this.isDebug != false ? new AmfTrace() : null;
                context.setResponseMessage(new ActionMessage());
                sc = SerializationContext.getSerializationContext();
                try {
                    try {
                        deserializer = sc.newMessageDeserializer();
                        in = FlexContext.getHttpRequest().getInputStream();
                        deserializer.initialize(sc, (InputStream)in, debugTrace);
                        reqLen = FlexContext.getHttpRequest().getContentLength();
                        context.setDeserializedBytes(reqLen);
                        if (context.isMPIenabled()) {
                            mpi = new MessagePerformanceInfo();
                            mpi.recordMessageSizes = context.isRecordMessageSizes();
                            mpi.recordMessageTimes = context.isRecordMessageTimes();
                            if (context.isRecordMessageTimes()) {
                                mpi.receiveTime = System.currentTimeMillis();
                            }
                            if (context.isRecordMessageSizes()) {
                                mpi.messageSize = reqLen;
                            }
                            context.setMPII(mpi);
                        }
                        m = new ActionMessage();
                        context.setRequestMessage(m);
                        deserializer.readMessage(m, context);
                        success = true;
                    }
                    catch (EOFException eof) {
                        context.setStatus(2);
                        var10_14 = null;
                        respMsg = context.getResponseMessage();
                        respMsg.setVersion(context.getVersion());
                        if (this.isDebug) {
                            this.logger.debug(debugTrace.toString());
                        }
                        break block44;
                    }
                    catch (IOException exc) {
                        if (this.isDebug == false) throw exc;
                        this.logger.debug("IOException reading message - client closed socket before sending the message?");
                        throw exc;
                    }
                    catch (Throwable t) {
                        this.deserializationError(context, t);
                        var10_15 = null;
                        respMsg = context.getResponseMessage();
                        respMsg.setVersion(context.getVersion());
                        if (this.isDebug) {
                            this.logger.debug(debugTrace.toString());
                        }
                        break block44;
                    }
                    var10_13 = null;
                    respMsg = context.getResponseMessage();
                    respMsg.setVersion(context.getVersion());
                    if (this.isDebug) {
                        this.logger.debug(debugTrace.toString());
                    }
                }
                catch (Throwable var9_21) {
                    var10_16 = null;
                    respMsg = context.getResponseMessage();
                    respMsg.setVersion(context.getVersion());
                    if (this.isDebug == false) throw var9_21;
                    this.logger.debug(debugTrace.toString());
                    throw var9_21;
                }
            }
            try {
                try {
                    if (success) {
                        this.next.invoke(context);
                    }
                }
                catch (Throwable t) {
                    this.unhandledError(context, t);
                    var13_23 = null;
                    if (context.getStatus() == 2) return;
                    outBuffer = new ByteArrayOutputStream();
                    respMesg = context.getResponseMessage();
                    if (this.isDebug) {
                        debugTrace = new AmfTrace();
                    }
                    try {
                        try {
                            block45: {
                                serializationOverhead = 0L;
                                if (context.isRecordMessageTimes()) {
                                    context.getMPIO().sendTime = System.currentTimeMillis();
                                    if (context.isRecordMessageSizes()) {
                                        serializationOverhead = System.currentTimeMillis();
                                    }
                                }
                                serializer = sc.newMessageSerializer();
                                serializer.initialize(sc, outBuffer, debugTrace);
                                serializer.writeMessage(respMesg);
                                context.setSerializedBytes(outBuffer.size());
                                if (context.isRecordMessageSizes()) {
                                    try {
                                        context.getMPIO().messageSize = outBuffer.size();
                                        if (context.isRecordMessageTimes()) {
                                            serializationOverhead = System.currentTimeMillis() - serializationOverhead;
                                            context.getMPIO().addToOverhead(serializationOverhead);
                                            context.getMPIO().sendTime = System.currentTimeMillis();
                                        }
                                        outBuffer = new ByteArrayOutputStream();
                                        respMesg = context.getResponseMessage();
                                        serializer = sc.newMessageSerializer();
                                        serializer.initialize(sc, outBuffer, debugTrace);
                                        serializer.writeMessage(respMesg);
                                    }
                                    catch (Exception e) {
                                        if (!this.isDebug) break block45;
                                        this.logger.debug("MPI set up error: " + e.toString());
                                    }
                                }
                            }
                            context.setResponseOutput(outBuffer);
                        }
                        catch (Exception e) {
                            this.serializationError(context, e);
                            var21_47 = null;
                            if (this.isDebug == false) return;
                            this.logger.debug(debugTrace.toString());
                            return;
                        }
                        var21_46 = null;
                        if (this.isDebug == false) return;
                        this.logger.debug(debugTrace.toString());
                        return;
                    }
                    catch (Throwable var20_53) {
                        var21_48 = null;
                        if (this.isDebug == false) throw var20_53;
                        this.logger.debug(debugTrace.toString());
                        throw var20_53;
                    }
                }
                var13_22 = null;
                if (context.getStatus() == 2) return;
                outBuffer = new ByteArrayOutputStream();
                respMesg = context.getResponseMessage();
                if (this.isDebug) {
                    debugTrace = new AmfTrace();
                }
            }
            catch (Throwable var12_55) {
                block47: {
                    var13_24 = null;
                    if (context.getStatus() == 2) throw var12_55;
                    outBuffer = new ByteArrayOutputStream();
                    respMesg = context.getResponseMessage();
                    if (this.isDebug) {
                        debugTrace = new AmfTrace();
                    }
                    ** try [egrp 4[TRYBLOCK] [13 : 360->595)] { 
lbl141:
                    // 1 sources

                    ** try [egrp 5[TRYBLOCK] [12 : 360->574)] { 
lbl142:
                    // 1 sources

                    serializationOverhead = 0L;
                    if (context.isRecordMessageTimes()) {
                        context.getMPIO().sendTime = System.currentTimeMillis();
                        if (context.isRecordMessageSizes()) {
                            serializationOverhead = System.currentTimeMillis();
                        }
                    }
                    serializer = sc.newMessageSerializer();
                    serializer.initialize(sc, outBuffer, debugTrace);
                    serializer.writeMessage(respMesg);
                    context.setSerializedBytes(outBuffer.size());
                    if (!context.isRecordMessageSizes()) break block47;
                    try {}
                    catch (Exception e) {
                        if (this.isDebug) {
                            this.logger.debug("MPI set up error: " + e.toString());
                        }
                        break block47;
                    }
                    context.getMPIO().messageSize = outBuffer.size();
                    if (context.isRecordMessageTimes()) {
                        serializationOverhead = System.currentTimeMillis() - serializationOverhead;
                        context.getMPIO().addToOverhead(serializationOverhead);
                        context.getMPIO().sendTime = System.currentTimeMillis();
                    }
                    outBuffer = new ByteArrayOutputStream();
                    respMesg = context.getResponseMessage();
                    serializer = sc.newMessageSerializer();
                    serializer.initialize(sc, outBuffer, debugTrace);
                    serializer.writeMessage(respMesg);
                    break block47;
lbl169:
                    // 1 sources

                    catch (Exception e) {
                        this.serializationError(context, e);
                        var21_50 = null;
                        if (this.isDebug == false) throw var12_55;
                        this.logger.debug(debugTrace.toString());
                        throw var12_55;
                    }
                }
                context.setResponseOutput(outBuffer);
                var21_49 = null;
                if (this.isDebug == false) throw var12_55;
                this.logger.debug(debugTrace.toString());
                throw var12_55;
lbl182:
                // 1 sources

                catch (Throwable var20_54) {
                    var21_51 = null;
                    if (this.isDebug == false) throw var20_54;
                    this.logger.debug(debugTrace.toString());
                    throw var20_54;
                }
            }
            ** try [egrp 4[TRYBLOCK] [13 : 360->595)] { 
lbl189:
            // 1 sources

            ** try [egrp 5[TRYBLOCK] [12 : 360->574)] { 
lbl190:
            // 1 sources

            serializationOverhead = 0L;
            if (context.isRecordMessageTimes()) {
                context.getMPIO().sendTime = System.currentTimeMillis();
                if (context.isRecordMessageSizes()) {
                    serializationOverhead = System.currentTimeMillis();
                }
            }
            serializer = sc.newMessageSerializer();
            serializer.initialize(sc, outBuffer, debugTrace);
            serializer.writeMessage(respMesg);
            context.setSerializedBytes(outBuffer.size());
            if (!context.isRecordMessageSizes()) break block48;
            try {}
            catch (Exception e) {
                if (this.isDebug) {
                    this.logger.debug("MPI set up error: " + e.toString());
                }
                break block48;
            }
            context.getMPIO().messageSize = outBuffer.size();
            if (context.isRecordMessageTimes()) {
                serializationOverhead = System.currentTimeMillis() - serializationOverhead;
                context.getMPIO().addToOverhead(serializationOverhead);
                context.getMPIO().sendTime = System.currentTimeMillis();
            }
            outBuffer = new ByteArrayOutputStream();
            respMesg = context.getResponseMessage();
            serializer = sc.newMessageSerializer();
            serializer.initialize(sc, outBuffer, debugTrace);
            serializer.writeMessage(respMesg);
            break block48;
lbl217:
            // 1 sources

            catch (Exception e) {
                this.serializationError(context, e);
                var21_44 = null;
                if (this.isDebug == false) return;
                this.logger.debug(debugTrace.toString());
                return;
            }
        }
        context.setResponseOutput(outBuffer);
        var21_43 = null;
        if (this.isDebug == false) return;
        this.logger.debug(debugTrace.toString());
        return;
lbl230:
        // 1 sources

        catch (Throwable var20_52) {
            var21_45 = null;
            if (this.isDebug == false) throw var20_52;
            this.logger.debug(debugTrace.toString());
            throw var20_52;
        }
    }

    private void deserializationError(ActionContext context, Throwable t2) {
        String message;
        MessageException methodResult;
        context.setStatus(1);
        MessageBody responseBody = new MessageBody();
        if (context.getMessageNumber() < context.getRequestMessage().getBodyCount()) {
            responseBody.setTargetURI(context.getRequestMessageBody().getResponseURI());
        }
        if (context.getVersion() == 0) {
            context.setVersion(3);
        }
        context.getResponseMessage().addBody(responseBody);
        if (t2 instanceof MessageException) {
            methodResult = (MessageException)t2;
            message = methodResult.getMessage();
        } else {
            methodResult = new SerializationException();
            methodResult.setMessage(10307);
            methodResult.setRootCause(t2);
            message = methodResult.getMessage();
        }
        responseBody.setData(methodResult.createErrorMessage());
        responseBody.setReplyMethod("/onStatus");
        if (Log.isError()) {
            this.logger.error(message + StringUtils.NEWLINE + ExceptionUtil.toString(t2));
        }
    }

    private void unhandledError(ActionContext context, Throwable t2) {
        MessageException methodResult;
        ActionMessage responseMessage = new ActionMessage();
        context.setResponseMessage(responseMessage);
        MessageBody responseBody = new MessageBody();
        responseBody.setTargetURI(context.getRequestMessageBody().getResponseURI());
        context.getResponseMessage().addBody(responseBody);
        if (t2 instanceof MessageException) {
            methodResult = (MessageException)t2;
        } else {
            methodResult = new SerializationException();
            methodResult.setMessage(10306);
            methodResult.setRootCause(t2);
        }
        responseBody.setData(methodResult);
        responseBody.setReplyMethod("/onStatus");
        this.logger.info(t2.getMessage());
    }

    private void serializationError(ActionContext context, Throwable t2) {
        ActionMessage responseMessage = new ActionMessage();
        context.setResponseMessage(responseMessage);
        int bodyCount = context.getRequestMessage().getBodyCount();
        context.setMessageNumber(0);
        while (context.getMessageNumber() < bodyCount) {
            Object methodResult;
            MessageBody responseBody = new MessageBody();
            responseBody.setTargetURI(context.getRequestMessageBody().getResponseURI());
            context.getResponseMessage().addBody(responseBody);
            if (t2 instanceof MessageException) {
                methodResult = ((MessageException)t2).createErrorMessage();
            } else {
                String message = "An error occurred while serializing server response(s).";
                if (t2.getMessage() != null && (message = t2.getMessage()) == null) {
                    message = t2.toString();
                }
                methodResult = new MessageException(message, t2).createErrorMessage();
            }
            if (context.isLegacy()) {
                if (methodResult instanceof ErrorMessage) {
                    ErrorMessage error = methodResult;
                    ASObject aso = new ASObject();
                    aso.put("message", error.faultString);
                    aso.put("code", error.faultCode);
                    aso.put("details", error.faultDetail);
                    aso.put("rootCause", error.rootCause);
                    methodResult = aso;
                } else if (methodResult instanceof Message) {
                    methodResult = ((Message)methodResult).getBody();
                }
            } else {
                Object data = context.getRequestMessageBody().getData();
                if (data instanceof List) {
                    data = ((List)data).get(0);
                } else if (data.getClass().isArray()) {
                    data = Array.get(data, 0);
                }
                if (data instanceof Message) {
                    Message inMessage = (Message)data;
                    if (inMessage.getClientId() != null) {
                        ((ErrorMessage)methodResult).setClientId(inMessage.getClientId().toString());
                    }
                    if (inMessage.getMessageId() != null) {
                        ((ErrorMessage)methodResult).setCorrelationId(inMessage.getMessageId());
                        ((ErrorMessage)methodResult).setDestination(inMessage.getDestination());
                    }
                }
            }
            responseBody.setData(methodResult);
            responseBody.setReplyMethod("/onStatus");
            context.incrementMessageNumber();
        }
        if (Log.isError()) {
            this.logger.error("Exception occurred during serialization: " + ExceptionUtil.toString(t2));
        }
        SerializationContext sc2 = SerializationContext.getSerializationContext();
        MessageSerializer serializer = sc2.newMessageSerializer();
        ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
        AmfTrace debugTrace = this.isDebug ? new AmfTrace() : null;
        serializer.initialize(sc2, outBuffer, debugTrace);
        try {
            serializer.writeMessage(context.getResponseMessage());
            context.setResponseOutput(outBuffer);
        }
        catch (IOException e2) {
            MessageException ex = new MessageException();
            ex.setMessage(10308);
            ex.setRootCause(e2);
            throw ex;
        }
    }
}

