/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.config;

import flex.messaging.config.ChannelSettings;
import flex.messaging.config.ClusterSettings;
import flex.messaging.config.ConfigurationException;
import flex.messaging.config.LoggingSettings;
import flex.messaging.config.ServiceSettings;
import flex.messaging.config.ServicesConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ClientConfiguration
implements ServicesConfiguration {
    protected final Map channelSettings = new HashMap();
    protected final List defaultChannels = new ArrayList(4);
    protected final List serviceSettings;
    protected LoggingSettings loggingSettings;
    protected Map configPaths;
    protected final Map clusterSettings = new HashMap();

    public ClientConfiguration() {
        this.serviceSettings = new ArrayList();
        this.configPaths = new HashMap();
    }

    public void addChannelSettings(String id2, ChannelSettings settings) {
        this.channelSettings.put(id2, settings);
    }

    public ChannelSettings getChannelSettings(String ref) {
        return (ChannelSettings)this.channelSettings.get(ref);
    }

    public Map getAllChannelSettings() {
        return this.channelSettings;
    }

    public void addDefaultChannel(String id2) {
        this.defaultChannels.add(id2);
    }

    public List getDefaultChannels() {
        return this.defaultChannels;
    }

    public void addServiceSettings(ServiceSettings settings) {
        this.serviceSettings.add(settings);
    }

    public ServiceSettings getServiceSettings(String serviceType) {
        Iterator iter = this.serviceSettings.iterator();
        while (iter.hasNext()) {
            ServiceSettings serviceSettings = (ServiceSettings)iter.next();
            if (!serviceSettings.getId().equals(serviceType)) continue;
            return serviceSettings;
        }
        return null;
    }

    public List getAllServiceSettings() {
        return this.serviceSettings;
    }

    public void addClusterSettings(ClusterSettings settings) {
        if (settings.isDefault()) {
            Iterator it = this.clusterSettings.values().iterator();
            while (it.hasNext()) {
                ClusterSettings cs = (ClusterSettings)it.next();
                if (!cs.isDefault()) continue;
                ConfigurationException cx = new ConfigurationException();
                cx.setMessage(10214, new Object[]{settings.getClusterName(), cs.getClusterName()});
                throw cx;
            }
        }
        if (this.clusterSettings.containsKey(settings.getClusterName())) {
            ConfigurationException cx = new ConfigurationException();
            cx.setMessage(10206, new Object[]{settings.getClusterName()});
            throw cx;
        }
        this.clusterSettings.put(settings.getClusterName(), settings);
    }

    public ClusterSettings getClusterSettings(String clusterId) {
        Iterator it = this.clusterSettings.values().iterator();
        while (it.hasNext()) {
            ClusterSettings cs = (ClusterSettings)it.next();
            if (cs.getClusterName() == clusterId) {
                return cs;
            }
            if (cs.getClusterName() == null || !cs.getClusterName().equals(clusterId)) continue;
            return cs;
        }
        return null;
    }

    public ClusterSettings getDefaultCluster() {
        Iterator it = this.clusterSettings.values().iterator();
        while (it.hasNext()) {
            ClusterSettings cs = (ClusterSettings)it.next();
            if (!cs.isDefault()) continue;
            return cs;
        }
        return null;
    }

    public void setLoggingSettings(LoggingSettings settings) {
        this.loggingSettings = settings;
    }

    public LoggingSettings getLoggingSettings() {
        return this.loggingSettings;
    }

    public void addConfigPath(String path, long modified) {
        this.configPaths.put(path, new Long(modified));
    }

    public Map getConfigPaths() {
        return this.configPaths;
    }
}

