/*
 * Decompiled with CFR 0.152.
 */
package flex.management.runtime.messaging.services.remoting;

import flex.management.BaseControl;
import flex.management.runtime.messaging.DestinationControl;
import flex.management.runtime.messaging.services.remoting.RemotingDestinationControlMBean;
import flex.messaging.services.remoting.RemotingDestination;
import java.io.IOException;

public class RemotingDestinationControl
extends DestinationControl
implements RemotingDestinationControlMBean {
    private static final String TYPE = "RemotingDestination";
    private int invocationSuccessCount = 0;
    private int invocationFaultCount = 0;
    private int totalProcessingTimeMillis = 0;
    private int averageProcessingTimeMillis = 0;

    public RemotingDestinationControl(RemotingDestination destination, BaseControl parent) {
        super(destination, parent);
    }

    public String getType() {
        return TYPE;
    }

    public Integer getInvocationSuccessCount() throws IOException {
        return this.invocationSuccessCount;
    }

    public void incrementInvocationSuccessCount(int processingTimeMillis) {
        try {
            ++this.invocationSuccessCount;
            this.totalProcessingTimeMillis += processingTimeMillis;
            this.averageProcessingTimeMillis = this.totalProcessingTimeMillis / (this.invocationSuccessCount + this.invocationFaultCount);
        }
        catch (Exception needsReset) {
            this.reset();
        }
    }

    public Integer getInvocationFaultCount() throws IOException {
        return this.invocationFaultCount;
    }

    public void incrementInvocationFaultCount(int processingTimeMillis) {
        try {
            ++this.invocationFaultCount;
            this.totalProcessingTimeMillis += processingTimeMillis;
            this.averageProcessingTimeMillis = this.totalProcessingTimeMillis / (this.invocationSuccessCount + this.invocationFaultCount);
        }
        catch (Exception needsReset) {
            this.reset();
        }
    }

    public Integer getAverageInvocationProcessingTimeMillis() throws IOException {
        return this.averageProcessingTimeMillis;
    }

    protected void onRegistrationComplete() {
        String name = this.getObjectName().getCanonicalName();
        String[] pollablePerInterval = new String[]{"InvocationSuccessCount", "InvocationFaultCount", "AverageInvocationProcessingTimeMillis"};
        this.getRegistrar().registerObjects(new int[]{151, 50}, name, pollablePerInterval);
    }

    private void reset() {
        this.invocationSuccessCount = 0;
        this.invocationFaultCount = 0;
        this.totalProcessingTimeMillis = 0;
        this.averageProcessingTimeMillis = 0;
    }
}

