/*
 * Decompiled with CFR 0.152.
 */
package flex.management.runtime.messaging.endpoints;

import flex.management.BaseControl;
import flex.management.runtime.messaging.MessageBrokerControl;
import flex.management.runtime.messaging.endpoints.EndpointControlMBean;
import flex.messaging.config.SecurityConstraint;
import flex.messaging.endpoints.Endpoint;
import java.util.Date;
import java.util.List;

public abstract class EndpointControl
extends BaseControl
implements EndpointControlMBean {
    protected Endpoint endpoint;
    private int serviceMessageCount;
    private Date lastServiceMessageTimestamp;
    private long serviceMessageStart;
    private long bytesDeserialized = 0L;
    private long bytesSerialized = 0L;

    public EndpointControl(Endpoint endpoint, BaseControl parent) {
        super(parent);
        this.endpoint = endpoint;
        this.serviceMessageStart = System.currentTimeMillis();
    }

    protected void onRegistrationComplete() {
        String name = this.getObjectName().getCanonicalName();
        String[] generalNames = new String[]{"SecurityConstraint"};
        String[] generalPollables = new String[]{"ServiceMessageCount", "LastServiceMessageTimestamp", "ServiceMessageFrequency"};
        String[] pollableGraphByInterval = new String[]{"BytesDeserialized", "BytesSerialized"};
        this.getRegistrar().registerObjects(100, name, generalNames);
        this.getRegistrar().registerObjects(101, name, generalPollables);
        this.getRegistrar().registerObjects(new int[]{50, 101}, name, pollableGraphByInterval);
    }

    public String getId() {
        return this.endpoint.getId();
    }

    public Boolean isRunning() {
        return this.endpoint.isStarted();
    }

    public Date getStartTimestamp() {
        return this.startTimestamp;
    }

    public Integer getServiceMessageCount() {
        return new Integer(this.serviceMessageCount);
    }

    public void resetServiceMessageCount() {
        this.serviceMessageStart = System.currentTimeMillis();
        this.serviceMessageCount = 0;
        this.lastServiceMessageTimestamp = null;
    }

    public void incrementServiceMessageCount() {
        ++this.serviceMessageCount;
        this.lastServiceMessageTimestamp = new Date();
    }

    public Date getLastServiceMessageTimestamp() {
        return this.lastServiceMessageTimestamp;
    }

    public Double getServiceMessageFrequency() {
        if (this.serviceMessageCount > 0) {
            double runtime = this.differenceInMinutes(this.serviceMessageStart, System.currentTimeMillis());
            return new Double((double)this.serviceMessageCount / runtime);
        }
        return new Double(0.0);
    }

    public void preDeregister() throws Exception {
        MessageBrokerControl parent = (MessageBrokerControl)this.getParentControl();
        parent.removeEndpoint(this.getObjectName());
    }

    public String getURI() {
        return this.endpoint.getUrl();
    }

    public String getSecurityConstraint() {
        return EndpointControl.getSecurityConstraintOf(this.endpoint);
    }

    public static String getSecurityConstraintOf(Endpoint endpoint) {
        String authMethod;
        String result = "None";
        SecurityConstraint constraint = endpoint.getSecurityConstraint();
        if (constraint != null && (authMethod = constraint.getMethod()) != null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(authMethod);
            List roles = constraint.getRoles();
            if (roles != null && !roles.isEmpty()) {
                buffer.append(':');
                for (int i2 = 0; i2 < roles.size(); ++i2) {
                    if (i2 > 0) {
                        buffer.append(',');
                    }
                    buffer.append(' ');
                    buffer.append(roles.get(i2));
                }
            }
            result = buffer.toString();
        }
        return result;
    }

    public Long getBytesDeserialized() {
        return new Long(this.bytesDeserialized);
    }

    public void addToBytesDeserialized(int bytesDeserialized) {
        this.bytesDeserialized += (long)bytesDeserialized;
    }

    public Long getBytesSerialized() {
        return new Long(this.bytesSerialized);
    }

    public void addToBytesSerialized(int bytesSerialized) {
        this.bytesSerialized += (long)bytesSerialized;
    }
}

