/*
 * Decompiled with CFR 0.152.
 */
package flex.management.jmx;

import flex.management.MBeanServerLocatorFactory;
import flex.management.ManagementException;
import flex.management.jmx.Attribute;
import flex.management.jmx.MBeanInfo;
import flex.management.jmx.ObjectInstance;
import flex.management.jmx.ObjectName;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;

public class MBeanServerGateway {
    private static final int MALFORMED_OBJECTNAME = 10400;
    private static final int GETINFO_INTROSPECTION_ERR = 10406;
    private static final int MBEAN_NOTFOUND = 10407;
    private static final int GETINFO_REFLECT_ERR = 10408;
    private static final int ATTRIB_NOTFOUND = 10409;
    private static final int GETATTRIB_EXCEPTION = 10410;
    private static final int GETATTRIB_REFLECT_ERR = 10411;
    private static final int GETATTRIB_NULL_ARGUMENT = 10412;
    private static final int GETATTRIBS_REFLECT_ERR = 10413;
    private static final int GETATTRIBS_NULL_ARGUMENT = 10414;
    private static final int INVOKE_REFLECT_ERR = 10415;
    private static final int INVOKE_ERR = 10416;
    private static final int CREATE_ERR = 10417;
    private static final int INSTANCE_EXISTS = 10418;
    private static final int NOT_COMPLIANT = 10419;
    private static final int MBEAN_PREREG_ERR = 10420;
    private static final int MBEAN_PREDEREG_ERR = 10421;
    private static final int SETATTRIB_REFLECT_ERR = 10422;
    private static final int SETATTRIB_EXCEPTION = 10423;
    private static final int INVALID_ATTRIB_VALUE = 10424;
    private static final int SETATTRIBS_REFLECT_ERR = 10425;
    private MBeanServer server = MBeanServerLocatorFactory.getMBeanServerLocator().getMBeanServer();

    public ObjectInstance createMBean(String className, String objectName) {
        javax.management.ObjectName name = null;
        if (objectName != null) {
            name = this.validateObjectName(objectName);
        }
        try {
            return new ObjectInstance(this.server.createMBean(className, name));
        }
        catch (ReflectionException re) {
            ManagementException me = new ManagementException();
            me.setMessage(10417, new Object[]{name});
            me.setRootCause(re);
            throw me;
        }
        catch (InstanceAlreadyExistsException iaee) {
            ManagementException me = new ManagementException();
            me.setMessage(10418, new Object[]{name});
            me.setRootCause(iaee);
            throw me;
        }
        catch (MBeanException mbe) {
            ManagementException me = new ManagementException();
            me.setMessage(10417, new Object[]{name});
            me.setRootCause(mbe);
            throw me;
        }
        catch (NotCompliantMBeanException ncmbe) {
            ManagementException me = new ManagementException();
            me.setMessage(10419, new Object[]{className});
            me.setRootCause(ncmbe);
            throw me;
        }
    }

    public ObjectInstance createMBean(String className, String objectName, String loaderName) {
        javax.management.ObjectName name = null;
        javax.management.ObjectName loader = null;
        if (objectName != null) {
            name = this.validateObjectName(objectName);
        }
        if (loaderName != null) {
            loader = this.validateObjectName(loaderName);
        }
        try {
            return new ObjectInstance(this.server.createMBean(className, name, loader));
        }
        catch (ReflectionException re) {
            ManagementException me = new ManagementException();
            me.setMessage(10417, new Object[]{name});
            me.setRootCause(re);
            throw me;
        }
        catch (InstanceAlreadyExistsException iaee) {
            ManagementException me = new ManagementException();
            me.setMessage(10418, new Object[]{name});
            me.setRootCause(iaee);
            throw me;
        }
        catch (MBeanException mbe) {
            ManagementException me = new ManagementException();
            me.setMessage(10417, new Object[]{name});
            me.setRootCause(mbe);
            throw me;
        }
        catch (NotCompliantMBeanException ncmbe) {
            ManagementException me = new ManagementException();
            me.setMessage(10419, new Object[]{className});
            me.setRootCause(ncmbe);
            throw me;
        }
        catch (InstanceNotFoundException infe) {
            ManagementException me = new ManagementException();
            me.setMessage(10407, new Object[]{name});
            me.setRootCause(infe);
            throw me;
        }
    }

    public ObjectInstance createMBean(String className, String objectName, Object[] params, String[] signature) {
        javax.management.ObjectName name = null;
        if (objectName != null) {
            name = this.validateObjectName(objectName);
        }
        try {
            return new ObjectInstance(this.server.createMBean(className, name, params, signature));
        }
        catch (ReflectionException re) {
            ManagementException me = new ManagementException();
            me.setMessage(10417, new Object[]{name});
            me.setRootCause(re);
            throw me;
        }
        catch (InstanceAlreadyExistsException iaee) {
            ManagementException me = new ManagementException();
            me.setMessage(10418, new Object[]{name});
            me.setRootCause(iaee);
            throw me;
        }
        catch (MBeanException mbe) {
            ManagementException me = new ManagementException();
            me.setMessage(10417, new Object[]{name});
            me.setRootCause(mbe);
            throw me;
        }
        catch (NotCompliantMBeanException ncmbe) {
            ManagementException me = new ManagementException();
            me.setMessage(10419, new Object[]{className});
            me.setRootCause(ncmbe);
            throw me;
        }
    }

    public ObjectInstance createMBean(String className, String objectName, String loaderName, Object[] params, String[] signature) {
        javax.management.ObjectName name = null;
        javax.management.ObjectName loader = null;
        if (objectName != null) {
            name = this.validateObjectName(objectName);
        }
        if (loaderName != null) {
            loader = this.validateObjectName(loaderName);
        }
        try {
            return new ObjectInstance(this.server.createMBean(className, name, loader, params, signature));
        }
        catch (ReflectionException re) {
            ManagementException me = new ManagementException();
            me.setMessage(10417, new Object[]{name});
            me.setRootCause(re);
            throw me;
        }
        catch (InstanceAlreadyExistsException iaee) {
            ManagementException me = new ManagementException();
            me.setMessage(10418, new Object[]{name});
            me.setRootCause(iaee);
            throw me;
        }
        catch (MBeanException mbe) {
            ManagementException me = new ManagementException();
            me.setMessage(10417, new Object[]{name});
            me.setRootCause(mbe);
            throw me;
        }
        catch (NotCompliantMBeanException ncmbe) {
            ManagementException me = new ManagementException();
            me.setMessage(10419, new Object[]{className});
            me.setRootCause(ncmbe);
            throw me;
        }
        catch (InstanceNotFoundException infe) {
            ManagementException me = new ManagementException();
            me.setMessage(10407, new Object[]{name});
            me.setRootCause(infe);
            throw me;
        }
    }

    public ObjectInstance registerMBean(Object object, String objectName) {
        javax.management.ObjectName name = null;
        if (objectName != null) {
            name = this.validateObjectName(objectName);
        }
        try {
            return new ObjectInstance(this.server.registerMBean(object, name));
        }
        catch (InstanceAlreadyExistsException iaee) {
            ManagementException me = new ManagementException();
            me.setMessage(10418, new Object[]{name});
            me.setRootCause(iaee);
            throw me;
        }
        catch (NotCompliantMBeanException ncmbe) {
            ManagementException me = new ManagementException();
            me.setMessage(10419, new Object[]{object.getClass().getName()});
            me.setRootCause(ncmbe);
            throw me;
        }
        catch (MBeanRegistrationException mbre) {
            ManagementException me = new ManagementException();
            me.setMessage(10420, new Object[]{name});
            me.setRootCause(mbre);
            throw me;
        }
    }

    public void unregisterMBean(String objectName) {
        javax.management.ObjectName name = this.validateObjectName(objectName);
        try {
            this.server.unregisterMBean(name);
        }
        catch (InstanceNotFoundException infe) {
            ManagementException me = new ManagementException();
            me.setMessage(10407, new Object[]{name});
            me.setRootCause(infe);
            throw me;
        }
        catch (MBeanRegistrationException mbre) {
            ManagementException me = new ManagementException();
            me.setMessage(10421, new Object[]{name});
            me.setRootCause(mbre);
            throw me;
        }
    }

    public ObjectInstance getObjectInstance(String objectName) {
        javax.management.ObjectName name = this.validateObjectName(objectName);
        try {
            return new ObjectInstance(this.server.getObjectInstance(name));
        }
        catch (InstanceNotFoundException infe) {
            ManagementException me = new ManagementException();
            me.setMessage(10407, new Object[]{name});
            me.setRootCause(infe);
            throw me;
        }
    }

    public ObjectInstance[] queryMBeans(String objectName) {
        javax.management.ObjectName name = this.validateObjectName(objectName);
        Set<javax.management.ObjectInstance> result = this.server.queryMBeans(name, null);
        int n2 = result.size();
        if (n2 > 0) {
            ObjectInstance[] toReturn = new ObjectInstance[n2];
            int i2 = 0;
            Iterator<javax.management.ObjectInstance> iter = result.iterator();
            while (iter.hasNext()) {
                toReturn[i2++] = new ObjectInstance(iter.next());
            }
            return toReturn;
        }
        return new ObjectInstance[0];
    }

    public ObjectName[] queryNames(String objectName) {
        javax.management.ObjectName name = this.validateObjectName(objectName);
        Set<javax.management.ObjectName> result = this.server.queryNames(name, null);
        int n2 = result.size();
        if (n2 > 0) {
            ObjectName[] toReturn = new ObjectName[n2];
            int i2 = 0;
            Iterator<javax.management.ObjectName> iter = result.iterator();
            while (iter.hasNext()) {
                toReturn[i2++] = new ObjectName(iter.next());
            }
            return toReturn;
        }
        return new ObjectName[0];
    }

    public boolean isRegistered(String objectName) {
        javax.management.ObjectName name = this.validateObjectName(objectName);
        return this.server.isRegistered(name);
    }

    public Integer getMBeanCount() {
        return this.server.getMBeanCount();
    }

    public Object getAttribute(String objectName, String attribute) {
        javax.management.ObjectName name = this.validateObjectName(objectName);
        try {
            return this.server.getAttribute(name, attribute);
        }
        catch (AttributeNotFoundException anfe) {
            ManagementException me = new ManagementException();
            me.setMessage(10409, new Object[]{attribute, name});
            me.setRootCause(anfe);
            throw me;
        }
        catch (MBeanException mbe) {
            ManagementException me = new ManagementException();
            me.setMessage(10410, new Object[]{attribute, name});
            me.setRootCause(mbe);
            throw me;
        }
        catch (ReflectionException re) {
            ManagementException me = new ManagementException();
            me.setMessage(10411, new Object[]{attribute, name});
            me.setRootCause(re);
            throw me;
        }
        catch (InstanceNotFoundException infe) {
            ManagementException me = new ManagementException();
            me.setMessage(10407, new Object[]{name});
            me.setRootCause(infe);
            throw me;
        }
        catch (RuntimeOperationsException roe) {
            ManagementException me = new ManagementException();
            me.setMessage(10412);
            me.setRootCause(roe);
            throw me;
        }
    }

    public Attribute[] getAttributes(String objectName, String[] attributes) {
        javax.management.ObjectName name = this.validateObjectName(objectName);
        try {
            AttributeList result = this.server.getAttributes(name, attributes);
            Attribute[] values = new Attribute[result.size()];
            for (int i2 = 0; i2 < result.size(); ++i2) {
                values[i2] = new Attribute((javax.management.Attribute)result.get(i2));
            }
            return values;
        }
        catch (ReflectionException re) {
            ManagementException me = new ManagementException();
            me.setMessage(10413, new Object[]{name});
            me.setRootCause(re);
            throw me;
        }
        catch (InstanceNotFoundException infe) {
            ManagementException me = new ManagementException();
            me.setMessage(10407, new Object[]{name});
            me.setRootCause(infe);
            throw me;
        }
        catch (RuntimeOperationsException roe) {
            ManagementException me = new ManagementException();
            me.setMessage(10414);
            me.setRootCause(roe);
            throw me;
        }
    }

    public void setAttribute(String objectName, Attribute attribute) {
        javax.management.ObjectName name = this.validateObjectName(objectName);
        javax.management.Attribute attrib = this.validateAttribute(attribute);
        try {
            this.server.setAttribute(name, attrib);
        }
        catch (ReflectionException re) {
            ManagementException me = new ManagementException();
            me.setMessage(10422, new Object[]{attrib.getName(), name});
            me.setRootCause(re);
            throw me;
        }
        catch (InstanceNotFoundException infe) {
            ManagementException me = new ManagementException();
            me.setMessage(10407, new Object[]{name});
            me.setRootCause(infe);
            throw me;
        }
        catch (AttributeNotFoundException anfe) {
            ManagementException me = new ManagementException();
            me.setMessage(10409, new Object[]{attrib.getName(), name});
            me.setRootCause(anfe);
            throw me;
        }
        catch (MBeanException mbe) {
            ManagementException me = new ManagementException();
            me.setMessage(10423, new Object[]{attrib.getName(), name});
            me.setRootCause(mbe);
            throw me;
        }
        catch (InvalidAttributeValueException iave) {
            ManagementException me = new ManagementException();
            me.setMessage(10424, new Object[]{attrib.getValue(), attrib.getName(), name});
            me.setRootCause(iave);
            throw me;
        }
    }

    public Attribute[] setAttributes(String objectName, Attribute[] attributes) {
        javax.management.ObjectName name = this.validateObjectName(objectName);
        AttributeList attribList = new AttributeList();
        for (int i2 = 0; i2 < attributes.length; ++i2) {
            attribList.add(attributes[i2].toAttribute());
        }
        try {
            AttributeList result = this.server.setAttributes(name, attribList);
            Attribute[] values = new Attribute[result.size()];
            for (int i3 = 0; i3 < result.size(); ++i3) {
                values[i3] = new Attribute((javax.management.Attribute)result.get(i3));
            }
            return values;
        }
        catch (InstanceNotFoundException infe) {
            ManagementException me = new ManagementException();
            me.setMessage(10407, new Object[]{name});
            me.setRootCause(infe);
            throw me;
        }
        catch (ReflectionException re) {
            ManagementException me = new ManagementException();
            me.setMessage(10425, new Object[]{name});
            me.setRootCause(re);
            throw me;
        }
    }

    public Object invoke(String objectName, String operationName, Object[] params, String[] signature) {
        javax.management.ObjectName name = this.validateObjectName(objectName);
        try {
            return this.server.invoke(name, operationName, params, signature);
        }
        catch (ReflectionException re) {
            ManagementException me = new ManagementException();
            me.setMessage(10415, new Object[]{operationName, objectName});
            me.setRootCause(re);
            throw me;
        }
        catch (InstanceNotFoundException infe) {
            ManagementException me = new ManagementException();
            me.setMessage(10407, new Object[]{objectName});
            me.setRootCause(infe);
            throw me;
        }
        catch (MBeanException mbe) {
            ManagementException me = new ManagementException();
            me.setMessage(10416, new Object[]{operationName, objectName});
            me.setRootCause(mbe);
            throw me;
        }
    }

    public String getDefaultDomain() {
        return this.server.getDefaultDomain();
    }

    public MBeanInfo getMBeanInfo(String objectName) {
        javax.management.ObjectName name = this.validateObjectName(objectName);
        try {
            return new MBeanInfo(this.server.getMBeanInfo(name));
        }
        catch (IntrospectionException ie) {
            ManagementException me = new ManagementException();
            me.setMessage(10406, new Object[]{objectName});
            me.setRootCause(ie);
            throw me;
        }
        catch (InstanceNotFoundException infe) {
            ManagementException me = new ManagementException();
            me.setMessage(10407, new Object[]{objectName});
            me.setRootCause(infe);
            throw me;
        }
        catch (ReflectionException re) {
            ManagementException me = new ManagementException();
            me.setMessage(10408, new Object[]{objectName});
            me.setRootCause(re);
            throw me;
        }
    }

    public boolean isInstanceOf(String objectName, String className) {
        javax.management.ObjectName name = this.validateObjectName(objectName);
        try {
            return this.server.isInstanceOf(name, className);
        }
        catch (InstanceNotFoundException infe) {
            ManagementException me = new ManagementException();
            me.setMessage(10407, new Object[]{objectName});
            me.setRootCause(infe);
            throw me;
        }
    }

    public ObjectName[] getFlexMBeanObjectNames() {
        javax.management.ObjectName pattern = this.validateObjectName("flex.runtime*:*");
        Set<javax.management.ObjectName> result = this.server.queryNames(pattern, null);
        ObjectName[] names = new ObjectName[result.size()];
        int i2 = 0;
        Iterator<javax.management.ObjectName> iter = result.iterator();
        while (iter.hasNext()) {
            names[i2++] = new ObjectName(iter.next());
        }
        return names;
    }

    public Integer getFlexMBeanCount() {
        return new Integer(this.getFlexMBeanObjectNames().length);
    }

    public String[] getFlexDomains() {
        ObjectName[] names = this.getFlexMBeanObjectNames();
        TreeSet<String> domains = new TreeSet<String>();
        if (names.length > 0) {
            for (int i2 = 0; i2 < names.length; ++i2) {
                String name = names[i2].canonicalName;
                String domain = name.substring(0, name.indexOf(58));
                if (domains.contains(domain)) continue;
                domains.add(domain);
            }
        }
        return domains.toArray(new String[domains.size()]);
    }

    private javax.management.ObjectName validateObjectName(String objectName) {
        try {
            return new javax.management.ObjectName(objectName);
        }
        catch (MalformedObjectNameException mone) {
            ManagementException me = new ManagementException();
            me.setMessage(10400, new Object[]{objectName});
            throw me;
        }
    }

    private javax.management.Attribute validateAttribute(Attribute attribute) {
        return attribute.toAttribute();
    }
}

