unit xmalloc;

{
  K&R C 2nd malloc  
}

{..$DEFINE REPLACE_MANAGER}
{..$DEFINE HEAP_PROFILE}
{..$DEFINE CONSOLE_TEST}
{$DEFINE HEAP_DECOMMIT}

interface

uses
  windows;

function malloc(nbytes: Integer): Pointer;
function free(ap: Pointer): Integer;
function realloc(ap: Pointer; nbytes: Integer): Pointer;

{$IFDEF CONSOLE_TEST}
procedure test;
procedure test2;
procedure test3;
procedure test4;
procedure test5;
procedure test6;
{$ENDIF}

implementation

type
  PHeader = ^THeader;
  THeader = packed record
    next: PHeader;
    _size: UINT;
  end;

  PHeap = ^THeap;
  THeap = record
    heap_base: PHeader;
    heap_reserve: UINT;
    heap_left: Pointer;
  end;

  PCore = ^TCore;
  TCore = record
    base: THeader;
    free_p: PHeader;
    heap: PHeap;
  end;

const
  _NALIGN = SizeOf(THeader);          //8     8bytesEɑ
  _NALLOC = 1024 * 64;                //64K   VirtualAlloc64KP
  _NFREEALLOC = _NALLOC * 2;          //128K  128K̋󂫂łJ
  _NCORE = 128 div 4 - 8;             //24    1byte`192bytesƂȍ~24free_pŊǗ
  _NHEAP = 8;                         //8     16bytes`64bytesʈ
  _NRESERVE = _NALLOC * 1024 div 2;   //32M   16bytes`64bytesɂꂼ32M蓖
  _NRESERVE_BIG = _NALLOC * 1024 * 2; //128M  192bytesȍ~128M蓖
  

var
  cores: array[0..pred(_NCORE)] of TCore;
  heaps: array[0..pred(_NHEAP)] of THeap;

  corelock: TRTLCriticalSection;

{$IFDEF HEAP_PROFILE}
  ntotal: array[0..pred(_NCORE)] of UINT;
{$ENDIF}

{$IFDEF CONSOLE_TEST}
  nblocks: UINT;  
{$ENDIF}

function selectcore(size: UINT): PCore;
//8 ` 192܂
var
  n: UINT;
begin
  n := size div _NALIGN;
  if n > pred(_NCORE) then
    n := 0;

  Result := @cores[n];
end;   

procedure malloc_init;
//virtualallocgđSė\
var
  i,n: Integer;
begin
  for i := 0 to pred(_NHEAP) do
  begin
    if i = 0 then
      heaps[i].heap_reserve := _NRESERVE_BIG
    else
      heaps[i].heap_reserve := _NRESERVE;

    while True do
    begin
      heaps[i].heap_base :=
        VirtualAlloc(nil,heaps[i].heap_reserve,MEM_RESERVE,PAGE_NOACCESS);
      //reserve炷
      if heaps[i].heap_base = nil then
        heaps[i].heap_reserve := heaps[i].heap_reserve shr 1
      else
        break;
    end;

    heaps[i].heap_left := heaps[i].heap_base;
  end;

  for i := 0 to pred(_NCORE) do
  begin
    cores[i].base.next := @cores[i].base;
    cores[i].free_p := @cores[i].base;
    cores[i].base._size := 0;

    case i of
      0: n := 0;
      2..pred(_NHEAP): n := i - 1;
    else
      n := pred(_NHEAP);  
    end;

    cores[i].heap := @heaps[n];
  end;
end;

procedure malloc_free;
//J
var
  i: Integer;
begin
{$IFDEF CONSOLE_TEST}
  writeln('blocks: ',nblocks);
{$ENDIF}
  for i := 0 to pred(_NHEAP) do
  begin
    VirtualFree(heaps[i].heap_base,heaps[i].heap_reserve,MEM_DECOMMIT);
    VirtualFree(heaps[i].heap_base,0,MEM_RELEASE);
  end;

{$IFDEF HEAP_PROFILE}
  Inc(ntotal[0]);
{$ENDIF}
end;

function _free(ap: Pointer; core: PCore): Integer;
//free_pɖ߂
var
  bp,p: PHeader;
  del,more: Boolean;
begin
  Result := 0;
  //nil̏ꍇ͉Ȃ
  if ap = nil then
    Exit;

  EnterCriticalSection(corelock);
  try
    //wb_𓾂
    bp := Pointer(UINT(ap) - SizeOf(THeader));
    if core = nil then
    begin
      core := selectcore(bp._size);
      more := False;
    end
    else
      more := True;
      
    p := core.free_p;
    //}ʒup < bp < p.nextT
    //bppp.next̊ԂɂȂ
    while not ((UINT(p) < UINT(bp)) and (UINT(bp) < UINT(p.next))) do
    begin
      if ((UINT(p) >= UINT(p.next)) and  //ubN̍Ō
         //bpp傫܂bpnext菬
         ((UINT(p) < UINT(bp)) or (UINT(bp) < UINT(p.next)))) then
        break;

      //
      p := p.next;
    end;

    //bpnextƐڂĂꍇ
    if (UINT(bp) + bp._size) = UINT(p.next) then
    begin
      //bpnextƕ
      bp._size := bp._size + p.next._size;
      bp.next := p.next.next;

{$IFDEF HEAP_DECOMMIT}
      //ʂJ
      if (not more) and (bp._size >= _NFREEALLOC) and
         ((UINT(bp) + bp._size) = UINT(core.heap.heap_left)) then
      begin
  {$IFDEF CONSOLE_TEST}
        writeln('free: ',UINT(bp),' ',_NFREEALLOC);
        Dec(nblocks);
  {$ENDIF}
        if bp._size = _NFREEALLOC then
        begin
          //bp͏ł
          p.next := bp.next;
          del := True;
        end
        else begin
          bp._size := bp._size - _NFREEALLOC;
          del := False;
        end; 

        UINT(core.heap.heap_left) := UINT(core.heap.heap_left) - _NFREEALLOC;
        VirtualFree(core.heap.heap_left,_NFREEALLOC,MEM_DECOMMIT);

        if del then
        begin
          //if core = @cores[0] then
            //core.free_p := p;

          Exit;
        end;        
      end;
{$ENDIF}
    end
    else //ڂĂȂꍇ͑}
      bp.next := p.next;

    //pbpڂĂꍇ
    if (UINT(p) + p._size) = UINT(bp) then
    begin
      //pbp𕹍
      p._size := p._size + bp._size;
      p.next := bp.next;
    end
    else//ڂĂȂꍇ͑}
      p.next := bp;

{$IFDEF HEAP_DECOMMIT}
    if (not more) and (p._size > _NFREEALLOC) and
       ((UINT(p) + p._size) = UINT(core.heap.heap_left)) then
    begin
      UINT(core.heap.heap_left) := UINT(core.heap.heap_left) - _NFREEALLOC;
      p._size := p._size - _NFREEALLOC;
      VirtualFree(core.heap.heap_left,_NFREEALLOC,MEM_DECOMMIT);

  {$IFDEF CONSOLE_TEST}
      writeln('free: ',UINT(p),' ',_NFREEALLOC);
      Dec(nblocks);
  {$ENDIF}
    end;
{$ENDIF}
    //if core = @cores[0] then
      //core.free_p := p;
  finally
    LeaveCriticalSection(corelock);
  end;
end;

function morecore(size: UINT): PHeader;
//virtualalloc烁commit
var
  p: PHeader;
  n: UINT;
  c: PCore;
begin
  c := selectcore(size);
  //ŒTCYɑ
  n := (size - 1) div _NALLOC + 1;
  size := n * _NALLOC;    

  p := VirtualAlloc(c.heap.heap_left,size,MEM_COMMIT,PAGE_READWRITE);

  ASSERT(p = c.heap.heap_left);

{$IFDEF CONSOLE_TEST}
  writeln(UINT(p),' ',size);
  Inc(nblocks);
{$ENDIF}

  //[ړ
  UINT(c.heap.heap_left) := UINT(c.heap.heap_left) + size;

  p._size := size;
  //Xgɑ}
  _free(POINTER(UINT(p) + SizeOf(THeader)),c);
  Result := p;
end;

function malloc(nbytes: Integer): Pointer;
var
  p,prev_p: PHeader;
  nu,size: UINT;
  c: PCore;
begin
  EnterCriticalSection(corelock);
  try
    //wb_܂߂size𓾂
    nu := (nbytes + sizeOf(THeader) - 1) div _NALIGN + 1; //align𑵂
    size := nu * _NALIGN;
    if nu > pred(_NCORE) then
      nu := 0;

    c := @cores[nu];
    //c := selectcore(size);
{$IFDEF HEAP_PROFILE}
    Inc(ntotal[nu]);
{$ENDIF}     

    prev_p := c.free_p;
    p := prev_p.next;

    //first fit
    while True do
    begin
      //\ɑ傫
      if p._size >= size then
      begin
        //҂
        if p._size = size then
          prev_p.next := p.next //Jグ
        else begin
          //̍؂o
          prev_p.next := POINTER(UINT(p) + size);
          prev_p.next.next := p.next;
          //TCY
          prev_p.next._size := p._size - size;
          p._size := size;
        end;
        //gp̐擪Ԃ
        //if c = @cores[0] then
        //  c.free_p := prev_p;
          
        Result := Pointer(UINT(p) + SizeOf(THeader));
        Exit;
      end;

      if p = c.free_p then
      begin
        morecore(size);
        p := c.free_p;
      end;

      //
      prev_p := p;
      p := p.next;
    end;

  finally
    LeaveCriticalSection(corelock);
  end;
end;

function free(ap: Pointer): Integer;
begin
  Result := _free(ap,nil);
end;

function realloc(ap: Pointer; nbytes: Integer): Pointer;
var
  bp: PHeader;
  nu,size: UINT;
begin
  EnterCriticalSection(corelock);
  try
    //nil̏ꍇ
    if ap = nil then
    begin
      if nbytes > 0 then
        Result := malloc(nbytes)
      else
        Result := nil;

      Exit;
    end
    else if nbytes = 0 then
    begin
      free(ap);
      Result := nil;
      Exit;
    end;   
  
    //wb_܂߂size𓾂
    nu := (nbytes + sizeOf(THeader) - 1) div _NALIGN + 1; //align𑵂
    size := nu * _NALIGN;
    //wb_𓾂
    bp := Pointer(UINT(ap) - SizeOf(THeader));
    //傫ꍇ͂̂܂ܕԂ
    if bp._size >= size then
      Result := ap
    else begin
      Result := malloc(nbytes);
      //wb_炵ăRs[
      move(ap^,Result^,bp._size - SizeOf(THeader));
      free(ap);
    end;
  finally
    LeaveCriticalSection(corelock);
  end;
end;

{$IFDEF REPLACE_MANAGER}
var
  oldmgr: TMemoryManager;
  
const
  newmgr: TMemoryManager =
  (
    GetMem: malloc;
    FreeMem: free;
    ReAllocMem: realloc;
  );

procedure memorymanager_init;
begin
  GetMemoryManager(oldmgr);
  SetMemoryManager(newmgr);
end;

procedure memorymanager_free;
begin
  SetMemoryManager(oldmgr);
end;
{$ENDIF}


{$IFDEF CONSOLE_TEST}
type
  PItem = ^TItem;
  TItem = record
    next: PItem;
    p: Pointer;
  end;

procedure test6;
var
  x,y: Integer;
  a,b,nxt: PItem;
begin
  writeln('test6');

  for x := 0 to 10000 div 2 do
  begin
    a := nil;

    for y := 0 to Random(2550) do
    begin
      b := malloc(SizeOf(TItem));
      b.p := malloc(Random(2550));

      b.next := a;
      a := b;

      b := malloc(SizeOf(TItem));
      b.p := malloc(Random(128));

      b.next := a;
      a := b;
    end;

    while a <> nil do
    begin
      nxt := a.next;
      free(a.p);
      free(a);
      a := nxt;
    end;
  end;
end;


procedure test5;
var
  a,b,c,d,e: pointer;
  i: Integer;
begin
  writeln('test5');

  for i := 0 to 1000000 do
  begin
    a := malloc(8);
    b := malloc(255);
    c := malloc(65535);
    //d := malloc(65535 * 2);
    e := malloc(10);

    free(e);
    //free(d);
    free(c);
    free(b);
    free(a);
  end;
end;

procedure test;
var
  a,b,c,d,e: pointer;
  i: Integer;
begin
  writeln('test');

  for i := 0 to 1000000 do
  begin
    a := malloc(Random(8));
    b := malloc(Random(255));
    c := malloc(Random(65535));
    //d := malloc(Random(65535 * 2));
    e := malloc(Random(10));

    a := realloc(a,10);

    free(e);
    //free(d);
    free(c);
    free(b);
    free(a);
  end;
end;

procedure test3;
var
  a,b,c,d,e: pointer;
  i: Integer;
begin
  writeln('test3');

  for i := 0 to 1000000 do
  begin
    a := malloc(20);
    b := malloc(20);
    c := malloc(20);
    d := malloc(20);
    e := malloc(20);

    a := realloc(a,20);
    b := realloc(b,10);
    c := realloc(c,30);

    free(e);
    free(d);
    free(c);
    free(b);
    free(a);
  end;
end;

procedure test4;
var
  a,b,c,d,e: pointer;
  i: Integer;
begin
  writeln('test4');

  for i := 0 to 1000000 do
  begin
    a := malloc(Random(65536));
    free(a);

    b := malloc(Random(65536));
    free(b);

    c := malloc(Random(65536));
    free(c);

    d := malloc(Random(65536));
    free(d);

    e := malloc(Random(65536));
    free(e);

    //free(e);
    //free(d);
    //free(c);
    //free(b);
    //free(a);
  end;
end;

procedure test2;
var
  a,b,c,d,e: pointer;
  i: Integer;
begin
  writeln('test2');

  for i := 0 to 1000000 do
  begin
    GetMem(a,8);
    GetMem(b,255);
    GetMem(c,65535);
    GetMem(d,65535 * 2);
    GetMem(e,10);

    freeMem(e);
    freeMem(d);
    freeMem(c);
    freeMem(b);
    freeMem(a);
  end;
end;

{$ENDIF}

initialization
  InitializeCriticalSection(corelock);
{$IFDEF REPLACE_MANAGER}
  memorymanager_init;
{$ENDIF}
  malloc_init;
finalization    
  malloc_free;
{$IFDEF REPLACE_MANAGER}
  memorymanager_free;
{$ENDIF}
  DeleteCriticalSection(corelock);
  
end.