library mmgr_m;

uses
  multimm;

function mmgr_getmem(nbytes: Integer): Pointer;
begin
  Result := MemoryManager.GetMem(nbytes);
end;

function mmgr_freemem(ap: Pointer): Integer;
begin
  Result := MemoryManager.FreeMem(ap);
end;

function mmgr_reallocmem(ap: Pointer; nbytes: Integer): Pointer;
begin
  Result := MemoryManager.ReallocMem(ap,nbytes);
end;  

const
  MNAME = 'multimm'#0;

procedure mmgr_name(p: PChar; len: Integer);
begin
  move(MNAME[1],p^,len);
end;

exports
  mmgr_getmem name 'mmgr_getmem',
  mmgr_freemem name 'mmgr_freemem',
  mmgr_reallocmem name 'mmgr_reallocmem',
  mmgr_name name 'mmgr_name';

begin
end.
