library mmgr_d;

function mmgr_getmem(nbytes: Integer): Pointer;
begin
  Result := SysGetMem(nbytes);
end;

function mmgr_freemem(ap: Pointer): Integer;
begin
  Result := SysFreeMem(ap);
end;

function mmgr_reallocmem(ap: Pointer; nbytes: Integer): Pointer;
begin
  Result := SysReallocMem(ap,nbytes);
end;

const
  MNAME = 'default'#0;

procedure mmgr_name(p: PChar; len: Integer);
begin
  move(MNAME[1],p^,len);
end;

exports
  mmgr_getmem name 'mmgr_getmem',
  mmgr_freemem name 'mmgr_freemem',
  mmgr_reallocmem name 'mmgr_reallocmem',
  mmgr_name name 'mmgr_name';

begin
end.
