/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.autoupdate;

import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.encoder.Encoder;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.control.AddOnCollection;
import org.zaproxy.zap.control.AddOnRunIssuesUtils;
import org.zaproxy.zap.extension.autoupdate.AddOnWrapper;
import org.zaproxy.zap.extension.autoupdate.ExtensionAutoUpdate;

public abstract class AddOnsTableModel
extends AbstractTableModel {
    public static final int COLUMN_ADD_ON_WRAPPER = -1;
    private static final long serialVersionUID = -5240438485136881299L;
    protected final Logger logger = Logger.getLogger(this.getClass());
    private final Comparator<AddOnWrapper> comparator;
    private final List<AddOnWrapper> wrappers;
    private final int progressColumn;
    private AddOnCollection addOnCollection;
    private AddOnSearcher addOnSeacher;

    @Deprecated
    public AddOnsTableModel(Comparator<AddOnWrapper> comparator, AddOnCollection addOnCollection, int progressColumn) {
        this.comparator = comparator;
        this.wrappers = new ArrayList<AddOnWrapper>();
        this.progressColumn = progressColumn;
        this.addOnCollection = addOnCollection;
    }

    public AddOnsTableModel(AddOnCollection addOnCollection, int progressColumn) {
        this.comparator = null;
        this.wrappers = new ArrayList<AddOnWrapper>();
        this.progressColumn = progressColumn;
        this.addOnCollection = addOnCollection;
    }

    public void setAddOnCollection(AddOnCollection addOnCollection) {
        this.addOnCollection = addOnCollection;
    }

    protected List<AddOnWrapper> getAddOnWrappers() {
        return this.wrappers;
    }

    public Set<AddOn> getSelectedAddOns() {
        HashSet<AddOn> selectedAddOns = new HashSet<AddOn>();
        for (AddOnWrapper aow : this.getAddOnWrappers()) {
            if (!aow.isEnabled()) continue;
            selectedAddOns.add(aow.getAddOn());
        }
        return selectedAddOns;
    }

    public Set<AddOn> getDownloadingAddOns() {
        HashSet<AddOn> downloadingAddOns = new HashSet<AddOn>();
        for (AddOnWrapper aow : this.getAddOnWrappers()) {
            AddOn addOn = this.getAddOnForDownload(aow);
            if (AddOn.InstallationStatus.DOWNLOADING != addOn.getInstallationStatus()) continue;
            downloadingAddOns.add(addOn);
        }
        return downloadingAddOns;
    }

    protected AddOn getAddOnForDownload(AddOnWrapper aow) {
        return aow.getAddOn();
    }

    protected void addAddOnWrapper(AddOn addOn, AddOnWrapper.Status status) {
        int idx;
        AddOnWrapper aow = this.createAddOnWrapper(addOn, status);
        if (this.comparator != null) {
            for (idx = 0; idx < this.getAddOnWrappers().size() && this.comparator.compare(aow, this.getAddOnWrappers().get(idx)) >= 0; ++idx) {
                this.getAddOnWrappers().add(idx, aow);
            }
        } else {
            idx = this.getAddOnWrappers().size();
            this.getAddOnWrappers().add(aow);
        }
        this.fireTableRowsInserted(idx, idx);
        this.refreshEntries();
    }

    protected void refreshEntries() {
        for (int idx = 0; idx < this.getAddOnWrappers().size(); ++idx) {
            if (!this.refreshEntry(this.getAddOnWrappers().get(idx), idx)) continue;
            this.fireTableRowsUpdated(idx, idx);
        }
    }

    protected boolean refreshEntry(AddOnWrapper aow, int row) {
        boolean updateRow = false;
        if (aow.getInstallationStatus() != aow.getAddOn().getInstallationStatus()) {
            aow.setInstallationStatus(aow.getAddOn().getInstallationStatus());
            updateRow = true;
        }
        return updateRow |= this.refreshRunningIssues(aow, row);
    }

    public void removeAddOn(AddOn addOn) {
        for (int idx = 0; idx < this.getAddOnWrappers().size(); ++idx) {
            if (!addOn.isSameAddOn(this.getAddOnWrappers().get(idx).getAddOn())) continue;
            this.getAddOnWrappers().remove(idx);
            this.fireTableRowsDeleted(idx, idx);
            this.refreshEntries();
            break;
        }
    }

    public boolean notifyAddOnDownloading(AddOn addOn) {
        for (int idx = 0; idx < this.getAddOnWrappers().size(); ++idx) {
            AddOnWrapper aow = this.getAddOnWrappers().get(idx);
            if (!addOn.isSameAddOn(this.getAddOnForDownload(aow))) continue;
            aow.setInstallationStatus(AddOn.InstallationStatus.DOWNLOADING);
            aow.setEnabled(false);
            this.fireTableRowsUpdated(idx, idx);
            return true;
        }
        return false;
    }

    public boolean notifyAddOnDownloadFailed(String url) {
        for (int idx = 0; idx < this.getAddOnWrappers().size(); ++idx) {
            AddOnWrapper aow = this.getAddOnWrappers().get(idx);
            AddOn addOn = this.getAddOnForDownload(aow);
            if (!AddOnsTableModel.hasSameUrl(addOn, url)) continue;
            this.setFailed(aow, addOn);
            this.fireTableRowsUpdated(idx, idx);
            return true;
        }
        return false;
    }

    private void setFailed(AddOnWrapper aow, AddOn addOn) {
        aow.setFailed(true);
        this.restoreInstallationStatusFailedDownload(aow);
        addOn.setInstallationStatus(AddOn.InstallationStatus.AVAILABLE);
    }

    private static boolean hasSameUrl(AddOn addOn, String url) {
        URL addOnUrl = addOn.getUrl();
        if (addOnUrl == null) {
            return false;
        }
        return addOnUrl.toString().equals(url);
    }

    public boolean notifyAddOnFailedUninstallation(AddOn addOn) {
        for (int idx = 0; idx < this.getAddOnWrappers().size(); ++idx) {
            AddOnWrapper aow = this.getAddOnWrappers().get(idx);
            if (!addOn.isSameAddOn(this.getAddOnForDownload(aow))) continue;
            aow.setInstallationStatus(AddOn.InstallationStatus.UNINSTALLATION_FAILED);
            aow.setEnabled(false);
            this.fireTableRowsUpdated(idx, idx);
            return true;
        }
        return false;
    }

    protected AddOnWrapper getAddOnWrapper(int rowIndex) {
        return this.getAddOnWrappers().get(rowIndex);
    }

    public void updateDownloadsProgresses(ExtensionAutoUpdate extension) {
        block9: {
            final ArrayList<Integer> rows = new ArrayList<Integer>(this.getAddOnWrappers().size());
            for (int idx = 0; idx < this.getAddOnWrappers().size(); ++idx) {
                AddOnWrapper aow = this.getAddOnWrappers().get(idx);
                AddOn addOn = this.getAddOnForDownload(aow);
                if (AddOn.InstallationStatus.DOWNLOADING != addOn.getInstallationStatus()) continue;
                URL url = addOn.getUrl();
                try {
                    int progress = extension.getDownloadProgressPercent(url);
                    if (progress <= 0) continue;
                    aow.setProgress(progress);
                    rows.add(idx);
                    continue;
                }
                catch (Exception e) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Error on " + url), (Throwable)e);
                    }
                    this.setFailed(aow, addOn);
                    try {
                        final int row = idx;
                        EventQueue.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                AddOnsTableModel.this.fireTableRowsUpdated(row, row);
                            }
                        });
                        continue;
                    }
                    catch (InterruptedException | InvocationTargetException exception) {
                        // empty catch block
                    }
                }
            }
            if (!rows.isEmpty()) {
                try {
                    EventQueue.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            for (Integer row : rows) {
                                AddOnsTableModel.this.fireTableCellUpdated(row, AddOnsTableModel.this.progressColumn);
                            }
                        }
                    });
                }
                catch (InterruptedException | InvocationTargetException e) {
                    if (!this.logger.isDebugEnabled()) break block9;
                    this.logger.debug((Object)"Failed to update all the progresses: ", (Throwable)e);
                }
            }
        }
    }

    protected abstract void restoreInstallationStatusFailedDownload(AddOnWrapper var1);

    protected void fireTableColumnUpdated(int firstRow, int lastRow, int column) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, column, 0));
    }

    protected AddOnWrapper createAddOnWrapper(AddOn addOn, AddOnWrapper.Status status) {
        if (this.addOnCollection == null) {
            return new AddOnWrapper(addOn, status);
        }
        return new AddOnWrapper(addOn, status, this.getAddOnRunningIssues(addOn.calculateRunRequirements(this.addOnCollection.getAddOns())));
    }

    protected boolean refreshRunningIssues(AddOnWrapper aow, int row) {
        AddOn.AddOnRunRequirements reqs = aow.getAddOn().calculateRunRequirements(this.addOnCollection.getAddOns());
        String issues = this.getAddOnRunningIssues(reqs);
        aow.setRunningIssues(issues, !reqs.hasExtensionsWithRunningIssues());
        return !issues.isEmpty();
    }

    protected String getAddOnRunningIssues(AddOn.AddOnRunRequirements reqs) {
        List<String> extractedIssues = AddOnRunIssuesUtils.getUiRunningIssues(reqs, this.getAddOnSearcher());
        if (extractedIssues.isEmpty()) {
            List<String> extensionsIssues = AddOnRunIssuesUtils.getUiExtensionsRunningIssues(reqs, this.getAddOnSearcher());
            if (!extensionsIssues.isEmpty()) {
                return AddOnsTableModel.getHtmlFromIssues(Constant.messages.getString("cfu.warn.addon.with.extensions.with.missing.requirements"), extensionsIssues);
            }
            return "";
        }
        return AddOnsTableModel.getHtmlFromIssues(Constant.messages.getString("cfu.warn.addon.with.missing.requirements"), extractedIssues);
    }

    private static String getHtmlFromIssues(String title, List<String> issues) {
        StringBuilder strBuilder = new StringBuilder(150);
        Encoder encoder = new Encoder();
        strBuilder.append("<html><strong>").append(encoder.getHTMLString(title)).append("</strong><ul>");
        for (String issue : issues) {
            strBuilder.append("<li>").append(encoder.getHTMLString(issue)).append("</li>");
        }
        strBuilder.append("</ul></html>");
        return strBuilder.toString();
    }

    protected AddOn getMissingAddOn(String addOnId) {
        return this.addOnCollection.getAddOn(addOnId);
    }

    private AddOnSearcher getAddOnSearcher() {
        if (this.addOnSeacher == null) {
            this.addOnSeacher = new AddOnSearcher();
        }
        return this.addOnSeacher;
    }

    private class AddOnSearcher
    implements AddOnRunIssuesUtils.AddOnSearcher {
        private AddOnSearcher() {
        }

        @Override
        public AddOn searchAddOn(String id) {
            return AddOnsTableModel.this.getMissingAddOn(id);
        }
    }
}

