/*
 * Decompiled with CFR 0.152.
 */
package smetana.core.amiga;

import smetana.core.Bucket;
import smetana.core.CType;
import smetana.core.JUtils;
import smetana.core.__array_of_double__;
import smetana.core.__array_of_integer__;
import smetana.core.__array_of_ptr__;
import smetana.core.__array_of_struct__;
import smetana.core.amiga.Area;
import smetana.core.amiga.AreaDouble;
import smetana.core.amiga.AreaInt;
import smetana.core.amiga.StarStruct;

public class BucketToAreaFactory {
    public static Area createArea(Bucket bucket, StarStruct parent) {
        if (bucket.ctype.getArrayLength() != 0) {
            return BucketToAreaFactory.createAreaArray(bucket, bucket.ctype.getArrayLength());
        }
        if (bucket.ctype.functionPointer()) {
            return null;
        }
        if (bucket.ctype.isIntStar()) {
            return null;
        }
        if (bucket.ctype.isDoubleStar()) {
            return null;
        }
        if (bucket.ctype.isVoidStar()) {
            return null;
        }
        if (bucket.ctype.containsStar()) {
            String type = bucket.ctype.getType();
            if (type.matches("\\w+\\*")) {
                Class theClass = CType.getClassFrom(type.substring(0, type.length() - 1));
                JUtils.LOG("theClass=" + theClass);
                return null;
            }
            throw new UnsupportedOperationException(bucket.toString());
        }
        if (bucket.ctype.isEnum()) {
            return new AreaInt();
        }
        if (bucket.ctype.isPrimitive()) {
            if (bucket.ctype.isInteger()) {
                return new AreaInt();
            }
            if (bucket.ctype.isChar()) {
                return new AreaInt();
            }
            if (bucket.ctype.isShort()) {
                return new AreaInt();
            }
            if (bucket.ctype.isLong()) {
                return new AreaInt();
            }
            if (bucket.ctype.isBoolean()) {
                return new AreaInt();
            }
            if (bucket.ctype.isDoubleOrFloat()) {
                return new AreaDouble();
            }
            throw new UnsupportedOperationException();
        }
        if (bucket.inlineStruct()) {
            Class theClass = bucket.ctype.getTypeClass();
            return new StarStruct(theClass, parent);
        }
        if (bucket.ctype.isArrayOfCString()) {
            return null;
        }
        if (bucket.ctype.isCString()) {
            return null;
        }
        Class theClass = bucket.ctype.getTypeClass();
        if (theClass != null) {
            return null;
        }
        JUtils.LOG("BucketToAreaFactory:: theClass = " + theClass);
        JUtils.LOG("BucketToAreaFactory:: bucket=" + bucket);
        JUtils.LOG("BucketToAreaFactory:: bucket.ctype=" + bucket.ctype);
        throw new UnsupportedOperationException();
    }

    private static Area createAreaArray(Bucket bucket, int arrayLength) {
        JUtils.LOG("BucketToAreaFactory:createAreaArray: bucket=" + bucket);
        JUtils.LOG("BucketToAreaFactory:createAreaArray: arrayLength=" + arrayLength);
        JUtils.LOG("BucketToAreaFactory:createAreaArray: type=" + bucket.ctype);
        if (bucket.ctype.getType().matches("char \\w+\\[\\d+\\]")) {
            return __array_of_integer__.mallocInteger(arrayLength);
        }
        if (bucket.ctype.getType().matches("int \\w+\\[\\d+\\]")) {
            return __array_of_integer__.mallocInteger(arrayLength);
        }
        if (bucket.ctype.getType().matches("double \\w+\\[\\d+\\]")) {
            return __array_of_double__.mallocDouble(arrayLength);
        }
        if (bucket.ctype.getType().matches("\\w+ \\*\\w+\\[\\d+\\]")) {
            String element = bucket.ctype.getType().split(" ")[0];
            JUtils.LOG("element=" + element);
            Class theClass = CType.getClassFrom(element);
            JUtils.LOG("theClass=" + theClass);
            return __array_of_ptr__.malloc_empty(arrayLength);
        }
        if (bucket.ctype.getType().matches("\\w+ \\w+\\[\\d+\\]")) {
            String element = bucket.ctype.getType().split(" ")[0];
            JUtils.LOG("element=" + element);
            Class theClass = CType.getClassFrom(element);
            JUtils.LOG("theClass=" + theClass);
            return __array_of_struct__.malloc(theClass, arrayLength);
        }
        throw new UnsupportedOperationException();
    }
}

