/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.xmi;

import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.GroupRoot;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.statediagram.StateDiagram;
import net.sourceforge.plantuml.utils.UniqueSequence;
import net.sourceforge.plantuml.version.Version;
import net.sourceforge.plantuml.xmi.IXmiClassDiagram;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmiStateDiagram
implements IXmiClassDiagram {
    private final StateDiagram diagram;
    private final Document document;
    private final Element ownedElement;

    public XmiStateDiagram(StateDiagram diagram) throws ParserConfigurationException {
        this.diagram = diagram;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.document = builder.newDocument();
        this.document.setXmlVersion("1.0");
        this.document.setXmlStandalone(true);
        Element xmi = this.document.createElement("XMI");
        xmi.setAttribute("xmi.version", "1.1");
        xmi.setAttribute("xmlns:UML", "href://org.omg/UML/1.3");
        this.document.appendChild(xmi);
        Element header = this.document.createElement("XMI.header");
        xmi.appendChild(header);
        Element metamodel = this.document.createElement("XMI.metamodel");
        metamodel.setAttribute("xmi.name", "UML");
        metamodel.setAttribute("xmi.version", "1.3");
        header.appendChild(metamodel);
        Element content = this.document.createElement("XMI.content");
        xmi.appendChild(content);
        Element model = this.document.createElement("UML:Model");
        model.setAttribute("xmi.id", "model1");
        model.setAttribute("name", "PlantUML " + Version.versionString());
        content.appendChild(model);
        this.ownedElement = this.document.createElement("UML:Namespace.ownedElement");
        model.appendChild(this.ownedElement);
        for (IGroup iGroup : diagram.getGroups(false)) {
            if (!(iGroup.getParentContainer() instanceof GroupRoot)) continue;
            this.addState(iGroup, this.ownedElement);
        }
        for (IEntity iEntity : diagram.getLeafsvalues()) {
            if (!(iEntity.getParentContainer() instanceof GroupRoot)) continue;
            this.addState(iEntity, this.ownedElement);
        }
        for (Link link : diagram.getLinks()) {
            this.addLink(link);
        }
    }

    private void addState(IEntity tobeAdded, Element container) {
        Element elementState = this.createEntityNode(tobeAdded);
        container.appendChild(elementState);
        for (IEntity iEntity : this.diagram.getGroups(false)) {
            if (iEntity.getParentContainer() != tobeAdded) continue;
            this.addState(iEntity, elementState);
        }
        for (IEntity iEntity : this.diagram.getLeafsvalues()) {
            if (iEntity.getParentContainer() != tobeAdded) continue;
            this.addState(iEntity, elementState);
        }
    }

    public static String forXMI(String s) {
        return s.replace(':', ' ');
    }

    public static String forXMI(Display s) {
        return s.get(0).toString().replace(':', ' ');
    }

    private void addLink(Link link) {
        String assId = "ass" + UniqueSequence.getValue();
        Element association = this.document.createElement("UML:Association");
        association.setAttribute("xmi.id", assId);
        association.setAttribute("namespace", "model1");
        if (!Display.isNull(link.getLabel())) {
            association.setAttribute("name", XmiStateDiagram.forXMI(link.getLabel()));
        }
        Element connection = this.document.createElement("UML:Association.connection");
        Element end1 = this.document.createElement("UML:AssociationEnd");
        end1.setAttribute("xmi.id", "end" + UniqueSequence.getValue());
        end1.setAttribute("association", assId);
        end1.setAttribute("type", link.getEntity1().getUid());
        if (link.getQualifier1() != null) {
            end1.setAttribute("name", XmiStateDiagram.forXMI(link.getQualifier1()));
        }
        Element endparticipant1 = this.document.createElement("UML:AssociationEnd.participant");
        if (link.getType().getDecor2() == LinkDecor.COMPOSITION) {
            end1.setAttribute("aggregation", "composite");
        }
        if (link.getType().getDecor2() == LinkDecor.AGREGATION) {
            end1.setAttribute("aggregation", "aggregate");
        }
        end1.appendChild(endparticipant1);
        connection.appendChild(end1);
        Element end2 = this.document.createElement("UML:AssociationEnd");
        end2.setAttribute("xmi.id", "end" + UniqueSequence.getValue());
        end2.setAttribute("association", assId);
        end2.setAttribute("type", link.getEntity2().getUid());
        if (link.getQualifier2() != null) {
            end2.setAttribute("name", XmiStateDiagram.forXMI(link.getQualifier2()));
        }
        Element endparticipant2 = this.document.createElement("UML:AssociationEnd.participant");
        if (link.getType().getDecor1() == LinkDecor.COMPOSITION) {
            end2.setAttribute("aggregation", "composite");
        }
        if (link.getType().getDecor1() == LinkDecor.AGREGATION) {
            end2.setAttribute("aggregation", "aggregate");
        }
        end2.appendChild(endparticipant2);
        connection.appendChild(end2);
        association.appendChild(connection);
        this.ownedElement.appendChild(association);
    }

    private Element createEntityNode(IEntity entity) {
        Element cla = this.document.createElement("UML:State");
        cla.setAttribute("xmi.id", entity.getUid());
        cla.setAttribute("name", entity.getDisplay().get(0).toString());
        cla.setAttribute("namespace", "model1");
        Element feature = this.document.createElement("UML:Classifier.feature");
        cla.appendChild(feature);
        for (Member m : entity.getBodier().getFieldsToDisplay()) {
            Element attribute = this.document.createElement("UML:Attribute");
            attribute.setAttribute("xmi.id", "att" + UniqueSequence.getValue());
            attribute.setAttribute("name", m.getDisplay(false));
            feature.appendChild(attribute);
        }
        for (Member m : entity.getBodier().getMethodsToDisplay()) {
            Element operation = this.document.createElement("UML:Operation");
            operation.setAttribute("xmi.id", "att" + UniqueSequence.getValue());
            operation.setAttribute("name", m.getDisplay(false));
            feature.appendChild(operation);
        }
        return cla;
    }

    @Override
    public void transformerXml(OutputStream os) throws TransformerException, ParserConfigurationException {
        DOMSource source = new DOMSource(this.document);
        StreamResult resultat = new StreamResult(os);
        TransformerFactory fabrique = TransformerFactory.newInstance();
        Transformer transformer = fabrique.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.transform(source, resultat);
    }
}

