/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.version;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.OptionPrint;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.DiagramDescriptionImpl;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizUtils;
import net.sourceforge.plantuml.graphic.GraphicPosition;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.UAntiAliasing;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.version.License;
import net.sourceforge.plantuml.version.Version;

public class PSystemVersion
extends AbstractPSystem {
    private final List<String> strings = new ArrayList<String>();
    private BufferedImage image;
    private static BufferedImage transparentIcon;

    PSystemVersion(boolean withImage, List<String> args) {
        this.strings.addAll(args);
        if (withImage) {
            this.image = PSystemVersion.getPlantumlImage();
        }
    }

    public static BufferedImage getPlantumlImage() {
        try {
            InputStream is = PSystemVersion.class.getResourceAsStream("logo.png");
            BufferedImage image = ImageIO.read(is);
            is.close();
            return image;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BufferedImage getCharlieImage() {
        try {
            InputStream is = PSystemVersion.class.getResourceAsStream("charlie.png");
            BufferedImage image = ImageIO.read(is);
            is.close();
            return image;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BufferedImage getPlantumlSmallIcon() {
        try {
            InputStream is = PSystemVersion.class.getResourceAsStream("favicon.png");
            BufferedImage image = ImageIO.read(is);
            is.close();
            return image;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BufferedImage getPlantumlSmallIcon2() {
        if (transparentIcon != null) {
            return transparentIcon;
        }
        BufferedImage ico = PSystemVersion.getPlantumlSmallIcon();
        if (ico == null) {
            return null;
        }
        transparentIcon = new BufferedImage(ico.getWidth(), ico.getHeight(), 3);
        for (int i = 0; i < ico.getWidth(); ++i) {
            for (int j = 0; j < ico.getHeight(); ++j) {
                int col = ico.getRGB(i, j);
                if (col == ico.getRGB(0, 0)) continue;
                transparentIcon.setRGB(i, j, col);
            }
        }
        return transparentIcon;
    }

    @Override
    public ImageData exportDiagram(OutputStream os, int num, FileFormatOption fileFormat) throws IOException {
        GraphicStrings result = this.getGraphicStrings();
        ImageBuilder imageBuilder = new ImageBuilder(new ColorMapperIdentity(), 1.0, result.getBackcolor(), this.getMetadata(), null, 0.0, 0.0, null, false);
        imageBuilder.setUDrawable(result);
        return imageBuilder.writeImageTOBEMOVED(fileFormat, os);
    }

    public static PSystemVersion createShowVersion() {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("<b>PlantUML version " + Version.versionString() + "</b> (" + Version.compileTimeString() + ")");
        strings.add("(" + (Object)((Object)License.getCurrent()) + " source distribution)");
        strings.add("Loaded from " + Version.getJarPath());
        strings.add(" ");
        strings.addAll(GraphvizUtils.getTestDotStrings(true));
        strings.add(" ");
        Properties p = System.getProperties();
        for (String name : OptionPrint.interestingProperties()) {
            strings.add(p.getProperty(name));
        }
        for (String v : OptionPrint.interestingValues()) {
            strings.add(v);
        }
        return new PSystemVersion(true, strings);
    }

    public static PSystemVersion createShowAuthors() {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("<b>PlantUML version " + Version.versionString() + "</b> (" + Version.compileTimeString() + ")");
        strings.add("(" + (Object)((Object)License.getCurrent()) + " source distribution)");
        strings.add(" ");
        strings.add("<u>Original idea</u>: Arnaud Roques");
        strings.add("<u>Word Macro</u>: Alain Bertucat & Matthieu Sabatier");
        strings.add("<u>Word Add-in</u>: Adriaan van den Brand");
        strings.add("<u>J2V8 & viz.js integration</u>: Andreas Studer");
        strings.add("<u>Eclipse Plugin</u>: Claude Durif & Anne Pecoil");
        strings.add("<u>Servlet & XWiki</u>: Maxime Sinclair");
        strings.add("<u>Site design</u>: Raphael Cotisson");
        strings.add("<u>Logo</u>: Benjamin Croizet");
        strings.add(" ");
        strings.add("http://plantuml.com");
        strings.add(" ");
        return new PSystemVersion(true, strings);
    }

    public static PSystemVersion createCheckVersions(String host, String port2) {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("<b>PlantUML version " + Version.versionString() + "</b> (" + Version.compileTimeString() + ")");
        int lastversion = PSystemVersion.extractDownloadableVersion(host, port2);
        int lim = 7;
        if (lastversion == -1) {
            strings.add("<b><color:red>Error");
            strings.add("<color:red>Cannot connect to http://plantuml.com/");
            strings.add("Maybe you should set your proxy ?");
            strings.add("@startuml");
            strings.add("checkversion(proxy=myproxy.com,port=8080)");
            strings.add("@enduml");
            lim = 9;
        } else if (lastversion == 0) {
            strings.add("<b><color:red>Error</b>");
            strings.add("Cannot retrieve last version from http://plantuml.com/");
        } else {
            strings.add("<b>Last available version for download</b> : " + lastversion);
            strings.add(" ");
            if (Version.version() >= lastversion) {
                strings.add("<b><color:green>Your version is up to date.");
            } else {
                strings.add("<b><color:red>A newer version is available for download.");
            }
        }
        while (strings.size() < lim) {
            strings.add(" ");
        }
        return new PSystemVersion(true, strings);
    }

    public static int extractDownloadableVersion(String host, String port2) {
        if (host != null && port2 != null) {
            System.setProperty("http.proxyHost", host);
            System.setProperty("http.proxyPort", port2);
        }
        try {
            URL url = new URL("http://plantuml.com/download.html");
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setUseCaches(false);
            urlConnection.connect();
            if (urlConnection.getResponseCode() == 200) {
                BufferedReader in = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
                int lastversion = PSystemVersion.extractVersion(in);
                in.close();
                urlConnection.disconnect();
                return lastversion;
            }
        }
        catch (IOException e) {
            Log.error(e.toString());
        }
        return -1;
    }

    private static int extractVersion(BufferedReader in) throws IOException {
        String s;
        Pattern p = Pattern.compile(".*\\.(\\d{4,5})\\..*");
        while ((s = in.readLine()) != null) {
            Matcher m = p.matcher(s);
            if (!m.matches()) continue;
            String v = m.group(1);
            return Integer.parseInt(v);
        }
        return 0;
    }

    public static PSystemVersion createTestDot() throws IOException {
        ArrayList<String> strings = new ArrayList<String>();
        strings.addAll(GraphvizUtils.getTestDotStrings(true));
        return new PSystemVersion(false, strings);
    }

    private GraphicStrings getGraphicStrings() throws IOException {
        UFont font = new UFont("SansSerif", 0, 12);
        return new GraphicStrings(this.strings, font, HtmlColorUtils.BLACK, HtmlColorUtils.WHITE, UAntiAliasing.ANTI_ALIASING_ON, this.image, GraphicPosition.BACKGROUND_CORNER_BOTTOM_RIGHT);
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescriptionImpl("(Version)", this.getClass());
    }

    public List<String> getLines() {
        return Collections.unmodifiableList(this.strings);
    }
}

