/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.sprite;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.DiagramDescriptionImpl;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.UAntiAliasing;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.sprite.RessourcesUtils;

public class PSystemListInternalSprites
extends AbstractPSystem {
    @Override
    public ImageData exportDiagram(OutputStream os, int num, FileFormatOption fileFormat) throws IOException {
        GraphicStrings result = this.getGraphicStrings();
        ImageBuilder imageBuilder = new ImageBuilder(new ColorMapperIdentity(), 1.0, result.getBackcolor(), this.getMetadata(), null, 0.0, 0.0, null, false);
        imageBuilder.setUDrawable(result);
        return imageBuilder.writeImageTOBEMOVED(fileFormat, os);
    }

    private GraphicStrings getGraphicStrings() throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("<b>List Current Sprits");
        lines.add("<i>Credit to");
        lines.add("http://www.archimatetool.com");
        lines.add(" ");
        for (String folder : RessourcesUtils.getJarFile("sprites", true)) {
            lines.add("<u>" + folder + "</u> :");
            lines.add(" ");
            for (String png : RessourcesUtils.getJarFile("sprites/" + folder, false)) {
                if (!png.endsWith(".png")) continue;
                String spriteName = png.substring(0, png.length() - 4);
                lines.add("<$archimate/" + spriteName + "> " + spriteName);
            }
        }
        UFont font = new UFont("SansSerif", 0, 12);
        GraphicStrings graphicStrings = new GraphicStrings(lines, font, HtmlColorUtils.BLACK, HtmlColorUtils.WHITE, UAntiAliasing.ANTI_ALIASING_ON);
        graphicStrings.setMaxLine(35);
        return graphicStrings;
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescriptionImpl("(Sprites)", this.getClass());
    }
}

