/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.crossing;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cute.Balloon;
import net.sourceforge.plantuml.cute.CrossingSegment;
import net.sourceforge.plantuml.geom.LineSegmentDouble;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.posimo.DotPath;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UChange;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class UGraphicCrossing
implements UGraphic {
    private final UGraphic ug;
    private final List<Pending> lines;
    private final UTranslate translate;

    public UGraphicCrossing(UGraphic ug) {
        this(ug, new UTranslate(), new ArrayList<Pending>());
    }

    private static boolean isClose(Point2D p1, Point2D p2) {
        return p1.distance(p2) < 0.1;
    }

    private UGraphicCrossing(UGraphic ug, UTranslate translate, List<Pending> lines) {
        this.ug = ug;
        this.translate = translate;
        this.lines = lines;
    }

    @Override
    public StringBounder getStringBounder() {
        return this.ug.getStringBounder();
    }

    @Override
    public UParam getParam() {
        return this.ug.getParam();
    }

    @Override
    public void draw(UShape shape) {
        if (shape instanceof DotPath) {
            this.drawDotPath((DotPath)shape);
        } else {
            this.ug.draw(shape);
        }
    }

    private void drawDotPath(DotPath dotPath) {
        if (dotPath.isLine()) {
            for (LineSegmentDouble seg : dotPath.getLineSegments()) {
                this.lines.add(new Pending(this.ug.apply(this.translate.reverse()), this.translate, seg.translate(this.translate)));
            }
        } else {
            this.ug.draw(dotPath);
        }
    }

    @Override
    public UGraphic apply(UChange change) {
        if (change instanceof UTranslate) {
            return new UGraphicCrossing(this.ug.apply(change), this.translate.compose((UTranslate)change), this.lines);
        }
        return new UGraphicCrossing(this.ug.apply(change), this.translate, this.lines);
    }

    @Override
    public ColorMapper getColorMapper() {
        return this.ug.getColorMapper();
    }

    @Override
    public void startUrl(Url url) {
        this.ug.startUrl(url);
    }

    @Override
    public void closeAction() {
        this.ug.closeAction();
    }

    @Override
    public void flushUg() {
        ArrayList pendings = new ArrayList();
        ArrayList<Balloon> balloons = new ArrayList<Balloon>();
        for (Pending p : this.lines) {
            List<Point2D> tmp = p.getCollisionsWith(this.lines);
            for (Point2D pt : tmp) {
                balloons.add(new Balloon(pt, 5.0));
            }
        }
        for (Balloon b : balloons) {
            b.drawU(this.ug.apply(new UChangeBackColor(HtmlColorUtils.GREEN)).apply(new UChangeColor(HtmlColorUtils.GREEN)));
        }
        for (Pending p : this.lines) {
            for (Balloon b : balloons) {
                List<Point2D> pts = new CrossingSegment(b, p.segment).intersection();
                for (Point2D pt : pts) {
                    Balloon s2 = new Balloon(pt, 2.0);
                    s2.drawU(this.ug.apply(new UChangeBackColor(HtmlColorUtils.BLUE)).apply(new UChangeColor(HtmlColorUtils.BLUE)));
                }
            }
        }
        this.ug.flushUg();
    }

    @Override
    public boolean isSpecialTxt() {
        return false;
    }

    static class Pending {
        final UGraphic ug;
        final LineSegmentDouble segment;
        final UTranslate translate;

        Pending(UGraphic ug, UTranslate translate, LineSegmentDouble segment2) {
            this.ug = ug;
            this.segment = segment2;
            this.translate = translate;
        }

        void drawNow(HtmlColor color) {
            if (color == null) {
                this.segment.draw(this.ug);
            } else {
                this.segment.draw(this.ug.apply(new UChangeColor(color)));
            }
        }

        List<Point2D> getCollisionsWith(List<Pending> others) {
            ArrayList<Point2D> result = new ArrayList<Point2D>();
            for (Pending other : others) {
                Point2D inter;
                if (UGraphicCrossing.isClose(this.segment.getP1(), other.segment.getP1()) || UGraphicCrossing.isClose(this.segment.getP1(), other.segment.getP2()) || UGraphicCrossing.isClose(this.segment.getP2(), other.segment.getP1()) || UGraphicCrossing.isClose(this.segment.getP2(), other.segment.getP2()) || (inter = this.segment.getSegIntersection(other.segment)) == null) continue;
                result.add(inter);
            }
            return result;
        }
    }
}

