/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.ugraphic.AbstractShadowable;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.USegment;
import net.sourceforge.plantuml.ugraphic.USegmentType;

public class UPath
extends AbstractShadowable
implements Iterable<USegment> {
    private final List<USegment> segments = new ArrayList<USegment>();
    private MinMax minmax = MinMax.getEmpty(false);
    private boolean isOpenIconic;

    public void add(double[] coord, USegmentType pathType) {
        this.addInternal(new USegment(coord, pathType));
    }

    private void addInternal(USegment segment2) {
        this.segments.add(segment2);
        double[] coord = segment2.getCoord();
        if (segment2.getSegmentType() == USegmentType.SEG_ARCTO) {
            this.minmax = this.minmax.addPoint(coord[5], coord[6]);
        } else {
            for (int i = 0; i < coord.length; i += 2) {
                this.minmax = this.minmax.addPoint(coord[i], coord[i + 1]);
            }
        }
    }

    public UPath translate(double dx, double dy) {
        UPath result = new UPath();
        for (USegment seg : this.segments) {
            result.addInternal(seg.translate(dx, dy));
        }
        return result;
    }

    public UPath rotate(double theta) {
        UPath result = new UPath();
        for (USegment seg : this.segments) {
            result.addInternal(seg.rotate(theta));
        }
        return result;
    }

    public void moveTo(Point2D pt) {
        this.moveTo(pt.getX(), pt.getY());
    }

    public void lineTo(Point2D pt) {
        this.lineTo(pt.getX(), pt.getY());
    }

    public void moveTo(double x, double y) {
        this.add(new double[]{x, y}, USegmentType.SEG_MOVETO);
    }

    public void lineTo(double x, double y) {
        this.add(new double[]{x, y}, USegmentType.SEG_LINETO);
    }

    public void cubicTo(double ctrlx1, double ctrly1, double ctrlx2, double ctrly2, double x2, double y2) {
        this.add(new double[]{ctrlx1, ctrly1, ctrlx2, ctrly2, x2, y2}, USegmentType.SEG_CUBICTO);
    }

    public void quadTo(double ctrlx, double ctrly, double x2, double y2) {
        this.add(new double[]{ctrlx, ctrly, ctrlx, ctrly, x2, y2}, USegmentType.SEG_CUBICTO);
    }

    public void quadTo(Point2D ctrl, Point2D pt) {
        this.quadTo(ctrl.getX(), ctrl.getY(), pt.getX(), pt.getY());
    }

    public void arcTo(double rx, double ry, double x_axis_rotation, double large_arc_flag, double sweep_flag, double x, double y) {
        this.add(new double[]{rx, ry, x_axis_rotation, large_arc_flag, sweep_flag, x, y}, USegmentType.SEG_ARCTO);
    }

    public void arcTo(Point2D pt, double radius, double large_arc_flag, double sweep_flag) {
        this.add(new double[]{radius, radius, 0.0, large_arc_flag, sweep_flag, pt.getX(), pt.getY()}, USegmentType.SEG_ARCTO);
    }

    public void closePath() {
    }

    public double getMaxX() {
        return this.minmax.getMaxX();
    }

    public double getMaxY() {
        return this.minmax.getMaxY();
    }

    public double getMinX() {
        return this.minmax.getMinX();
    }

    public double getMinY() {
        return this.minmax.getMinY();
    }

    public String toString() {
        return this.segments.toString();
    }

    @Override
    public Iterator<USegment> iterator() {
        return this.segments.iterator();
    }

    public boolean isOpenIconic() {
        return this.isOpenIconic;
    }

    public void setOpenIconic(boolean isOpenIconic) {
        this.isOpenIconic = isOpenIconic;
    }
}

