/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.plantuml.ugraphic.AbstractCommonUGraphic;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.Scalable;
import net.sourceforge.plantuml.ugraphic.UComment;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UEmpty;
import net.sourceforge.plantuml.ugraphic.UShape;

public abstract class AbstractUGraphic<O>
extends AbstractCommonUGraphic {
    private final O g2d;
    private final Map<Class<? extends UShape>, UDriver<O>> drivers = new HashMap<Class<? extends UShape>, UDriver<O>>();

    public AbstractUGraphic(ColorMapper colorMapper, O g2d) {
        super(colorMapper);
        this.g2d = g2d;
    }

    protected AbstractUGraphic(AbstractUGraphic<O> other) {
        super(other);
        this.g2d = other.g2d;
    }

    protected final O getGraphicObject() {
        return this.g2d;
    }

    protected boolean manageHiddenAutomatically() {
        return true;
    }

    protected final void registerDriver(Class<? extends UShape> cl, UDriver<O> driver) {
        this.drivers.put(cl, driver);
    }

    @Override
    public final void draw(UShape shape) {
        if (shape instanceof UEmpty) {
            return;
        }
        if (shape instanceof UComment) {
            this.drawComment((UComment)shape);
            return;
        }
        UDriver<O> driver = this.drivers.get(shape.getClass());
        if (driver == null) {
            throw new UnsupportedOperationException(shape.getClass().toString() + " " + this.getClass());
        }
        if (this.getParam().isHidden() && this.manageHiddenAutomatically()) {
            return;
        }
        this.beforeDraw();
        if (shape instanceof Scalable) {
            double scale = this.getParam().getScale();
            shape = ((Scalable)((Object)shape)).getScaled(scale);
            driver.draw(shape, this.getTranslateX(), this.getTranslateY(), this.getColorMapper(), this.getParam(), this.g2d);
        } else {
            driver.draw(shape, this.getTranslateX(), this.getTranslateY(), this.getColorMapper(), this.getParam(), this.g2d);
        }
        this.afterDraw();
    }

    protected void drawComment(UComment shape) {
    }

    protected void beforeDraw() {
    }

    protected void afterDraw() {
    }
}

