/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.turing;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.DiagramDescriptionImpl;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.graphic.GraphicPosition;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.turing.BFMachine;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.UAntiAliasing;
import net.sourceforge.plantuml.ugraphic.UFont;

public class PSystemTuring
extends AbstractPSystem {
    private final String program;
    private final String input;

    PSystemTuring(String program, String input) {
        this.program = program;
        this.input = input;
    }

    @Override
    public ImageData exportDiagram(OutputStream os, int num, FileFormatOption fileFormat) throws IOException {
        GraphicStrings result = this.getGraphicStrings();
        ImageBuilder imageBuilder = new ImageBuilder(new ColorMapperIdentity(), 1.0, result.getBackcolor(), this.getMetadata(), null, 0.0, 0.0, null, false);
        imageBuilder.setUDrawable(result);
        return imageBuilder.writeImageTOBEMOVED(fileFormat, os);
    }

    private GraphicStrings getGraphicStrings() throws IOException {
        ArrayList<String> strings = new ArrayList<String>();
        BFMachine machine = new BFMachine(this.program, this.input);
        machine.run();
        String output = machine.getOutput();
        for (String s : output.split("\n")) {
            strings.add(s);
        }
        UFont font = new UFont("Monospaced", 0, 14);
        return new GraphicStrings(strings, font, HtmlColorUtils.BLACK, HtmlColorUtils.WHITE, UAntiAliasing.ANTI_ALIASING_ON, null, GraphicPosition.BACKGROUND_CORNER_BOTTOM_RIGHT);
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescriptionImpl("(Turing)", this.getClass());
    }
}

