/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.syntax;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.ErrorUml;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.PSystemError;
import net.sourceforge.plantuml.SourceStringReader;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.syntax.SyntaxResult;

public class SyntaxChecker {
    public static SyntaxResult checkSyntax(List<String> source) {
        StringBuilder sb = new StringBuilder();
        for (String s : source) {
            sb.append(s);
            sb.append("\n");
        }
        return SyntaxChecker.checkSyntax(sb.toString());
    }

    public static SyntaxResult checkSyntax(String source) {
        OptionFlags.getInstance().setQuiet(true);
        SyntaxResult result = new SyntaxResult();
        if (!source.startsWith("@startuml\n")) {
            result.setError(true);
            result.setErrorLinePosition(0);
            result.addErrorText("No @startuml found");
            result.setSuggest(Arrays.asList("Did you mean:", "@startuml"));
            return result;
        }
        if (!source.endsWith("@enduml\n") && !source.endsWith("@enduml")) {
            result.setError(true);
            result.setErrorLinePosition(SyntaxChecker.lastLineNumber(source));
            result.addErrorText("No @enduml found");
            result.setSuggest(Arrays.asList("Did you mean:", "@enduml"));
            return result;
        }
        SourceStringReader sourceStringReader = new SourceStringReader(new Defines(), source, Collections.<String>emptyList());
        List<BlockUml> blocks = sourceStringReader.getBlocks();
        if (blocks.size() == 0) {
            result.setError(true);
            result.setErrorLinePosition(SyntaxChecker.lastLineNumber(source));
            result.addErrorText("No @enduml found");
            result.setSuggest(Arrays.asList("Did you mean:", "@enduml"));
            return result;
        }
        Diagram system = blocks.get(0).getDiagram();
        result.setCmapData(system.hasUrl());
        if (system instanceof UmlDiagram) {
            result.setUmlDiagramType(((UmlDiagram)system).getUmlDiagramType());
            result.setDescription(system.getDescription().getDescription());
        } else if (system instanceof PSystemError) {
            result.setError(true);
            PSystemError sys = (PSystemError)system;
            result.setErrorLinePosition(sys.getHigherErrorPosition());
            result.setLineLocation(sys.getLineLocation());
            result.setSystemError(sys);
            for (ErrorUml er : sys.getErrorsUml()) {
                result.addErrorText(er.getError());
            }
            result.setSuggest(sys.getSuggest());
        } else {
            result.setDescription(system.getDescription().getDescription());
        }
        return result;
    }

    public static SyntaxResult checkSyntaxFair(String source) {
        SyntaxResult result = new SyntaxResult();
        SourceStringReader sourceStringReader = new SourceStringReader(new Defines(), source, Collections.<String>emptyList());
        List<BlockUml> blocks = sourceStringReader.getBlocks();
        if (blocks.size() == 0) {
            result.setError(true);
            result.setErrorLinePosition(SyntaxChecker.lastLineNumber(source));
            result.addErrorText("No @enduml found");
            result.setSuggest(Arrays.asList("Did you mean:", "@enduml"));
            return result;
        }
        Diagram system = blocks.get(0).getDiagram();
        result.setCmapData(system.hasUrl());
        if (system instanceof UmlDiagram) {
            result.setUmlDiagramType(((UmlDiagram)system).getUmlDiagramType());
            result.setDescription(system.getDescription().getDescription());
        } else if (system instanceof PSystemError) {
            result.setError(true);
            PSystemError sys = (PSystemError)system;
            result.setErrorLinePosition(sys.getHigherErrorPosition());
            result.setLineLocation(sys.getLineLocation());
            for (ErrorUml er : sys.getErrorsUml()) {
                result.addErrorText(er.getError());
            }
            result.setSystemError(sys);
            result.setSuggest(sys.getSuggest());
        } else {
            result.setDescription(system.getDescription().getDescription());
        }
        return result;
    }

    private static int lastLineNumber(String source) {
        int result = 0;
        for (int i = 0; i < source.length(); ++i) {
            if (source.charAt(i) != '\n') continue;
            ++result;
        }
        return result;
    }
}

