/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockEmpty;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.utils.MathUtils;

public class HeaderLayout {
    private final TextBlock name;
    private final TextBlock stereo;
    private final TextBlock generic;
    private final TextBlock circledCharacter;

    public HeaderLayout(TextBlock circledCharacter, TextBlock stereo, TextBlock name, TextBlock generic) {
        this.circledCharacter = HeaderLayout.protectAgaintNull(circledCharacter);
        this.stereo = HeaderLayout.protectAgaintNull(stereo);
        this.name = HeaderLayout.protectAgaintNull(name);
        this.generic = HeaderLayout.protectAgaintNull(generic);
    }

    private static TextBlock protectAgaintNull(TextBlock block2) {
        if (block2 == null) {
            return new TextBlockEmpty();
        }
        return block2;
    }

    public Dimension2D getDimension(StringBounder stringBounder) {
        Dimension2D nameDim = this.name.calculateDimension(stringBounder);
        Dimension2D genericDim = this.generic.calculateDimension(stringBounder);
        Dimension2D stereoDim = this.stereo.calculateDimension(stringBounder);
        Dimension2D circleDim = this.circledCharacter.calculateDimension(stringBounder);
        double width = circleDim.getWidth() + Math.max(stereoDim.getWidth(), nameDim.getWidth()) + genericDim.getWidth();
        double height = MathUtils.max(circleDim.getHeight(), stereoDim.getHeight() + nameDim.getHeight() + 10.0, genericDim.getHeight());
        return new Dimension2DDouble(width, height);
    }

    public void drawU(UGraphic ug, double width, double height) {
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D nameDim = this.name.calculateDimension(stringBounder);
        Dimension2D genericDim = this.generic.calculateDimension(stringBounder);
        Dimension2D stereoDim = this.stereo.calculateDimension(stringBounder);
        Dimension2D circleDim = this.circledCharacter.calculateDimension(stringBounder);
        double widthStereoAndName = Math.max(stereoDim.getWidth(), nameDim.getWidth());
        double suppWith = width - circleDim.getWidth() - widthStereoAndName - genericDim.getWidth();
        assert (suppWith >= 0.0);
        double h2 = Math.min(circleDim.getWidth() / 4.0, suppWith * 0.1);
        double h1 = (suppWith - h2) / 2.0;
        assert (h1 >= 0.0);
        assert (h2 >= 0.0);
        double xCircle = h1;
        double yCircle = (height - circleDim.getHeight()) / 2.0;
        this.circledCharacter.drawU(ug.apply(new UTranslate(xCircle, yCircle)));
        double diffHeight = height - stereoDim.getHeight() - nameDim.getHeight();
        double xStereo = circleDim.getWidth() + (widthStereoAndName - stereoDim.getWidth()) / 2.0 + h1 + h2;
        double yStereo = diffHeight / 2.0;
        this.stereo.drawU(ug.apply(new UTranslate(xStereo, yStereo)));
        double xName = circleDim.getWidth() + (widthStereoAndName - nameDim.getWidth()) / 2.0 + h1 + h2;
        double yName = diffHeight / 2.0 + stereoDim.getHeight();
        this.name.drawU(ug.apply(new UTranslate(xName, yName)));
        if (genericDim.getWidth() > 0.0) {
            double delta = 4.0;
            double xGeneric = width - genericDim.getWidth() + 4.0;
            double yGeneric = -4.0;
            this.generic.drawU(ug.apply(new UTranslate(xGeneric, -4.0)));
        }
    }
}

