/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Point2D;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.BaseFile;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.Rankdir;
import net.sourceforge.plantuml.cucadiagram.dot.DotData;
import net.sourceforge.plantuml.cucadiagram.dot.DotSplines;
import net.sourceforge.plantuml.cucadiagram.dot.Graphviz;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizUtils;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizVersion;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizVersions;
import net.sourceforge.plantuml.cucadiagram.dot.ProcessState;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.posimo.Moveable;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.ClusterPosition;
import net.sourceforge.plantuml.svek.ColorSequence;
import net.sourceforge.plantuml.svek.DotMode;
import net.sourceforge.plantuml.svek.EmptySvgException;
import net.sourceforge.plantuml.svek.Line;
import net.sourceforge.plantuml.svek.MinFinder;
import net.sourceforge.plantuml.svek.Shape;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.SvekUtils;
import net.sourceforge.plantuml.vizjs.GraphvizJs;
import net.sourceforge.plantuml.vizjs.GraphvizJsRuntimeException;

public class DotStringFactory
implements Moveable {
    private final Bibliotekon bibliotekon = new Bibliotekon();
    private final Set<String> rankMin = new HashSet<String>();
    private final ColorSequence colorSequence;
    private final Cluster root;
    private Cluster current;
    private final UmlDiagramType umlDiagramType;
    private final ISkinParam skinParam;
    private final DotMode dotMode;
    private final StringBounder stringBounder;
    private GraphvizVersion graphvizVersion;

    public DotStringFactory(StringBounder stringBounder, DotData dotData) {
        this.skinParam = dotData.getSkinParam();
        this.umlDiagramType = dotData.getUmlDiagramType();
        this.dotMode = dotData.getDotMode();
        this.colorSequence = new ColorSequence();
        this.stringBounder = stringBounder;
        this.current = this.root = new Cluster(this.colorSequence, this.skinParam, dotData.getRootGroup());
    }

    public DotStringFactory(StringBounder stringBounder, CucaDiagram diagram) {
        this.skinParam = diagram.getSkinParam();
        this.umlDiagramType = diagram.getUmlDiagramType();
        this.dotMode = DotMode.NORMAL;
        this.colorSequence = new ColorSequence();
        this.stringBounder = stringBounder;
        this.current = this.root = new Cluster(this.colorSequence, this.skinParam, diagram.getEntityFactory().getRootGroup());
    }

    public void addShape(Shape shape) {
        this.current.addShape(shape);
    }

    private void printMinRanking(StringBuilder sb) {
        if (this.rankMin.size() == 0) {
            return;
        }
        sb.append("{ rank = min;");
        for (String id : this.rankMin) {
            sb.append(id);
            sb.append(";");
        }
        sb.append("}");
    }

    private double getHorizontalDzeta() {
        double max = 0.0;
        for (Line l : this.bibliotekon.allLines()) {
            double c = l.getHorizontalDzeta(this.stringBounder);
            if (!(c > max)) continue;
            max = c;
        }
        return max / 10.0;
    }

    private double getVerticalDzeta() {
        double max = 0.0;
        for (Line l : this.bibliotekon.allLines()) {
            double c = l.getVerticalDzeta(this.stringBounder);
            if (!(c > max)) continue;
            max = c;
        }
        return max / 10.0;
    }

    String createDotString(String ... dotStrings) {
        StringBuilder sb = new StringBuilder();
        double nodesep = this.getHorizontalDzeta();
        if (nodesep < (double)this.getMinNodeSep()) {
            nodesep = this.getMinNodeSep();
        }
        if (this.skinParam.getNodesep() != 0.0) {
            nodesep = this.skinParam.getNodesep();
        }
        String nodesepInches = SvekUtils.pixelToInches(nodesep);
        double ranksep = this.getVerticalDzeta();
        if (ranksep < (double)this.getMinRankSep()) {
            ranksep = this.getMinRankSep();
        }
        if (this.skinParam.getRanksep() != 0.0) {
            ranksep = this.skinParam.getRanksep();
        }
        String ranksepInches = SvekUtils.pixelToInches(ranksep);
        sb.append("digraph unix {");
        SvekUtils.println(sb);
        for (String s : dotStrings) {
            if (s.startsWith("ranksep")) {
                sb.append("ranksep=" + ranksepInches + ";");
            } else if (s.startsWith("nodesep")) {
                sb.append("nodesep=" + nodesepInches + ";");
            } else {
                sb.append(s);
            }
            SvekUtils.println(sb);
        }
        sb.append("remincross=true;");
        SvekUtils.println(sb);
        sb.append("searchsize=500;");
        SvekUtils.println(sb);
        DotSplines dotSplines = this.skinParam.getDotSplines();
        if (dotSplines == DotSplines.POLYLINE) {
            sb.append("splines=polyline;");
            SvekUtils.println(sb);
        } else if (dotSplines == DotSplines.ORTHO) {
            sb.append("splines=ortho;");
            SvekUtils.println(sb);
        }
        if (this.skinParam.getRankdir() == Rankdir.LEFT_TO_RIGHT) {
            sb.append("rankdir=LR;");
            SvekUtils.println(sb);
        }
        this.manageMinMaxCluster(sb);
        this.root.printCluster1(sb, this.bibliotekon.allLines(), this.stringBounder);
        for (Line line : this.bibliotekon.lines0()) {
            line.appendLine(this.getGraphvizVersion(), sb);
        }
        this.root.fillRankMin(this.rankMin);
        this.root.printCluster2(sb, this.bibliotekon.allLines(), this.stringBounder, this.dotMode, this.getGraphvizVersion(), this.umlDiagramType);
        this.printMinRanking(sb);
        for (Line line : this.bibliotekon.lines1()) {
            line.appendLine(this.getGraphvizVersion(), sb);
        }
        SvekUtils.println(sb);
        sb.append("}");
        return sb.toString();
    }

    private void manageMinMaxCluster(StringBuilder sb) {
        ArrayList<String> minPointCluster = new ArrayList<String>();
        ArrayList<String> maxPointCluster = new ArrayList<String>();
        for (Cluster cluster : this.bibliotekon.allCluster()) {
            String maxPoint;
            String minPoint = cluster.getMinPoint(this.umlDiagramType);
            if (minPoint != null) {
                minPointCluster.add(minPoint);
            }
            if ((maxPoint = cluster.getMaxPoint(this.umlDiagramType)) == null) continue;
            maxPointCluster.add(maxPoint);
        }
        if (minPointCluster.size() > 0) {
            sb.append("{rank=min;");
            for (String s : minPointCluster) {
                sb.append(s);
                sb.append(" [shape=point,width=.01,label=\"\"]");
                sb.append(";");
            }
            sb.append("}");
            SvekUtils.println(sb);
        }
        if (maxPointCluster.size() > 0) {
            sb.append("{rank=max;");
            for (String s : maxPointCluster) {
                sb.append(s);
                sb.append(" [shape=point,width=.01,label=\"\"]");
                sb.append(";");
            }
            sb.append("}");
            SvekUtils.println(sb);
        }
    }

    private int getMinRankSep() {
        if (this.umlDiagramType == UmlDiagramType.ACTIVITY) {
            return 40;
        }
        return 60;
    }

    private int getMinNodeSep() {
        if (this.umlDiagramType == UmlDiagramType.ACTIVITY) {
            return 20;
        }
        return 35;
    }

    public GraphvizVersion getGraphvizVersion() {
        if (this.graphvizVersion == null) {
            this.graphvizVersion = this.getGraphvizVersionInternal();
        }
        return this.graphvizVersion;
    }

    private GraphvizVersion getGraphvizVersionInternal() {
        Graphviz graphviz = GraphvizUtils.create(this.skinParam, "foo;", "svg");
        if (graphviz instanceof GraphvizJs) {
            return GraphvizJs.getGraphvizVersion(false);
        }
        File f = graphviz.getDotExe();
        return GraphvizVersions.getInstance().getVersion(f);
    }

    public String getSvg(BaseFile basefile, String[] dotOptions) throws IOException {
        ByteArrayOutputStream baos;
        block5: {
            String dotString = this.createDotString(dotOptions);
            if (basefile != null) {
                File f = basefile.getTraceFile("svek.dot");
                SvekUtils.traceString(f, dotString);
            }
            Graphviz graphviz = GraphvizUtils.create(this.skinParam, dotString, "svg");
            baos = new ByteArrayOutputStream();
            try {
                ProcessState state = graphviz.createFile3(baos);
                baos.close();
                if (state.differs(ProcessState.TERMINATED_OK())) {
                    throw new IllegalStateException("Timeout4 " + state, state.getCause());
                }
            }
            catch (GraphvizJsRuntimeException e) {
                System.err.println("GraphvizJsRuntimeException");
                this.graphvizVersion = GraphvizJs.getGraphvizVersion(true);
                dotString = this.createDotString(dotOptions);
                graphviz = GraphvizUtils.create(this.skinParam, dotString, "svg");
                baos = new ByteArrayOutputStream();
                ProcessState state = graphviz.createFile3(baos);
                baos.close();
                if (!state.differs(ProcessState.TERMINATED_OK())) break block5;
                throw new IllegalStateException("Timeout4 " + state, state.getCause());
            }
        }
        byte[] result = baos.toByteArray();
        String s = new String(result, "UTF-8");
        if (basefile != null) {
            File f = basefile.getTraceFile("svek.svg");
            SvekUtils.traceString(f, s);
        }
        return s;
    }

    public boolean illegalDotExe() {
        Graphviz graphviz = GraphvizUtils.create(this.skinParam, "svg", new String[0]);
        if (graphviz instanceof GraphvizJs) {
            return false;
        }
        File dotExe = graphviz.getDotExe();
        return dotExe == null || !dotExe.isFile() || !dotExe.canRead();
    }

    public File getDotExe() {
        Graphviz graphviz = GraphvizUtils.create(this.skinParam, "svg", new String[0]);
        return graphviz.getDotExe();
    }

    public ClusterPosition solve(String svg) throws IOException, InterruptedException {
        double minY;
        double minX;
        int idx;
        if (svg.length() == 0) {
            throw new EmptySvgException();
        }
        Pattern pGraph = Pattern.compile("(?m)\\<svg\\s+width=\"(\\d+)pt\"\\s+height=\"(\\d+)pt\"");
        Matcher mGraph = pGraph.matcher(svg);
        if (!mGraph.find()) {
            throw new IllegalStateException();
        }
        int fullWidth = Integer.parseInt(mGraph.group(1));
        int fullHeight = Integer.parseInt(mGraph.group(2));
        MinFinder corner1 = new MinFinder();
        for (Shape sh : this.bibliotekon.allShapes()) {
            idx = svg.indexOf("<title>" + sh.getUid() + "</title>");
            if (sh.getType() == ShapeType.RECTANGLE || sh.getType() == ShapeType.RECTANGLE_HTML_FOR_PORTS || sh.getType() == ShapeType.FOLDER || sh.getType() == ShapeType.DIAMOND) {
                List<Point2D.Double> points = SvekUtils.extractPointsList(svg, idx, fullHeight);
                minX = SvekUtils.getMinX(points);
                minY = SvekUtils.getMinY(points);
                corner1.manage(minX, minY);
                sh.moveSvek(minX, minY);
                continue;
            }
            if (sh.getType() == ShapeType.ROUND_RECTANGLE) {
                List<Point2D.Double> points;
                int idx2 = svg.indexOf("d=\"", idx + 1);
                idx = svg.indexOf("points=\"", idx + 1);
                if (idx2 != -1 && (idx == -1 || idx2 < idx)) {
                    points = SvekUtils.extractD(svg, idx2, fullHeight);
                } else {
                    points = SvekUtils.extractPointsList(svg, idx, fullHeight);
                    for (int i = 0; i < 3; ++i) {
                        idx = svg.indexOf("points=\"", idx + 1);
                        points.addAll(SvekUtils.extractPointsList(svg, idx, fullHeight));
                    }
                }
                double minX2 = SvekUtils.getMinX(points);
                double minY2 = SvekUtils.getMinY(points);
                corner1.manage(minX2, minY2);
                sh.moveSvek(minX2, minY2);
                continue;
            }
            if (sh.getType() == ShapeType.OCTAGON) {
                idx = svg.indexOf("points=\"", idx + 1);
                List<Point2D.Double> points = SvekUtils.extractPointsList(svg, idx, fullHeight);
                minX = SvekUtils.getMinX(points);
                minY = SvekUtils.getMinY(points);
                corner1.manage(minX, minY);
                sh.moveSvek(minX, minY);
                sh.setOctagon(minX, minY, points);
                continue;
            }
            if (sh.getType() == ShapeType.CIRCLE || sh.getType() == ShapeType.CIRCLE_IN_RECT || sh.getType() == ShapeType.OVAL) {
                double cx = SvekUtils.getValue(svg, idx, "cx");
                double cy = SvekUtils.getValue(svg, idx, "cy") + (double)fullHeight;
                double rx = SvekUtils.getValue(svg, idx, "rx");
                double ry = SvekUtils.getValue(svg, idx, "ry");
                sh.moveSvek(cx - rx, cy - ry);
                continue;
            }
            throw new IllegalStateException(sh.getType().toString() + " " + sh.getUid());
        }
        for (Cluster cluster : this.bibliotekon.allCluster()) {
            idx = this.getClusterIndex(svg, cluster.getColor());
            List<Point2D.Double> points = SvekUtils.extractPointsList(svg, idx, fullHeight);
            minX = SvekUtils.getMinX(points);
            minY = SvekUtils.getMinY(points);
            double maxX = SvekUtils.getMaxX(points);
            double maxY = SvekUtils.getMaxY(points);
            cluster.setPosition(minX, minY, maxX, maxY);
            corner1.manage(minX, minY);
            if (cluster.getTitleAndAttributeWidth() == 0 || cluster.getTitleAndAttributeHeight() == 0) continue;
            idx = this.getClusterIndex(svg, cluster.getTitleColor());
            List<Point2D.Double> pointsTitle = SvekUtils.extractPointsList(svg, idx, fullHeight);
            double minXtitle = SvekUtils.getMinX(pointsTitle);
            double minYtitle = SvekUtils.getMinY(pointsTitle);
            cluster.setTitlePosition(minXtitle, minYtitle);
        }
        for (Line line : this.bibliotekon.allLines()) {
            line.solveLine(svg, fullHeight, corner1);
        }
        for (Line line : this.bibliotekon.allLines()) {
            line.manageCollision(this.bibliotekon.allShapes());
        }
        corner1.manage(0.0, 0.0);
        return new ClusterPosition(corner1.getMinX(), corner1.getMinY(), fullWidth, fullHeight);
    }

    private int getClusterIndex(String svg, int colorInt) {
        String colorString = StringUtils.goLowerCase(StringUtils.getAsHtml(colorInt));
        String keyTitle1 = "=\"" + colorString + "\"";
        int idx = svg.indexOf(keyTitle1);
        if (idx == -1) {
            String keyTitle2 = "stroke:" + colorString + ";";
            idx = svg.indexOf(keyTitle2);
        }
        if (idx == -1) {
            throw new IllegalStateException("Cannot find color " + colorString);
        }
        return idx;
    }

    public void openCluster(IGroup g, int titleAndAttributeWidth, int titleAndAttributeHeight, TextBlock title, TextBlock stereo) {
        this.current = this.current.createChild(g, titleAndAttributeWidth, titleAndAttributeHeight, title, stereo, this.colorSequence, this.skinParam);
        this.bibliotekon.addCluster(this.current);
    }

    public void closeCluster() {
        if (this.current.getParent() == null) {
            throw new IllegalStateException();
        }
        this.current = this.current.getParent();
    }

    @Override
    public void moveSvek(double deltaX, double deltaY) {
        for (Shape sh : this.bibliotekon.allShapes()) {
            sh.moveSvek(deltaX, deltaY);
        }
        for (Line line : this.bibliotekon.allLines()) {
            line.moveSvek(deltaX, deltaY);
        }
        for (Cluster cl : this.bibliotekon.allCluster()) {
            cl.moveSvek(deltaX, deltaY);
        }
    }

    public final Bibliotekon getBibliotekon() {
        return this.bibliotekon;
    }

    public ColorSequence getColorSequence() {
        return this.colorSequence;
    }
}

