/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.suggest;

import java.util.ArrayList;
import java.util.Iterator;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.CharSequence2Impl;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.CommandControl;
import net.sourceforge.plantuml.command.UmlDiagramFactory;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.suggest.SuggestEngineResult;
import net.sourceforge.plantuml.suggest.SuggestEngineStatus;
import net.sourceforge.plantuml.suggest.VariatorAddOneCharBetweenWords;
import net.sourceforge.plantuml.suggest.VariatorIteratorAdaptor;
import net.sourceforge.plantuml.suggest.VariatorRemoveOneChar;
import net.sourceforge.plantuml.suggest.VariatorSwapLetter;
import net.sourceforge.plantuml.utils.StartUtils;
import net.sourceforge.plantuml.version.IteratorCounter2;
import net.sourceforge.plantuml.version.IteratorCounter2Impl;

public final class SuggestEngine {
    private static final int LIMIT = 500;
    private final UmlDiagramFactory systemFactory;
    private final IteratorCounter2 it99;

    public SuggestEngine(UmlSource source, UmlDiagramFactory systemFactory) {
        this.systemFactory = systemFactory;
        this.it99 = source.iterator2();
        CharSequence startLine = (CharSequence)this.it99.next();
        if (!StartUtils.isArobaseStartDiagram(startLine)) {
            throw new UnsupportedOperationException();
        }
    }

    public SuggestEngineResult tryToSuggest(AbstractPSystem system) {
        return this.executeUmlCommand(system);
    }

    private SuggestEngineResult executeUmlCommand(AbstractPSystem system) {
        while (this.it99.hasNext()) {
            if (StartUtils.isArobaseEndDiagram(this.it99.peek())) {
                return SuggestEngineResult.SYNTAX_OK;
            }
            SuggestEngineResult check = this.checkAndCorrect();
            if (check.getStatus() != SuggestEngineStatus.SYNTAX_OK) {
                return check;
            }
            CommandControl commandControl = this.systemFactory.isValid2(this.it99);
            if (commandControl == CommandControl.OK_PARTIAL) {
                this.systemFactory.goForwardMultiline(this.it99);
                continue;
            }
            if (commandControl == CommandControl.OK) {
                this.it99.next();
                continue;
            }
            return SuggestEngineResult.CANNOT_CORRECT;
        }
        return SuggestEngineResult.CANNOT_CORRECT;
    }

    SuggestEngineResult checkAndCorrect() {
        String incorrectLine = this.it99.peek().toString();
        if (incorrectLine.length() > 500) {
            return SuggestEngineResult.CANNOT_CORRECT;
        }
        CommandControl commandControl = this.systemFactory.isValid2(this.it99);
        if (commandControl != CommandControl.NOT_OK) {
            return SuggestEngineResult.SYNTAX_OK;
        }
        if (StringUtils.trin(incorrectLine).startsWith("{") && this.systemFactory.isValid(BlocLines.single(this.it99.peekPrevious() + " {")) != CommandControl.NOT_OK) {
            return new SuggestEngineResult(this.it99.peekPrevious() + " {");
        }
        ArrayList<VariatorIteratorAdaptor> all = new ArrayList<VariatorIteratorAdaptor>();
        all.add(new VariatorRemoveOneChar(incorrectLine));
        all.add(new VariatorSwapLetter(incorrectLine));
        all.add(new VariatorAddOneCharBetweenWords(incorrectLine, '-'));
        all.add(new VariatorAddOneCharBetweenWords(incorrectLine, ' '));
        for (Iterator iterator : all) {
            SuggestEngineResult result = this.tryThis(iterator);
            if (result == null) continue;
            return result;
        }
        return SuggestEngineResult.CANNOT_CORRECT;
    }

    private SuggestEngineResult tryThis(Iterator<String> it2) {
        while (it2.hasNext()) {
            CommandControl commandControl;
            String newS = it2.next();
            if (StringUtils.trin(newS).length() == 0 || (commandControl = this.systemFactory.isValid2(this.replaceFirstLine(newS))) != CommandControl.OK) continue;
            return new SuggestEngineResult(newS);
        }
        return null;
    }

    private IteratorCounter2 replaceFirstLine(String s) {
        ArrayList<CharSequence2> tmp = new ArrayList<CharSequence2>();
        tmp.add(new CharSequence2Impl(s, null));
        IteratorCounter2 it3 = this.it99.cloneMe();
        if (it3.hasNext()) {
            it3.next();
        }
        while (it3.hasNext()) {
            tmp.add(new CharSequence2Impl((CharSequence)it3.next(), null));
        }
        return new IteratorCounter2Impl(tmp);
    }
}

