/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.command;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.sequencediagram.LifeEventType;
import net.sourceforge.plantuml.sequencediagram.MessageExo;
import net.sourceforge.plantuml.sequencediagram.MessageExoType;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import net.sourceforge.plantuml.sequencediagram.command.CommandArrow;
import net.sourceforge.plantuml.skin.ArrowBody;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.ArrowDecoration;
import net.sourceforge.plantuml.skin.ArrowHead;
import net.sourceforge.plantuml.skin.ArrowPart;

abstract class CommandExoArrowAny
extends SingleLineCommand2<SequenceDiagram> {
    public CommandExoArrowAny(RegexConcat pattern) {
        super(pattern);
    }

    @Override
    protected final CommandExecutionResult executeArg(SequenceDiagram diagram, RegexResult arg) {
        String error;
        ArrowConfiguration config;
        String body = arg.getLazzy("ARROW_BODYA", 0) + arg.getLazzy("ARROW_BODYB", 0);
        String dressing = arg.getLazzy("ARROW_DRESSING", 0);
        Participant p = diagram.getOrCreateParticipant(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("PARTICIPANT", 0)));
        boolean sync = dressing.length() == 2;
        boolean dotted = body.contains("--");
        Display labels = arg.get("LABEL", 0) == null ? Display.create("") : Display.getWithNewlines(arg.get("LABEL", 0));
        boolean bothDirection = arg.get("ARROW_BOTHDRESSING", 0) != null;
        ArrowConfiguration arrowConfiguration = config = bothDirection ? ArrowConfiguration.withDirectionBoth() : ArrowConfiguration.withDirectionNormal();
        if (dotted) {
            config = config.withBody(ArrowBody.DOTTED);
        }
        if (sync) {
            config = config.withHead(ArrowHead.ASYNC);
        }
        config = config.withPart(this.getArrowPart(dressing));
        config = CommandArrow.applyStyle(arg.getLazzy("ARROW_STYLE", 0), config);
        MessageExoType messageExoType = this.getMessageExoType(arg);
        if (messageExoType == MessageExoType.TO_RIGHT || messageExoType == MessageExoType.TO_LEFT) {
            if (this.containsSymbolExterior(arg, "o")) {
                config = config.withDecoration2(ArrowDecoration.CIRCLE);
            }
            if (this.containsSymbol(arg, "o")) {
                config = config.withDecoration1(ArrowDecoration.CIRCLE);
            }
        } else {
            if (this.containsSymbolExterior(arg, "o")) {
                config = config.withDecoration1(ArrowDecoration.CIRCLE);
            }
            if (this.containsSymbol(arg, "o")) {
                config = config.withDecoration2(ArrowDecoration.CIRCLE);
            }
        }
        if (this.containsSymbolExterior(arg, "x") || this.containsSymbol(arg, "x")) {
            config = config.withHead2(ArrowHead.CROSSX);
        }
        if ((error = diagram.addMessage(new MessageExo(p, messageExoType, labels, config, diagram.getNextMessageNumber(), this.isShortArrow(arg)))) != null) {
            return CommandExecutionResult.error(error);
        }
        HtmlColor activationColor = diagram.getSkinParam().getIHtmlColorSet().getColorIfValid(arg.get("LIFECOLOR", 0));
        if (diagram.isAutoactivate() && (config.getHead() == ArrowHead.NORMAL || config.getHead() == ArrowHead.ASYNC)) {
            if (config.isDotted()) {
                diagram.activate(p, LifeEventType.DEACTIVATE, null);
            } else {
                diagram.activate(p, LifeEventType.ACTIVATE, activationColor);
            }
        }
        return CommandExecutionResult.ok();
    }

    private ArrowPart getArrowPart(String dressing) {
        if (dressing.contains("/")) {
            return ArrowPart.BOTTOM_PART;
        }
        if (dressing.contains("\\")) {
            return ArrowPart.TOP_PART;
        }
        return ArrowPart.FULL;
    }

    abstract MessageExoType getMessageExoType(RegexResult var1);

    private boolean isShortArrow(RegexResult arg2) {
        String s = arg2.get("SHORT", 0);
        return s != null && s.contains("?");
    }

    private boolean containsSymbolExterior(RegexResult arg2, String symbol) {
        String s = arg2.get("SHORT", 0);
        return s != null && s.contains(symbol);
    }

    private boolean containsSymbol(RegexResult arg2, String symbol) {
        String s = arg2.get("ARROW_SUPPCIRCLE", 0);
        return s != null && s.contains(symbol);
    }
}

