/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.Scale;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.DiagramDescriptionImpl;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.DisplayPositionned;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.sequencediagram.AbstractMessage;
import net.sourceforge.plantuml.sequencediagram.Delay;
import net.sourceforge.plantuml.sequencediagram.Divider;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.EventWithDeactivate;
import net.sourceforge.plantuml.sequencediagram.Grouping;
import net.sourceforge.plantuml.sequencediagram.GroupingLeaf;
import net.sourceforge.plantuml.sequencediagram.GroupingStart;
import net.sourceforge.plantuml.sequencediagram.GroupingType;
import net.sourceforge.plantuml.sequencediagram.HSpace;
import net.sourceforge.plantuml.sequencediagram.LifeEvent;
import net.sourceforge.plantuml.sequencediagram.LifeEventType;
import net.sourceforge.plantuml.sequencediagram.Message;
import net.sourceforge.plantuml.sequencediagram.Newpage;
import net.sourceforge.plantuml.sequencediagram.Note;
import net.sourceforge.plantuml.sequencediagram.Notes;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.ParticipantEnglober;
import net.sourceforge.plantuml.sequencediagram.ParticipantType;
import net.sourceforge.plantuml.sequencediagram.Reference;
import net.sourceforge.plantuml.sequencediagram.graphic.FileMaker;
import net.sourceforge.plantuml.sequencediagram.graphic.SequenceDiagramFileMakerPuma2;
import net.sourceforge.plantuml.sequencediagram.graphic.SequenceDiagramTxtMaker;
import net.sourceforge.plantuml.sequencediagram.teoz.SequenceDiagramFileMakerTeoz;
import net.sourceforge.plantuml.skin.ProtectedSkin;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.skin.SkinUtils;
import net.sourceforge.plantuml.skin.rose.Rose;

public class SequenceDiagram
extends UmlDiagram {
    private final Map<String, Participant> participants = new LinkedHashMap<String, Participant>();
    private final List<Event> events = new ArrayList<Event>();
    private final Map<Participant, ParticipantEnglober> participantEnglobers2 = new HashMap<Participant, ParticipantEnglober>();
    private final Skin skinInitial = new ProtectedSkin(new Rose());
    private Skin skin2 = new ProtectedSkin(new Rose());
    private EventWithDeactivate lastEventWithDeactivate;
    private boolean ignoreNewpage = false;
    private int autonewpage = -1;
    private Delay lastDelay;
    private final Stack<Message> activationState = new Stack();
    private LifeEvent pendingCreate = null;
    private final List<GroupingStart> openGroupings = new ArrayList<GroupingStart>();
    private boolean autonumber = false;
    private int messageNumber;
    private int incrementMessageNumber;
    private DecimalFormat decimalFormat;
    private boolean showFootbox = true;
    private ParticipantEnglober participantEnglober;
    private boolean autoactivate;

    @Deprecated
    public Participant getOrCreateParticipant(String code) {
        return this.getOrCreateParticipant(code, Display.getWithNewlines(code));
    }

    public Participant getOrCreateParticipant(String code, Display display) {
        Participant result = this.participants.get(code);
        if (result == null) {
            result = new Participant(ParticipantType.PARTICIPANT, code, display);
            this.participants.put(code, result);
            this.participantEnglobers2.put(result, this.participantEnglober);
        }
        return result;
    }

    public EventWithDeactivate getLastEventWithDeactivate() {
        return this.lastEventWithDeactivate;
    }

    public Participant createNewParticipant(ParticipantType type, String code, Display display) {
        if (this.participants.containsKey(code)) {
            throw new IllegalArgumentException();
        }
        if (Display.isNull(display)) {
            display = Display.getWithNewlines(code);
        }
        Participant result = new Participant(type, code, display);
        this.participants.put(code, result);
        this.participantEnglobers2.put(result, this.participantEnglober);
        return result;
    }

    public Map<String, Participant> participants() {
        return Collections.unmodifiableMap(this.participants);
    }

    public String addMessage(AbstractMessage m) {
        this.lastEventWithDeactivate = m;
        this.lastDelay = null;
        this.events.add(m);
        if (this.pendingCreate != null) {
            if (!m.compatibleForCreate(this.pendingCreate.getParticipant())) {
                return "After create command, you have to send a message to \"" + this.pendingCreate.getParticipant() + "\"";
            }
            m.addLifeEvent(this.pendingCreate);
            this.pendingCreate = null;
        }
        return null;
    }

    public void addNote(Note n, boolean tryMerge) {
        if (tryMerge && this.events.size() > 0) {
            Event last = this.events.get(this.events.size() - 1);
            if (last instanceof Note) {
                Notes notes = new Notes((Note)last, n);
                this.events.set(this.events.size() - 1, notes);
                return;
            }
            if (last instanceof Notes) {
                ((Notes)last).add(n);
                return;
            }
        }
        this.events.add(n);
    }

    public void newpage(Display strings) {
        if (this.ignoreNewpage) {
            return;
        }
        this.events.add(new Newpage(strings));
    }

    public void ignoreNewpage() {
        this.ignoreNewpage = true;
    }

    public final int getAutonewpage() {
        return this.autonewpage;
    }

    public void setAutonewpage(int autonewpage) {
        this.autonewpage = autonewpage;
    }

    public void divider(Display strings) {
        this.events.add(new Divider(strings));
    }

    public void hspace() {
        this.events.add(new HSpace());
    }

    public void hspace(int pixel) {
        this.events.add(new HSpace(pixel));
    }

    public void delay(Display strings) {
        Delay delay = new Delay(strings);
        this.events.add(delay);
        this.lastDelay = delay;
    }

    public List<Event> events() {
        return Collections.unmodifiableList(this.events);
    }

    private FileMaker getSequenceDiagramPngMaker(FileFormatOption fileFormatOption) {
        FileFormat fileFormat = fileFormatOption.getFileFormat();
        if (fileFormat == FileFormat.ATXT || fileFormat == FileFormat.UTXT) {
            return new SequenceDiagramTxtMaker(this, fileFormat);
        }
        if (this.modeTeoz()) {
            return new SequenceDiagramFileMakerTeoz(this, this.getSkin2(), fileFormatOption);
        }
        return new SequenceDiagramFileMakerPuma2(this, this.getSkin2(), fileFormatOption);
    }

    private boolean modeTeoz() {
        return this.getPragma().useTeozLayout();
    }

    @Override
    protected ImageData exportDiagramInternal(OutputStream os, int index, FileFormatOption fileFormat) throws IOException {
        FileMaker sequenceDiagramPngMaker = this.getSequenceDiagramPngMaker(fileFormat);
        return sequenceDiagramPngMaker.createOne(os, index, fileFormat.isWithMetadata());
    }

    public Message getActivatingMessage() {
        if (this.activationState.empty()) {
            return null;
        }
        return this.activationState.peek();
    }

    public String activate(Participant p, LifeEventType lifeEventType, HtmlColor backcolor) {
        return this.activate(p, lifeEventType, backcolor, null);
    }

    public String activate(Participant p, LifeEventType lifeEventType, HtmlColor backcolor, HtmlColor linecolor) {
        if (this.lastDelay != null) {
            return "You cannot Activate/Deactivate just after a ...";
        }
        LifeEvent lifeEvent = new LifeEvent(p, lifeEventType, new SymbolContext(backcolor, linecolor));
        this.events.add(lifeEvent);
        if (lifeEventType == LifeEventType.CREATE) {
            this.pendingCreate = lifeEvent;
            return null;
        }
        if (this.lastEventWithDeactivate == null) {
            if (lifeEventType == LifeEventType.ACTIVATE) {
                p.incInitialLife(new SymbolContext(backcolor, linecolor));
                return null;
            }
            return "Only activate command can occur before message are send";
        }
        if (lifeEventType == LifeEventType.ACTIVATE && this.lastEventWithDeactivate instanceof Message) {
            this.activationState.push((Message)this.lastEventWithDeactivate);
        } else if (lifeEventType == LifeEventType.DEACTIVATE && !this.activationState.empty()) {
            this.activationState.pop();
        }
        boolean ok = this.lastEventWithDeactivate.addLifeEvent(lifeEvent);
        if (this.lastEventWithDeactivate instanceof AbstractMessage) {
            lifeEvent.setMessage((AbstractMessage)this.lastEventWithDeactivate);
        }
        if (ok) {
            return null;
        }
        return "Activate/Deactivate already done on " + p.getCode();
    }

    public boolean grouping(String title, String comment, GroupingType type, HtmlColor backColorGeneral, HtmlColor backColorElement) {
        if (type != GroupingType.START && this.openGroupings.size() == 0) {
            return false;
        }
        if (backColorGeneral == null) {
            backColorGeneral = this.getSkinParam().getHtmlColor(ColorParam.sequenceGroupBodyBackground, null, false);
        }
        GroupingStart top = this.openGroupings.size() > 0 ? this.openGroupings.get(0) : null;
        Grouping g = type == GroupingType.START ? new GroupingStart(title, comment, backColorGeneral, backColorElement, top) : new GroupingLeaf(title, comment, type, backColorGeneral, backColorElement, top);
        this.events.add(g);
        if (type == GroupingType.START) {
            this.openGroupings.add(0, (GroupingStart)g);
        } else if (type == GroupingType.END) {
            this.openGroupings.remove(0);
            this.lastEventWithDeactivate = (GroupingLeaf)g;
        }
        return true;
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescriptionImpl("(" + this.participants.size() + " participants)", this.getClass());
    }

    public boolean changeSkin(String className) {
        Skin s = SkinUtils.loadSkin(className);
        Integer expected = new Integer(1);
        if (s != null && expected.equals(s.getProtocolVersion())) {
            this.skin2 = new ProtectedSkin(s);
            return true;
        }
        return false;
    }

    private Skin getSkin2() {
        if (this.modeTeoz()) {
            return this.skinInitial;
        }
        return this.skin2;
    }

    public final void autonumberGo(int startingNumber, int increment, DecimalFormat decimalFormat) {
        this.autonumber = true;
        this.messageNumber = startingNumber;
        this.incrementMessageNumber = increment;
        this.decimalFormat = decimalFormat;
    }

    public final void autonumberStop() {
        this.autonumber = false;
    }

    public final void autonumberResume(DecimalFormat decimalFormat) {
        this.autonumber = true;
        if (decimalFormat != null) {
            this.decimalFormat = decimalFormat;
        }
    }

    public final void autonumberResume(int increment, DecimalFormat decimalFormat) {
        this.autonumber = true;
        this.incrementMessageNumber = increment;
        if (decimalFormat != null) {
            this.decimalFormat = decimalFormat;
        }
    }

    public String getNextMessageNumber() {
        if (!this.autonumber) {
            return null;
        }
        int result = this.messageNumber;
        this.messageNumber += this.incrementMessageNumber;
        return this.decimalFormat.format(result);
    }

    public boolean isShowFootbox() {
        if (this.getSkinParam().strictUmlStyle()) {
            return false;
        }
        String footbox = this.getSkinParam().getValue("footbox");
        if (footbox == null) {
            return this.showFootbox;
        }
        return !footbox.equalsIgnoreCase("hide");
    }

    public void setShowFootbox(boolean footbox) {
        this.showFootbox = footbox;
    }

    @Override
    public UmlDiagramType getUmlDiagramType() {
        return UmlDiagramType.SEQUENCE;
    }

    public void boxStart(Display comment, HtmlColor color) {
        if (this.participantEnglober != null) {
            throw new IllegalStateException();
        }
        this.participantEnglober = new ParticipantEnglober(comment, color);
    }

    public void endBox() {
        if (this.participantEnglober == null) {
            throw new IllegalStateException();
        }
        this.participantEnglober = null;
    }

    public boolean isBoxPending() {
        return this.participantEnglober != null;
    }

    @Override
    public int getNbImages() {
        try {
            return this.getSequenceDiagramPngMaker(new FileFormatOption(FileFormat.PNG)).getNbPages();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return 1;
        }
    }

    public void removeHiddenParticipants() {
        for (Participant p : new ArrayList<Participant>(this.participants.values())) {
            if (!this.isAlone(p)) continue;
            this.remove(p);
        }
    }

    private void remove(Participant p) {
        boolean ok = this.participants.values().remove(p);
        if (!ok) {
            throw new IllegalArgumentException();
        }
        this.participantEnglobers2.remove(p);
    }

    private boolean isAlone(Participant p) {
        for (Event ev : this.events) {
            if (!ev.dealWith(p)) continue;
            return false;
        }
        return true;
    }

    public void putParticipantInLast(String code) {
        Participant p = this.participants.get(code);
        if (p == null) {
            throw new IllegalArgumentException(code);
        }
        this.participants.remove(code);
        this.participants.put(code, p);
        this.participantEnglobers2.put(p, this.participantEnglober);
    }

    public ParticipantEnglober getEnglober(Participant p) {
        return this.participantEnglobers2.get(p);
    }

    public final void setAutoactivate(boolean autoactivate) {
        this.autoactivate = autoactivate;
    }

    public final boolean isAutoactivate() {
        return this.autoactivate;
    }

    @Override
    public boolean hasUrl() {
        for (Participant p : this.participants.values()) {
            if (p.getUrl() == null) continue;
            return true;
        }
        for (Event ev : this.events) {
            if (!ev.hasUrl()) continue;
            return true;
        }
        return !DisplayPositionned.isNull(this.getLegend()) && this.getLegend().hasUrl();
    }

    public void addReference(Reference ref) {
        this.events.add(ref);
    }

    @Override
    public boolean isOk() {
        return this.participants.size() != 0;
    }

    public double getDpiFactor(FileFormatOption fileFormatOption, Dimension2D dim) {
        Scale scale = this.getScale();
        double dpiFactor = scale == null ? this.getDpiFactor(fileFormatOption) : scale.getScale(dim.getWidth(), dim.getHeight());
        return dpiFactor;
    }

    @Override
    public String checkFinalError() {
        if (this.isHideUnlinkedData()) {
            this.removeHiddenParticipants();
        }
        return super.checkFinalError();
    }
}

