/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.element;

import java.util.HashSet;
import java.util.Set;
import net.sourceforge.plantuml.salt.Cell;
import net.sourceforge.plantuml.salt.element.Segment;
import net.sourceforge.plantuml.salt.element.TableStrategy;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class Grid {
    private final double[] rowsStart;
    private final double[] colsStart;
    private final TableStrategy strategy;
    private final Set<Segment> horizontals = new HashSet<Segment>();
    private final Set<Segment> verticals = new HashSet<Segment>();

    public Grid(double[] rowsStart, double[] colsStart, TableStrategy strategy) {
        this.rowsStart = rowsStart;
        this.colsStart = colsStart;
        this.strategy = strategy;
        if (strategy == TableStrategy.DRAW_OUTSIDE || strategy == TableStrategy.DRAW_ALL) {
            this.addOutside();
        }
    }

    private void addOutside() {
        int nbRow = this.rowsStart.length;
        int nbCol = this.colsStart.length;
        for (int c = 0; c < nbCol - 1; ++c) {
            this.horizontals.add(new Segment(0, c));
            this.horizontals.add(new Segment(nbRow - 1, c));
        }
        for (int r = 0; r < nbRow - 1; ++r) {
            this.verticals.add(new Segment(r, 0));
            this.verticals.add(new Segment(r, nbCol - 1));
        }
    }

    public void drawU(UGraphic ug, double x, double y) {
        int col1;
        int row1;
        for (Segment seg : this.horizontals) {
            row1 = seg.getRow();
            col1 = seg.getCol();
            double width = this.colsStart[col1 + 1] - this.colsStart[col1];
            ug.apply(new UTranslate(x + this.colsStart[col1], y + this.rowsStart[row1])).draw(new ULine(width, 0.0));
        }
        for (Segment seg : this.verticals) {
            row1 = seg.getRow();
            col1 = seg.getCol();
            double height = this.rowsStart[row1 + 1] - this.rowsStart[row1];
            ug.apply(new UTranslate(x + this.colsStart[col1], y + this.rowsStart[row1])).draw(new ULine(0.0, height));
        }
    }

    public void addCell(Cell cell2) {
        if (this.strategy == TableStrategy.DRAW_NONE) {
            return;
        }
        if (this.strategy == TableStrategy.DRAW_OUTSIDE) {
            return;
        }
        if (this.strategy == TableStrategy.DRAW_HORIZONTAL || this.strategy == TableStrategy.DRAW_ALL) {
            for (int c = cell2.getMinCol(); c <= cell2.getMaxCol(); ++c) {
                this.horizontals.add(new Segment(cell2.getMinRow(), c));
                this.horizontals.add(new Segment(cell2.getMaxRow() + 1, c));
            }
        }
        if (this.strategy == TableStrategy.DRAW_VERTICAL || this.strategy == TableStrategy.DRAW_ALL) {
            for (int r = cell2.getMinRow(); r <= cell2.getMaxRow(); ++r) {
                this.verticals.add(new Segment(r, cell2.getMinCol()));
                this.verticals.add(new Segment(r, cell2.getMaxCol() + 1));
            }
        }
    }
}

