/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.DiagramDescriptionImpl;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.salt.SaltUtils;
import net.sourceforge.plantuml.salt.element.Element;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.UAntiAliasing;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.g2d.UGraphicG2d;

public class PSystemSalt
extends AbstractPSystem {
    private final List<String> data;

    @Deprecated
    public PSystemSalt(List<String> data) {
        this.data = data;
    }

    public PSystemSalt() {
        this(new ArrayList<String>());
    }

    public void add(String s) {
        this.data.add(s);
    }

    @Override
    public ImageData exportDiagram(OutputStream os, int num, FileFormatOption fileFormat) throws IOException {
        final Element salt = SaltUtils.createElement(this.data);
        final Dimension2D size = salt.getPreferredDimension(fileFormat.getDefaultStringBounder(), 0.0, 0.0);
        ImageBuilder builder = new ImageBuilder(new ColorMapperIdentity(), 1.0, HtmlColorUtils.WHITE, null, null, 5.0, 5.0, null, false);
        builder.setUDrawable(new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                ug = ug.apply(new UChangeColor(HtmlColorUtils.BLACK));
                salt.drawU(ug, 0, new Dimension2DDouble(size.getWidth(), size.getHeight()));
                salt.drawU(ug, 1, new Dimension2DDouble(size.getWidth(), size.getHeight()));
            }
        });
        return builder.writeImageTOBEMOVED(fileFormat, os);
    }

    private ImageData exportDiagramOld(OutputStream os, int num, FileFormatOption fileFormat) throws IOException {
        Element salt = SaltUtils.createElement(this.data);
        EmptyImageBuilder builder = new EmptyImageBuilder(10, 10, Color.WHITE);
        Graphics2D g2d = builder.getGraphics2D();
        Dimension2D size = salt.getPreferredDimension(new UGraphicG2d(new ColorMapperIdentity(), g2d, 1.0).getStringBounder(), 0.0, 0.0);
        g2d.dispose();
        builder = new EmptyImageBuilder(size.getWidth() + 6.0, size.getHeight() + 6.0, Color.WHITE);
        BufferedImage im = builder.getBufferedImage();
        g2d = builder.getGraphics2D();
        g2d.translate(3, 3);
        UAntiAliasing.ANTI_ALIASING_ON.apply(g2d);
        UGraphic ug = new UGraphicG2d(new ColorMapperIdentity(), g2d, 1.0);
        ug = ug.apply(new UChangeColor(HtmlColorUtils.BLACK));
        salt.drawU(ug, 0, new Dimension2DDouble(size.getWidth(), size.getHeight()));
        salt.drawU(ug, 1, new Dimension2DDouble(size.getWidth(), size.getHeight()));
        g2d.dispose();
        ImageIO.write((RenderedImage)im, "png", os);
        return new ImageDataSimple(im.getWidth(), im.getHeight());
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescriptionImpl("(Salt)", this.getClass());
    }
}

