/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.graphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.project.Item;
import net.sourceforge.plantuml.project.Project;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class ItemHeader {
    private final UFont font = new UFont("Serif", 0, 9);
    private final Project project;
    private final FontConfiguration fontConfig = FontConfiguration.blackBlueTrue(this.font);

    public ItemHeader(Project project) {
        this.project = project;
    }

    public void draw(UGraphic ug, double x, double y) {
        StringBounder stringBounder = ug.getStringBounder();
        ug = ug.apply(new UChangeColor(HtmlColorUtils.BLACK));
        ug.apply(new UTranslate(x, y)).draw(new URectangle(this.getWidth(stringBounder), this.getHeight(stringBounder)));
        for (Item it : this.project.getValidItems()) {
            TextBlock b = Display.create("" + it.getCode()).create(this.fontConfig, HorizontalAlignment.LEFT, new SpriteContainerEmpty());
            Dimension2D dim = b.calculateDimension(stringBounder);
            b.drawU(ug.apply(new UTranslate(x, y)));
            ug.apply(new UTranslate(x, y += dim.getHeight())).draw(new ULine(this.getWidth(stringBounder), 0.0));
        }
    }

    public double getWidth(StringBounder stringBounder) {
        double width = 0.0;
        for (Item it : this.project.getValidItems()) {
            Dimension2D dim = stringBounder.calculateDimension(this.font, it.getCode());
            width = Math.max(width, dim.getWidth());
        }
        return width;
    }

    public double getHeight(StringBounder stringBounder) {
        double height = 0.0;
        for (Item it : this.project.getValidItems()) {
            Dimension2D dim = stringBounder.calculateDimension(this.font, it.getCode());
            height += dim.getHeight();
        }
        return height;
    }

    public double getPosition(StringBounder stringBounder, Item item2) {
        double pos = 0.0;
        for (Item it : this.project.getValidItems()) {
            if (it == item2) {
                return pos;
            }
            Dimension2D dim = stringBounder.calculateDimension(this.font, it.getCode());
            pos += dim.getHeight();
        }
        throw new IllegalArgumentException();
    }
}

