/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.jdot;

import h.Agedge_s;
import h.Agedgeinfo_t;
import h.bezier;
import h.splines;
import h.textlabel_t;
import java.awt.geom.Point2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.jdot.YMirror;
import net.sourceforge.plantuml.posimo.DotPath;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import smetana.core.Macro;
import smetana.core.__ptr__;
import smetana.core.__struct__;

public class JDotPath
implements UDrawable {
    private final Link link;
    private final Agedge_s edge;
    private final YMirror ymirror;
    private final CucaDiagram diagram;
    private final TextBlock label;
    private final Rose rose = new Rose();

    public JDotPath(Link link, Agedge_s edge, YMirror ymirror, CucaDiagram diagram, TextBlock label) {
        this.link = link;
        this.edge = edge;
        this.ymirror = ymirror;
        this.diagram = diagram;
        this.label = label;
    }

    private ColorParam getArrowColorParam() {
        if (this.diagram.getUmlDiagramType() == UmlDiagramType.CLASS) {
            return ColorParam.classArrow;
        }
        if (this.diagram.getUmlDiagramType() == UmlDiagramType.OBJECT) {
            return ColorParam.objectArrow;
        }
        if (this.diagram.getUmlDiagramType() == UmlDiagramType.DESCRIPTION) {
            return ColorParam.usecaseArrow;
        }
        if (this.diagram.getUmlDiagramType() == UmlDiagramType.ACTIVITY) {
            return ColorParam.activityArrow;
        }
        if (this.diagram.getUmlDiagramType() == UmlDiagramType.STATE) {
            return ColorParam.stateArrow;
        }
        throw new IllegalStateException();
    }

    @Override
    public void drawU(UGraphic ug) {
        HtmlColor color = this.rose.getHtmlColor(this.diagram.getSkinParam(), this.getArrowColorParam(), null);
        if (this.link.getColors() != null) {
            HtmlColor newColor = this.link.getColors().getColor(ColorType.ARROW, ColorType.LINE);
            if (newColor != null) {
                color = newColor;
            }
        } else if (this.link.getSpecificColor() != null) {
            color = this.link.getSpecificColor();
        }
        DotPath dotPath = this.getDotPath(this.edge);
        if (this.ymirror != null) {
            dotPath = this.ymirror.getMirrored(dotPath);
        }
        ug.apply(new UChangeColor(color)).draw(dotPath);
        if (this.getLabelRectangleTranslate() != null) {
            this.label.drawU(ug.apply(this.getLabelRectangleTranslate()));
        }
    }

    private void printDebug(UGraphic ug) {
        ug = ug.apply(new UChangeColor(HtmlColorUtils.BLUE)).apply(new UChangeBackColor(HtmlColorUtils.BLUE));
        splines splines2 = this.getSplines(this.edge);
        bezier beziers = (bezier)splines2.getPtr("list");
        for (int i = 0; i < beziers.getInt("size"); ++i) {
            Point2D pt = this.getPoint(splines2, i);
            if (this.ymirror != null) {
                pt = this.ymirror.getMirrored(pt);
            }
            ug.apply(new UTranslate(pt).compose(new UTranslate(-1.0, -1.0))).draw(new UEllipse(3.0, 3.0));
        }
        if (this.getLabelRectangleTranslate() != null && this.getLabelURectangle() != null) {
            ug = ug.apply(new UChangeColor(HtmlColorUtils.BLUE)).apply(new UChangeBackColor(null));
            ug.apply(this.getLabelRectangleTranslate()).draw(this.getLabelURectangle());
        }
    }

    private URectangle getLabelURectangle() {
        Agedgeinfo_t data = (Agedgeinfo_t)Macro.AGDATA(this.edge).castTo(Agedgeinfo_t.class);
        textlabel_t label = (textlabel_t)data.getPtr("label");
        if (label == null) {
            return null;
        }
        __struct__ dimen = label.getStruct("dimen");
        __struct__ space = label.getStruct("space");
        __struct__ pos = label.getStruct("pos");
        double x = pos.getDouble("x");
        double y = pos.getDouble("y");
        double width = dimen.getDouble("x");
        double height = dimen.getDouble("y");
        return new URectangle(width, height);
    }

    private UTranslate getLabelRectangleTranslate() {
        Agedgeinfo_t data = (Agedgeinfo_t)Macro.AGDATA(this.edge).castTo(Agedgeinfo_t.class);
        textlabel_t label = (textlabel_t)data.getPtr("label");
        if (label == null) {
            return null;
        }
        __struct__ dimen = label.getStruct("dimen");
        __struct__ space = label.getStruct("space");
        __struct__ pos = label.getStruct("pos");
        double x = pos.getDouble("x");
        double y = pos.getDouble("y");
        double width = dimen.getDouble("x");
        double height = dimen.getDouble("y");
        if (this.ymirror == null) {
            return new UTranslate(x - width / 2.0, y - height / 2.0);
        }
        return this.ymirror.getMirrored(new UTranslate(x - width / 2.0, y + height / 2.0));
    }

    public DotPath getDotPath(Agedge_s e) {
        splines splines2 = this.getSplines(e);
        return this.getDotPath(splines2);
    }

    private splines getSplines(Agedge_s e) {
        Agedgeinfo_t data = (Agedgeinfo_t)Macro.AGDATA(e).castTo(Agedgeinfo_t.class);
        splines splines2 = (splines)data.getPtr("spl");
        return splines2;
    }

    private DotPath getDotPath(splines splines2) {
        DotPath result = new DotPath();
        bezier beziers = (bezier)splines2.getPtr("list");
        Point2D pt1 = this.getPoint(splines2, 0);
        Point2D pt2 = this.getPoint(splines2, 1);
        Point2D pt3 = this.getPoint(splines2, 2);
        Point2D pt4 = this.getPoint(splines2, 3);
        result = result.addCurve(pt1, pt2, pt3, pt4);
        int n = beziers.getInt("size");
        for (int i = 4; i < n; i += 3) {
            Point2D ppt2 = this.getPoint(splines2, i);
            Point2D ppt3 = this.getPoint(splines2, i + 1);
            Point2D ppt4 = this.getPoint(splines2, i + 2);
            result = result.addCurve(ppt2, ppt3, ppt4);
        }
        return result;
    }

    private Point2D getPoint(splines splines2, int i) {
        bezier beziers = (bezier)splines2.getPtr("list");
        __ptr__ pt = beziers.getPtr("list").plus(i).getPtr();
        return new Point2D.Double(pt.getDouble("x"), pt.getDouble("y"));
    }
}

