/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.hector2.graphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.hector2.MinMax;
import net.sourceforge.plantuml.hector2.graphic.Foo1;
import net.sourceforge.plantuml.hector2.layering.Layer;
import net.sourceforge.plantuml.hector2.mpos.Distribution;
import net.sourceforge.plantuml.svek.DotDataImageBuilder;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class Foo2
extends AbstractTextBlock
implements TextBlock {
    private final Distribution distribution;
    private final CucaDiagram diagram;

    public Foo2(Distribution distribution, CucaDiagram diagram) {
        this.distribution = distribution;
        this.diagram = diagram;
    }

    public Dimension2D getMaxCellDimension(StringBounder stringBounder) {
        Dimension2D result = new Dimension2DDouble(0.0, 0.0);
        for (Layer layer : this.distribution.getLayers()) {
            Dimension2D dim = Foo1.getMaxCellDimension(stringBounder, layer, this.diagram);
            result = Dimension2DDouble.max(result, dim);
        }
        return result;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D cell2 = this.getMaxCellDimension(stringBounder);
        MinMax longitudes = this.distribution.getMinMaxLongitudes();
        double width = (double)(longitudes.getDiff() + 2) * cell2.getWidth() / 2.0;
        double height = cell2.getHeight() * this.distribution.getNbLayers();
        return new Dimension2DDouble(width, height);
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D cell2 = this.getMaxCellDimension(stringBounder);
        for (Layer layer : this.distribution.getLayers()) {
            this.drawLayer(ug, layer, cell2.getWidth(), cell2.getHeight());
            ug = ug.apply(new UTranslate(0.0, cell2.getHeight()));
        }
    }

    private void drawLayer(UGraphic ug, Layer layer, double w, double h) {
        for (IEntity ent : layer.entities()) {
            IEntityImage image = this.computeImage((ILeaf)ent);
            int longitude = layer.getLongitude(ent);
            Dimension2D dimImage = image.calculateDimension(ug.getStringBounder());
            double diffx = w - dimImage.getWidth();
            double diffy = h - dimImage.getHeight();
            image.drawU(ug.apply(new UTranslate(w * (double)longitude / 2.0 + diffx / 2.0, diffy / 2.0)));
        }
    }

    private IEntityImage computeImage(ILeaf leaf) {
        IEntityImage image = DotDataImageBuilder.createEntityImageBlock(leaf, this.diagram.getSkinParam(), false, this.diagram, null, null, null);
        return image;
    }
}

