/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic.color;

import java.util.EnumMap;
import java.util.Map;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamColors;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.LinkStyle;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.IHtmlColorSet;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class Colors {
    private final Map<ColorType, HtmlColor> map = new EnumMap<ColorType, HtmlColor>(ColorType.class);
    private LinkStyle lineStyle = null;
    private Boolean shadowing = null;

    public String toString() {
        return this.map.toString() + " " + (Object)((Object)this.lineStyle);
    }

    public static Colors empty() {
        return new Colors();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    private Colors copy() {
        Colors result = new Colors();
        result.map.putAll(this.map);
        result.lineStyle = this.lineStyle;
        return result;
    }

    private Colors() {
    }

    public Colors(String data, IHtmlColorSet set, ColorType mainType) {
        data = StringUtils.goLowerCase(data);
        StringTokenizer st = new StringTokenizer(data, "#;");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            int x = s.indexOf(58);
            if (x == -1) {
                if (s.contains(".")) continue;
                this.map.put(mainType, set.getColorIfValid(s));
                continue;
            }
            String name = s.substring(0, x);
            String value = s.substring(x + 1);
            if (name.equalsIgnoreCase("shadowing")) {
                this.shadowing = value.equalsIgnoreCase("true");
                continue;
            }
            ColorType key = ColorType.getType(name);
            HtmlColor color = set.getColorIfValid(value);
            this.map.put(key, color);
        }
        if (data.contains("line.dashed")) {
            this.lineStyle = LinkStyle.DASHED;
        } else if (data.contains("line.dotted")) {
            this.lineStyle = LinkStyle.DOTTED;
        } else if (data.contains("line.bold")) {
            this.lineStyle = LinkStyle.BOLD;
        }
    }

    public HtmlColor getColor(ColorType key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        return this.map.get((Object)key);
    }

    public HtmlColor getColor(ColorType key1, ColorType key2) {
        HtmlColor result = this.getColor(key1);
        if (result != null) {
            return result;
        }
        return this.getColor(key2);
    }

    public UStroke getSpecificLineStroke() {
        if (this.lineStyle == null) {
            return null;
        }
        return LinkStyle.getStroke(this.lineStyle);
    }

    public Colors add(ColorType type, HtmlColor color) {
        if (color == null) {
            return this;
        }
        Colors result = this.copy();
        result.map.put(type, color);
        return result;
    }

    private Colors add(ColorType colorType, Colors other) {
        Colors result = this.copy();
        result.map.putAll(other.map);
        if (other.lineStyle != null) {
            result.lineStyle = other.lineStyle;
        }
        return result;
    }

    public final LinkStyle getLineStyle() {
        return this.lineStyle;
    }

    public ISkinParam mute(ISkinParam skinParam) {
        return new SkinParamColors(skinParam, this);
    }

    public Colors addLegacyStroke(String s) {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        Colors result = this.copy();
        result.lineStyle = LinkStyle.valueOf(StringUtils.goUpperCase(s));
        return result;
    }

    public static UGraphic applyStroke(UGraphic ug, Colors colors) {
        if (colors == null) {
            return ug;
        }
        if (colors.lineStyle == null) {
            return ug;
        }
        return ug.apply(LinkStyle.getStroke(colors.lineStyle));
    }

    public Colors applyStereotype(Stereotype stereotype, ISkinParam skinParam, ColorParam param) {
        if (stereotype == null) {
            throw new IllegalArgumentException();
        }
        if (param == null) {
            throw new IllegalArgumentException();
        }
        ColorType colorType = param.getColorType();
        if (colorType == null) {
            throw new IllegalArgumentException();
        }
        if (this.getColor(colorType) != null) {
            return this;
        }
        Colors colors = skinParam.getColors(param, stereotype);
        return this.add(colorType, colors);
    }

    private Colors applyFontParamStereotype(Stereotype stereotype, ISkinParam skinParam, FontParam param) {
        if (stereotype == null) {
            throw new IllegalArgumentException();
        }
        if (param == null) {
            return this;
        }
        ColorType colorType = ColorType.TEXT;
        if (this.getColor(colorType) != null) {
            return this;
        }
        HtmlColor col = skinParam.getFontHtmlColor(stereotype, param);
        return this.add(colorType, col);
    }

    public Colors applyStereotypeForNote(Stereotype stereotype, ISkinParam skinParam, FontParam fontParam, ColorParam ... params) {
        if (stereotype == null) {
            throw new IllegalArgumentException();
        }
        if (params == null) {
            throw new IllegalArgumentException();
        }
        Colors result = this;
        for (ColorParam param : params) {
            result = result.applyStereotype(stereotype, skinParam, param);
        }
        result = result.applyFontParamStereotype(stereotype, skinParam, fontParam);
        result.shadowing = skinParam.shadowingForNote(stereotype);
        return result;
    }

    public Boolean getShadowing() {
        return this.shadowing;
    }
}

