/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockHorizontal;
import net.sourceforge.plantuml.graphic.TextBlockMarged;
import net.sourceforge.plantuml.graphic.TextBlockMinWidth;
import net.sourceforge.plantuml.graphic.TextBlockVertical2;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.posimo.Positionable;
import net.sourceforge.plantuml.posimo.PositionableImpl;
import net.sourceforge.plantuml.ugraphic.LimitFinder;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;

public class TextBlockUtils {
    private static final Graphics2D gg;

    public static TextBlock withMargin(TextBlock textBlock, double marginX, double marginY) {
        return new TextBlockMarged(textBlock, marginX, marginX, marginY, marginY);
    }

    public static TextBlock withMinWidth(TextBlock textBlock, double minWidth, HorizontalAlignment horizontalAlignment) {
        return new TextBlockMinWidth(textBlock, minWidth, horizontalAlignment);
    }

    public static TextBlock withMargin(TextBlock textBlock, double marginX1, double marginX2, double marginY1, double marginY2) {
        return new TextBlockMarged(textBlock, marginX1, marginX2, marginY1, marginY2);
    }

    public static TextBlock empty(final double width, final double height) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(width, height);
            }
        };
    }

    public static Positionable asPositionable(TextBlock textBlock, StringBounder stringBounder, Point2D pt) {
        return new PositionableImpl(pt, textBlock.calculateDimension(stringBounder));
    }

    public static TextBlock mergeLR(TextBlock b1, TextBlock b2, VerticalAlignment verticallAlignment) {
        return new TextBlockHorizontal(b1, b2, verticallAlignment);
    }

    public static TextBlock mergeTB(TextBlock b1, TextBlock b2, HorizontalAlignment horizontalAlignment) {
        return new TextBlockVertical2(b1, b2, horizontalAlignment);
    }

    public static MinMax getMinMax(TextBlock tb, StringBounder stringBounder) {
        LimitFinder limitFinder = new LimitFinder(stringBounder, false);
        tb.drawU(limitFinder);
        return limitFinder.getMinMax();
    }

    public static boolean isEmpty(TextBlock text, StringBounder dummyStringBounder) {
        if (text == null) {
            return true;
        }
        Dimension2D dim = text.calculateDimension(dummyStringBounder);
        return dim.getHeight() == 0.0 && dim.getWidth() == 0.0;
    }

    public static FontRenderContext getFontRenderContext() {
        return gg.getFontRenderContext();
    }

    public static LineMetrics getLineMetrics(UFont font, String text) {
        return font.getLineMetrics(gg, text);
    }

    public static FontMetrics getFontMetrics(Font font) {
        return gg.getFontMetrics(font);
    }

    public static TextBlock fullInnerPosition(final TextBlock bloc, final String display) {
        return new TextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                bloc.drawU(ug);
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return bloc.calculateDimension(stringBounder);
            }

            @Override
            public Rectangle2D getInnerPosition(String member, StringBounder stringBounder) {
                if (display.startsWith(member)) {
                    Dimension2D dim = this.calculateDimension(stringBounder);
                    return new Rectangle2D.Double(0.0, 0.0, dim.getWidth(), dim.getHeight());
                }
                return null;
            }
        };
    }

    static {
        BufferedImage imDummy = new BufferedImage(10, 10, 1);
        gg = imDummy.createGraphics();
    }
}

